unit u_2_diodos;
interface
{***********************************************************
"PUENTE DE DIODOS"
Autores: JRomero - Arodri
Fecha: 16-02-98

     La simulacin corresponde a un PUENTE DE DIODOS TRIFASICO
     y se observarn los siguientes parmetros:

     * tensin de entrada, contrastada con la de salida
     * corriente de carga.
     * corriente de alimentacin en la fase R
     * corriente de los TIRISTORES
     * armonicos de la intensidad de fase.
**********************************************************}

procedure Run_2_diodos;

implementation


uses
  xmatdefs,
  DIBUS,
  FilUSR,
  UCntrl,
  Simul4,
  traxp,
  variable,
  PlotMems,
  memorias,
  lib_basi,
  libep02,
  libep,
  libdig01;

const
  w = PI * 100;           {frecuencia de red=50 hz}
  periodo = 20e-3;      {periodo=2*PI/w}
  Npuntos = 1024;       {nmero de puntos de muestreo}

{*********************************************************
A continuacin los procedimientos Cirt1, Cirt2 y Funcsr de
definicin del circuito.
*********************************************************}
var
  tension_pico_F_N, valor_medio_Ud, intensidad, grados: NReal;
  {variables para visualizar en pantalla}
  mem1, mem2: Tmemoria;  {para calculo de valor medio y de armonicos}

{----------------------------------------------------------------------}

procedure CIRT1;
begin
  vg(1, 12, 13, Tension_pico_F_N);        {fase R}
  vg(2, 12, 2, Tension_pico_F_N);        {fase S}
  vg(3, 12, 3, Tension_pico_F_N);        {fase T}

  IG(0, 4, 5, 1);             { Fuente de corriente Cte. en la salida}
  r(5, 0, 0.001);          { R MEDIDA EN LA CARGA}
  r(13, 1, 0.001);        { R MEDIDA DE FASE}

  r(1, 6, 0.001);        { R medida }
  r(2, 7, 0.001);        { R medida }
  r(3, 8, 0.001);        { R medida }
  r(1, 9, 0.001);        { R medida }
  r(2, 10, 0.001);        { R medida }
  r(3, 11, 0.001);        { R medida }
end;

{----------------------------------------------------------------------}

procedure CIRT2;
begin
  Diodo(6, 4);
  Diodo(7, 4);
  Diodo(8, 4);

  Diodo(0, 9);
  Diodo(0, 10);
  Diodo(0, 11);
end;

{----------------------------------------------------------------------}

procedure FUNCSR(t: NReal);
begin
  rf[1] := sin(w * t);                  {R}
  rf[2] := sin(w * t - 2 * PI / 3);         {s}
  rf[3] := sin(w * t - 4 * PI / 3);         {t}
end;

{----------------------------------------------------------------------}

{********************************************************
A continuacin los procedimientos de inicio, fin  y Pesca
necesarios para Simeep
*********************************************************}

procedure INICIO;
begin
  nn := 13;      {nmero de nodos del circuito sin incluir 0 (Tierra)}
  nindep := 3;    {nmero de fuentes independientes}
  tinicial := 0e-3;   {tiempo incial de cada simulacin}
  tfinal := 20e-3; {tiempo final de cada simulacin}

  {valores de precisin de Simeep}
  dtmax0 := 5e-6;
  dtmin := dtmax0 / 100;
  PasoDivisor := 6;
  TmaxTmin := 1e3;

  {indicamos a TRAXP los tiempos que debe graficar}
  traxp.tinicial := tinicial;
  traxp.tfinal := tfinal;

  {inicializacin de grficos}
  {iniciegr;}

{En esta seccin, definimos el nmero de pantallas, y los colores,
 en nmero de grillas inciales, y si tenemos alguna superpocicin
 de seales en una misma ventana}

  gridx := 12;  {las divisiones en X son 12}
  gridy := 8;  {las diviciones en Y son 8}

  subplot(2, 2); {matriz de pantallas de 1 por 2}

  {definiciones de visualizacin para la pantalla 0,est asociada al canal 0}
  definaY(0, -450, 150);
  titulo('(Azul): Ud  (Rojo): i_d  fases R-S-T.');
  xlabel(' 30 /DIV');
  ylabel(' 150 V/DIV.    0.23 A/DIV');
  linea0;
  grid;
  SUPERPONGA(12, 0);
  SUPERPONGA(13, 0);
  SUPERPONGA(4, 0);
  SUPERPONGA(5, 0);
  definacolor(0, 1);
  definacolor(12, 12);
  definacolor(13, 7);
  definacolor(4, 11);
  definacolor(5, rojo);


  {definiciones de visualizacin para la pantalla 1,est asociada al canal 1}
  definaY(1, -140, 20);
  titulo('(Viole): i_Fase_R.  (Rojo) :i_Diodos.');
  xlabel(' 30/DIV');
  ylabel('    D6  D5  D4  D3  D2  D1   IR');
  linea0;
  grid;
  SUPERPONGA(6, 1);
  SUPERPONGA(7, 1);
  SUPERPONGA(8, 1);
  SUPERPONGA(9, 1);
  SUPERPONGA(10, 1);
  SUPERPONGA(11, 1);
  definacolor(1, amarillo);
  definacolor(6, ROJO);
  definacolor(7, ROJO);
  definacolor(8, ROJO);
  definacolor(9, ROJO);
  definacolor(10, ROJO);
  definacolor(11, ROJO);

  {definiciones de visualizacin para la pantalla 2,est asociada al canal 2}
  definaY(2, -900, 150);
  titulo('Tension sobre el Diodo 1.');
  xlabel(' 30 /DIV');
  ylabel(' 150 V/DIV.   ');
  linea0;
  grid;
  definacolor(2, 6);

  {definiciones de visualizacin para la pantalla 3,est asociada al canal 3}
  definaY(3, -150, 50);
  titulo(' Armnicos de la inten. de fase R');
  xlabel(' 1     5  7   11 13    17 19   23 25');
  ylabel('');
end;

{----------------------------------------------------------------------}

procedure PESCA;
var
  k, enX, grad: integer;
begin
  grados := 18000 * t; {....Para ver en el display el tiempo y los grados.}
  if grados >= 360 then
    grados := grados - 360 * Int(t / 0.02);

  intensidad := v[5] / 0.001;

  mem1.tic(t, (v[13] - v[1]) / 0.001);
  mem2.tic(t, v[4]);


  {...Pinto anotaciones sobre las graficas...}
  enX := PUNTOX + 24;
  {paso la ordenada x que pinta la onda a la variable enX por medio de la funcion puntox}

  {ANOTAR_EVENTO(N,GRAD1,GRAD2,GRAD, ENX,       y,y1a,y1b,y2a,y2b,etiqueta)}
  {alpha}ANOTAR_EVENTO(1, 31, 91, GRADOS, ENX, 87, 67, 90, 67, 90, '60');
  {120}ANOTAR_EVENTO(2, 31, 151, GRADOS, ENX, 308, 308, 308, 308, 308, '120');

  {ANOTAR_TEXTO(N,GRADOS,GRAD, enx,Y,color, ETIQUETA);}
  ANOTAR_TEXTO(1, 60, GRADOS, ENX - 8, 55, ROJO, 'URS');
  ANOTAR_TEXTO(2, 120, GRADOS, ENX - 8, 55, ROJO, 'URT');
  ANOTAR_TEXTO(3, 180, GRADOS, ENX - 8, 55, 0, 'UST');
  ANOTAR_TEXTO(4, 240, GRADOS, ENX - 8, 55, 0, 'USR');
  ANOTAR_TEXTO(5, 300, GRADOS, ENX - 8, 55, 1, 'UTR');
  ANOTAR_TEXTO(6, 345, GRADOS, ENX - 8, 55, 1, 'UTS');

  ANOTAR_TEXTO(7, 100, GRADOS, ENX - 12, 100, 12, 'UR');
  ANOTAR_TEXTO(8, 220, GRADOS, ENX - 12, 100, 7, 'US');
  ANOTAR_TEXTO(9, 340, GRADOS, ENX - 12, 100, 11, 'UT');

  ANOTAR_TEXTO(10, 240, GRADOS, ENX + 230, 160, NEGRO, 'USR');
  ANOTAR_TEXTO(11, 300, GRADOS, ENX + 230, 160, AZUL, 'UTR');


  {indicar el tiempo de simulacin a el graficador}
  traxp.t := t;

  {relacin de seales a graficar para la pantalla 0..............}
  trazo(0, v[4]);            { TENSION EN LA CARGA }
  trazo(0, 0);

  trazo(12, (v[13] - V[12]));  { TENSION EN LA FASE R }
  trazo(13, (V[2] - V[12]));   { TENSION EN LA FASE S }
  trazo(4, (V[3] - V[12]));    { TENSION EN LA FASE T }
  trazo(5, v[5] * 660000);     { Intensidad por la carga}

  {relacin de seales a graficar para la pantalla 1...............}
  trazo(1, (v[13] - V[1]) * 10000);   { Intensidad por la linea R}
  trazo(1, 0);
  trazo(6, (v[1] - V[6]) * 10000 - 20);   { Intensidad T1}
  trazo(6, 0 - 20);
  trazo(7, (v[11] - V[3]) * 10000 - 40);   { Intensidad T2}
  trazo(7, 0 - 40);
  trazo(8, (v[2] - V[7]) * 10000 - 60);   { Intensidad T3}
  trazo(8, 0 - 60);
  trazo(9, (v[9] - V[1]) * 10000 - 80);   { Intensidad T4}
  trazo(9, 0 - 80);
  trazo(10, (v[3] - V[8]) * 10000 - 100);   { Intensidad T5}
  trazo(10, 0 - 100);
  trazo(11, (v[10] - V[2]) * 10000 - 120);   { Intensidad T6}
  trazo(11, 0 - 120);

  {relacin de seales a graficar para la pantalla 2..............}
  trazo(2, (v[6] - V[4]));   { Intensidad T6}
  trazo(2, 0);

  {borrado de la pantalla despus de cada simulacin}
  if t >= tfinal then
  begin
    for k := 0 to 13 do
    begin
      gridx := 12;  {las divisiones en X son 12}
      gridy := 8;  {las diviciones en Y son 8}

      borrecanal(k, 15);
      desligue(k);
      borde;

      if k <> 3 then
      begin
        grid;
        linea0;
      end;
    end;
    mem1.fft;
    mem2.fft;
    {...........para la grafica 3, la de armonicos..........}
    {graficar: Armonicos de corriente de la fase R de alimentacion}
    gridx := 26;
    PlotMem_EspectroDePotenciaBar(3, mem1, 0, 26, rojo, azul);
    gridx := 12;  {las divisiones en X son 12}
    gridy := 12;  {las diviciones en Y son 8}
    mem1.retrocesobarrido(tfinal - tinicial);
    valor_medio_Ud := mem2.valormedio;
    mem2.retrocesobarrido(tfinal - tinicial);


    t := t - tfinal + tinicial;
  end;
end;

{----------------------------------------------------------------------}

procedure FIN;
begin
  TermineGr;    {terminar los grficos}
  HALT;
end;

{----------------------------------------------------------------------}

procedure INICIALIZACION_DE_PARAMETROS;
begin
  ticsvisualizacion := 10;{frecuencia con la que se va a mostrar las variables}
  Tension_pico_F_N := 311;{Tension fase neutro eficaz = 220}
  valor_medio_Ud := 513;
end;


{******************************PRINCIPAL*******************************}
procedure Run_2_diodos;
begin
  INICIALIZACION_DE_PARAMETROS;

  {Indicamos a Simeep donde estn las funciones que preparamos}
  FilUSR.Cirt1 := Cirt1;
  FilUSR.Cirt2 := Cirt2;
  FilUSR.FuncsR := FuncsR;
  FilUSR.Inicio := Inicio;
  FilUSR.Pesca := Pesca;
  FilUsr.Fin := Fin;
  {Pantalla de controles}
  UCntrl.init;
  mem1 := TMemoria.Create_init(20e-3 / 1024, 1024, 0, 0);
  mem2 := TMemoria.Create_init(20e-3 / 1024, 1024, 0, 0);

  {------------------PARA VISUALIZAR TEXTO EN LA SIMULACION--------------}

  UCntrl.insert(new(PCtrlVerTexto, init(0, 'RECTIFICADOR ',
    '  PUENTE DE DIODOS', ' ')));

  UCntrl.insert(new(PCtrlVerTexto, init(1, '    ', 'CARGA', 'FUENTE I=Cte.')));


  {---------------PARA CONTROLAR VARIABLES EN LA SIMULACION--------------}


  {-----------------PARA VER VARIABLES EN LA SIMULACION------------------}

  UCntrl.insertdisplay(new(PCtrlVer2Var, init
    { renglon, nombre1, uni1, deci1,  var1 , nombre2, uni2, deci2, var2}(3,
    '	Ud', 'V', 1, v[4], 'Ud_med.', 'V', 0, valor_medio_Ud)));

  UCntrl.insertdisplay(new(PCtrlVer2Var, init
    { renglon,  nombre1,  uni1, deci1,  var1 , nombre2,  uni2, deci2, var2}(2,
    'Tiempo', 'Sg', 3, t, 'Grados', '', 0, grados)));

  {----------------------------------------------------------------------}
  {Inicio de Simulaciones}
  PASEO;
  mem1.Free;
  mem2.Free;
end;


end.
