unit u_4_carac1;

interface

          {PROGRAMA QUE SIMULA LA GRAFICA DE LA
          CARACTERISTICA ESTATICA DEL RECTIFICADOR}

procedure Run_4_carac1;

implementation

uses
  wingraph, wincrt,
{$IFDEF FPC}gl, glu,{$ELSE}opengl,{$ENDIF}

  xmatdefs,
  DIBUS, RATON, FilUSR, UCntrl, Simul4, traxp, variable,
  lib_basi, libep02, libep, libdig01;

const
  w = 100 * PI;

var
  L_conmu, Alpha: NReal; {.Para controlar variables.}
  Id: NReal;
  Id_max, Rc: NREal;
  primera: boolean;

  Ud, U: NReal; {Para ver variables durante la simulacion}

  Alfa_v, R_v, L_v, Id_v, Id_max_v: NReal;

{...................................................................}

procedure GRAFICAR_CARACTERISTICA(var alfa, R, L, Id, Id_max: NReal);
var
  x1, y1, x2, y2, xpunto, ypunto: integer;
  v_salida: NReal;
const
  puntos_horizontales = 200;
  origenX = 150;
  origenY = 280;
begin
  if (alfa_v <> alfa) or (R_v <> R) or (L_v <> L) or (Id_v <> Id) or (Id_max <> Id_max) then
  begin
    SetFillStyle(1, 15); {Borro la ltima grafica}
    Bar(origenX - 59, origenY - 110, origenx + puntos_horizontales + 10, origeny + 130);

    SetLineStyle(0, 0, 3);
    SetColor(1);      {Pinto el eje de coordenadas}
    Line(origenX, origenY, origenX + puntos_horizontales + 20, origenY);
    Line(origenX, origenY - 100, origenX, origenY + 100);

    v_salida := 311 * 1.35 * cos(alfa * PI / 180);  {calculos de la coord. de la linea}
    x1 := origenX;
    y1 := Round(origenY - v_salida * 0.22);
    x2 := origenX + puntos_horizontales;
    y2 := Round(origenY - v_salida * 0.22 + (Id_max * (Rc + 300 * L)));

    SetLineStyle(0, 0, 3);                {pinto la linea}
    SetColor(12);
    Line(x1, y1, x2, y2);
    SetLineStyle(0, 0, 0);

    {calculo las coord. del punto}
    xpunto := Round(origenX + id * puntos_horizontales / Id_max);
    ypunto := Round(origenY - v_salida * 0.22 + (id * (Rc + 300 * L)));

    SetColor(12);
    FillEllipse(xpunto, ypunto, 4, 4);       {pinto el punto}
    PutPixel(xpunto, ypunto, 14);

    SetLineStyle(0, 0, 3);             {pinto la maxima caida de tension}
    SetColor(3);
    Line(x1 - 15, y1, x1 - 15, y2);
    OutTextXY(x1 - 52, y1, 'Caida');
    OutTextXY(x1 - 52, y1 + 10, 'mx.');
    OutTextXY(x1 - 52, y1 + 20, 'de Ud');

    SetColor(12);                     {pinto la caida real de tension}
    Line(x1 - 7, y1, x1 - 7, ypunto);
    OutTextXY(x1 - 52, y1 + 40, 'Caida');
    OutTextXY(x1 - 52, y1 + 50, 'Real');

    SetLineStyle(1, 0, 0);             {linea a trazos desde el punto}
    SetColor(8);
    if alfa < 90 then
      Line(xpunto, ypunto + 5, xpunto, origenY)
    else
      Line(xpunto, ypunto - 5, xpunto, origenY);
    Line(xpunto - 5, ypunto, origenx, ypunto);

    {escribo titulo y enmarco}
    SetColor(0);
    SetTextStyle(0, 0, 1);
    OutTextXY(95, 106, 'Caracterstica esttica del rectificador');
    MARCO_DESNIVEL(origenX - 60, origenY - 150, origenx + puntos_horizontales + 60,
      origeny + 150, 0, 7);
    MARCO_DESNIVEL(origenX - 80, origenY - 190, origenx + puntos_horizontales + 80,
      origeny + 170, 15, 0);


    SetTextStyle(2, 0, 5);                 {pinto etiquetas}
    SetColor(0);
    { OutTextXY(origenX-25, origenY-7,' 0');}
    OutTextXY(origenX - 15, origenY - 135, ' Ud');
    OutTextXY(origenX + puntos_horizontales + 30, origenY - 7, ' Id');

    Ud := 1.35 * 311 * Cos(alpha * PI / 180) - ((300 * L_conmu + R) * Id);

    SetLineStyle(1, 0, 0);                  {linea Idmax}
    SetColor(13);
    OutTextXY(origenX + puntos_horizontales - 20, origenY - 120, ' Id mx');
    Line(origenX + puntos_horizontales, origenY - 100, origenX + puntos_horizontales,
      origenY + 100);
    {actualizo los valores}
    alfa_v := alfa;
    R_v := R;
    L_v := L;
    Id_v := Id;
    Id_max_v := Id_max;
  end;
end;

{---------------------------------------------------------------------}

procedure PESCA;
var
  i: integer;
  coseno: NReal;
begin

  if primera = True then
  begin
    SetFillStyle(1, 1);
    Bar(16, 14, 468, 464);
    SetFillStyle(1, 7);
    Bar(150 - 80 + 1, 280 - 190 + 1, 150 + 200 + 80 - 1,
      280 + 170 - 1);
    RANGO_FILA(10, 470);
    RANGO_COLUMNA(10, 630);
    MARCO_DESNIVEL(10, 8, 474, 470, 15, 0);
    MARCO_DESNIVEL(15, 13, 469, 465, 0, 15);

    SetColor(15);
    OutTextXY(93, 40, '    Modifique los parmetros que desee y compruebe');
    OutTextXY(93, 60, 'la nueva posicin del punto de trabajo del rectificador');

    SetFillStyle(1, 15); {pinto de blanco el fondo de la grafica}
    Bar(150 - 60, 280 - 150, 150 + 200 + 60, 280 + 150);

  end;
  primera := False;

  {Calculo el tiempo de conmutacion U y de gama}
  coseno := cos(alpha * PI / 180) - w * L_conmu * id / 311;
  if (coseno > -0.00001) and (coseno < 0.000001) then
    coseno := 0.000001;
  coseno := ABS(coseno);
  U := ArcTan(SQRT(ABS(1 - SQR(coseno))) / coseno);
  if alpha > 90 then
    U := PI - U;
  U := U * 180 / pi;
  U := trunc(ABS(U - alpha));



  GRAFICAR_CARACTERISTICA(alpha, Rc, L_conmu, Id, Id_max);
end;


{---------------------------------------------------------------------}

procedure FIN;
begin
  halt;
end;


{---------------------------------------------------------------------}

procedure INICIALIZACION_PARAMETROS;
begin
  {valores iniciales de los controles}
  primera := True;
  alpha := 30;
  Rc := 4;
  id_max := 2;
end;

{---------------------------------------------------------------------}
procedure xxxx;
begin
end;

{----------------------------------------------------------------------}
{******************************PRINCIPAL*******************************}
{----------------------------------------------------------------------}
procedure Run_4_carac1;
begin
  INICIALIZACION_PARAMETROS;

  {Indicamos a Simeep donde estn las funciones que preparamos}
  Filusr.inicio := xxxx;
  FilUSR.Pesca := Pesca;
  FilUSR.Fin := Fin;

  {Pantalla de controles}
  UCntrl.init;


  {------------------PARA VISUALIZAR TEXTO EN LA SIMULACION--------------}

  UCntrl.insert(new(PCtrlVerTexto, init(1, '   CARACTERISTICA',
    '      ESTATICA', '    RECTIFICADOR')));

  UCntrl.insert(new(PCtrlVerTexto, init(4, '    CONTROL DE ',
    '   LAS VARIABLES', ' ')));


  {---------------PARA CONTROLAR VARIABLES EN LA SIMULACION--------------}

  UCntrl.insert(new(PCtrlBotonVar, Init
    {renglon, nombre,  unidad, decimales, min, max,   def, inc,    var}(5, ' L_conmu', 'mH', 0, 0, 50, 25, 5, L_CONMU)));

  UCntrl.insert(new(PCtrlBotonVar, Init
    {renglon, nombre,  unidad, decimales, min, max,   def, inc,    var}(6, 'R interna', 'oh', 1, 0, 5, 4, 0.5, Rc)));

  UCntrl.insert(new(PCtrlBotonVar, Init
    {renglon, nombre,  unidad, decimales, min, max,   def, inc,    var}(8, '   Alfa', '', 0, 0, 90, 0, 5, alpha)));

  UCntrl.insert(new(PCtrlBotonVar, Init
    {renglon, nombre,  unidad, decimales, min, max,   def, inc,    var}(7, '   Id', 'A', 1, 0, 2, 1, 0.1, id)));
  {--------------------------PARA VER VARIABLES-------------------------}

  UCntrl.insertdisplay(new(PCtrlVer2Var, init
    { renglon, nombre1, uni1, deci1,  var1 , nombre2, uni2, deci2, var2}(2, 'Ud', '', 1, Ud, 'u', '', 1, U)));


  {Inicio de Simulaciones}
  Filusr.inicio;
  while True do
  begin
    FilUsr.pesca;
  end;
end;

end.
