unit u_4_falla;
interface

procedure Run_4_falla;

implementation



{***********************************************************
"CONVERTIDOR 6 PULSOS DOS VIAS TRABAJANDO EN MODO INVERSOR A I=CTE.
 SE SIMULA UNA CAIDA DE TENSION Y LA FALLA DE CONMUTACION CORRESPONDIENTE"

Autores: JRomero - Arodri
Fecha: 16-02-98

		 La simulacin corresponde a un CONVERTIDOR 6 PULSOS DOS VIAS
		 A TIRISTORES CON INDUCTANCIA SERIE Y QUE TRABAJA EN MODO INVERSOR.
		 SE SIMULA UNA CAIDA DE TENSION DE ALIMENTACION Y SE OBSERVA EL
		 FENOMENO DE UNA FALLA DE CONMUTACION

		 y se observarn los siguientes parmetros:

		 * tensines entre fases de entrada, tension  de salida
		 * corriente de carga.
		 * corriente de alimentacin en la fase R junto a su tension de fase correspondiente
		 * corriente de los TIRISTORES 3 junto con su tension en bornes
		 * corriente de los TIRISTORES 5 y 6.
**********************************************************}

USES
wincrt,xmatdefs,wingraph, dibus, RATON,FilUSR, UCntrl, Simul4, traxp, variable,
lib_basi, libep02, libep, libdig01;

CONST w=PI*100;           {frecuencia de red=50 hz}
		periodo=20e-3;      {periodo=2*PI/w}
		Npuntos=1024;       {nmero de puntos de muestreo}
		sexrad=PI/180;      {constante de conversin de sexagesimal a rad}

var
R_carga, gama,	L_conmu,tension,alpha,  {.Para controlar variables.}
pila,	Intensidad, grados:NReal;    {variables para visualizar en pantalla}
Id, intensidad_anterior, ir, valor,	beta, U :NReal;

marca, primer_ciclo:Boolean;
t_absoluto:NReal;
t_actual,t_anterior:NReal;

	 bandera_ventana1, bandera_ventana2, bandera_ventana3,
	 bandera_ventana4, bandera_ventana5, bandera_ventana6:Boolean;

	 enX, enY1, enY2, enY3:Integer;
{----------------------------------------------------------------------}

FUNCTION disparo(k:integer): boolean;
var  vref:NREAL;
BEGIN
		vref:=-cos(alpha*sexrad);
		disparo:=(vref<=sin(w*t-2*PI/3-(k-1)*PI/3)) and (cos(w*t-2*PI/3-(k-1)*PI/3)>=0);

if t<0.001 then
	if (K=3) or (K=4) then disparo:=true; {condiciones iniciales}
END;

{----------------------------------------------------------------------}
{*********************************************************
A continuacin los procedimientos Cirt1, Cirt2 y Funcsr de
definicin del circuito.
*********************************************************}

PROCEDURE CIRT1;
BEGIN
	  vg(1,6,7, TENSION);            {R}
	  vg(2,6,8, TENSION);            {S}
	  vg(3,6,9, TENSION);     	   	{T}

	  L(7,16, L_CONMU);   	{L lnea}
	  L(8,2,  L_CONMU);		{L lnea}
	  L(9,3,  L_CONMU);		{L lnea}

	  r(7,16, 1000);			{R paralelo L Lnea}
	  r(8,2,  1000);		   {R paralelo L Lnea}
	  r(9,3,  1000);			{R paralelo L Lnea}

	  r(16,1,0.01);         {R para medir la i por fase R}

	  r(4,10, 0.01);			{R para medir i de tiristores}
	  r(4,11, 0.01);			{R para medir i de tiristores}
	  r(4,12, 0.01);			{R para medir i de tiristores}

	  r(0,13, 0.01);			{R para medir i de tiristores}
	  r(0,14, 0.01);			{R para medir i de tiristores}
	  r(0,15, 0.01);			{R para medir i de tiristores}

	  L(4,17, 0.05);           {L carga}

	  vg(0,5,0,pila);       {Tension E de carga}
	  R(17,5, R_carga);     {R de carga}
END;

{---------------------------------------------------------------------}

PROCEDURE CIRT2;
BEGIN
	  th(1,10,disparo(1));     {T1}
	  th(15,3,disparo(2));     {T2}
	  th(2,11,disparo(3));     {T3}
	  th(13,1,disparo(4));     {T4}
	  th(3,12,disparo(5));     {T5}
	  th(14,2,disparo(6));     {T6}
END;

{---------------------------------------------------------------------}

PROCEDURE FUNCSR(t:NReal);
BEGIN
rf[1]:=sin(w*t);        	{R}
rf[2]:=sin(w*t -2*PI/3);	{S}
rf[3]:=sin(w*t -4*PI/3);	{T}
END;

{---------------------------------------------------------------------}

{********************************************************
A continuacin los procedimientos de inicio, fin  y Pesca
necesarios para Simeep
*********************************************************}



procedure Sound( k, j: integer );
begin
  writeln('Hola');
end;

PROCEDURE INICIO;
BEGIN
nn:=17;			{nmero de nodos del circuito sin incluir 0 (Tierra)}
nindep:=3;		{nmero de fuentes independientes}
tinicial:=0e-3;   {tiempo incial de cada simulacin}
tfinal:=20e-3; {tiempo final de cada simulacin}

{Valores iniciales de variables de estado.
 Estas se definen en el orden en que aparecen las inductancias
 y Capacitancias en Cirt1}

{x0[1]:= -0.991557;		{corresponde a Lconm R}
{x0[2]:=  0.965521;		{corresponde a Lconm S}
{x0[3]:=  0.026036;		{corresponde a Lconm T}

x0[1]:= 0;		{corresponde a Lconm R}
x0[2]:= 0;		{corresponde a Lconm S}
x0[3]:= 0;		{corresponde a Lconm T}

x0[4]:=6;	{corresponde a L carga}

{valores de precisin de Simeep}
dtmax0:=10e-6;
dtmin:=dtmax0/100;
PasoDivisor:=6;
TmaxTmin:=1e3;

{indicamos a TRAXP los tiempos que debe graficar}
traxp.tinicial:=tinicial;
traxp.tfinal:=tfinal;

{En esta seccin, definimos el nmero de pantallas, y los colores,
 en nmero de grillas inciales, y si tenemos alguna superpocicin
 de seales en una misma ventana}

gridx:=12;	{las divisiones en X son 12}
gridy:=8;	{las diviciones en Y son 8}
subplot(1,2); {matriz de pantallas de 1 por 1}

{definiciones de visualizacin para la pantalla 0, que
 est asociada al canal 0}
definaY(0,-200, 50);
titulo('(Azul):Ud.  vRS         vRT         vST         vSR          vTR          vTS');
xlabel('30/DIV');
ylabel('50 V/DIV.  (Amarillo):E   (Rojo):id');
linea0;
grid;

{asociamos otros canales a la pantalla 0}
superponga(2,0);
superponga(3,0);
superponga(4,0);
superponga(5,0);
superponga(6,0);
superponga(7,0);
superponga(15,0);
superponga(11,0);

{definimos otros colores para algunos de los canales}
definacolor(0, azul);
definacolor(2, violeta);
definacolor(3, 10);
definacolor(4, 0);
definacolor(5, marron);
definacolor(6, 8);
definacolor(7, 15);
definacolor(11, 12);
definacolor(15, 14);


{definiciones de visualizacin para la pantalla 1, que
 est asociada al canal 1}
definaY(1,-140, 20);
titulo(' (Morado): inten. tiristores.  (Amarillo): iR.   (Rojo): uR.   (Verde): uT3.');
xlabel('30/DIV');
ylabel('   T6      T5       T3    iR,vR');
linea0;
grid;

{asociamos otros canales a la pantalla 1}
superponga(8, 1);
superponga(9, 1);
superponga(10,1);
superponga(12,1);
superponga(13,1);
superponga(9,1);
superponga(14,1);

definacolor(1, amarillo);
definacolor(8,  5);
definacolor(9,  5);
definacolor(10, 5);
definacolor(12, 5);
definacolor(13, 10);
definacolor(9, rojo);
definacolor(14, 5);
END;

{---------------------------------------------------------------------}

PROCEDURE PESCA;
var   coseno, seno:NReal; k,grad:integer;
		pendiente, error:NReal;

BEGIN
grados:=18000*t; {....Para ver en el display el tiempo y los grados.}
if grados>=360 then grados:=grados-360*Int(t/0.02);

t_actual:=TRUNC(t*1000);
if t_Actual<>t_anterior then t_absoluto:=t_absoluto+0.001;
t_anterior:=t_actual;

if (t_absoluto>0.01) and (t_absoluto<0.04) then     {caida de tension red}
begin
  tension:=30;
 if bandera_ventana2=TRUE then
begin
Sound(60,100);
PONER_VENTANA(150,300,405,400,
'      A partir de este momento',
'     se produce una caida en la',
'      tension de alimentacion',
' ' );
bandera_ventana2:=FALSE;

end;
 marca:=true;
 end
 else begin
		if t_absoluto<0.055 then tension:=100;
		if marca=true then  {la tension se recupera y disminuimos alfa}
						  begin
								  if (bandera_Ventana5=TRUE) then
								  begin
								  Sound(60,100);
								  PONER_VENTANA(150,300,410,400,
										'      A partir de este momento',
										'la seal de red recupera su antiguo',
										'  valor de tension de alimentacion',
										' ' );
								 bandera_ventana5:=FALSE;
								 end;

						  if t_absoluto<0.055 then
						  alpha:=140
						  else
						  begin
						  marca:=false;
						  {y ahora pongo los botones}
		PUNTERO_OFF;
		UCntrl.insert(new(PCtrlBotonVar,Init
		{renglon, nombre,  unidad, decimales, min, max,   def, inc,    var}
		(    6, ' L_CONMU',  'mH'    ,1,       1,  10,     7, 0.5, L_CONMU)));


		UCntrl.insert(new(PCtrlBotonVar,Init
		{renglon, nombre,  unidad, decimales, min, max,   def, inc,    var}
		(    8, ' V_Fase',  'V'      ,0,       40,  100,    100, 5, tension)));

		UCntrl.insert(new(PCtrlBotonVar,Init
		{renglon, nombre,  unidad, decimales, min, max,   def, inc,    var}
		(    7, ' Id=Cte',  'A'        ,1,       0,  10,       5, 1, ID)));
		PUNTERO_ON;
		end;
		end;
	 end;


	if (t_absoluto>0.005) and (bandera_ventana1=true) then
	begin
	Sound(60,100);
	PONER_VENTANA(150,300,410,400,
			'    En este momento el convertidor ',
			'esta trabajando a corriente constante ',
			'',
			' ' );
  bandera_ventana1:=FALSE;
  end;


	if (t_absoluto>0.015) AND (bandera_ventana3=true)
	then
	begin
	Sound(60,100);
	PONER_FLECHITA(576,285,false);
	PONER_VENTANA(195,200,495,300,
			'Darse cuenta que el ngulo de disparo (ALFA)',
			'         aumenta para compensar la ',
			'     subida de la intensidad de salida',
			' ' );

	SetFillStyle(1,1); Bar(566,285,586,325);
	bandera_ventana3:=FALSE;
	end;


	if (t_absoluto>0.030) and (bandera_ventana4=true) then
	begin
	Sound(60, 100);
  	PONER_FLECHITA(135,335,FALSE);
	PONER_FLECHITA(135,385,FALSE);
	  PONER_VENTANA(240,300,582,400,
			'  Se produce una falla de conmutacin entre los',
			' tiristores 3 y 5. El T3 se debera bloquear pero ',
			' no ha tenido tiempo ni de anularse su intensidad ',
			'      y ya se ha polarizado directamente.' );

  bandera_ventana4:=FALSE;
  end;

	if (t_absoluto>0.032) and (bandera_ventana5=true) then
	begin
	Sound(60, 100);
	PONER_FLECHITA(190,140,FALSE);
	PONER_VENTANA(200,150,560,250,
			'        Poco despues la tensin de salida cae ',
			' a cero porque a entrado en conduccin el tiristor 6 ',
			'       y el tiristor 3 aun sigue conduciendo.',
			'  Han quedado unidos los dos bornes de la salida.' );
	bandera_ventana5:=FALSE;
	end;



	if (t_absoluto>0.056) and (bandera_ventana6=true) then
	begin
	Sound(600, 100);
	Sound(60, 500);
	PONER_VENTANA(120,300,440,400,
			'      En este momento el convertidor vuelve',
			' a trabajar correctamente a corriente constante  ',
			'   Interactue con las variables para estudiar ',
			'         el comportamiento del circuito' );
  bandera_ventana6:=FALSE;
  end;



		  {Calculo el tiempo de conmutacion Uk y de GAMA}
coseno:=cos(alpha*PI/180)-w*L_conmu*2*intensidad/ (SQRT(3)*tension);
if (coseno>-0.00001) AND (coseno<0.000001) then coseno:=0.000001;
coseno:=ABS(coseno);
U:=ArcTan(SQRT(ABS(1-SQR(coseno)))/coseno);
if alpha>90 then U:=PI-U;
u:=u*180/pi;
U:=ABS(U-alpha);
gama:=180-alpha-U;


ir:=v[16]-v[1]; {calculo la intensidad de fase R}
Intensidad:=(v[17]-v[5])/R_carga; {calculo dce la i de carga}
Beta:=180-alpha;  {calculo de beta}

								{REALIMENTACION}
error:=intensidad-Id;
if Abs(error)>ID/R_carga then
						  begin
						  alpha:=alpha + error*0.005;
							  if alpha>170 then
							  begin
							  alpha:=170;
							  end;
						  end;



if (alpha<150) and (ABS(gama)>10) then
begin
{...Pinto anotaciones sobre las graficas...}
enX:=PUNTOX+24; {paso la ordenada x que pinta la onda a la variable enX por medio de la funcion puntox}

{ANOTAR_EVENTO(GRAD1,GRAD2,GRAD, ENX,       y,y1a,y1b,y2a,y2b,etiqueta)}
{alpha}ANOTAR_EVENTO(1,30,30+alpha+1,grados, enx,70,38,100,60,enY2, CHR(224));

{ANOTAR_EVENTO(GRAD1,GRAD2,GRAD, ENX,       y,y1a,y1b,y2a,y2b,etiqueta)}
{Uu}ANOTAR_EVENTO(2,30+alpha+1,30+alpha+U+1, grados,enx,100,97,enY2-22,97,enY2, 'U');

{ANOTAR_EVENTO(GRAD1,GRAD2,GRAD, ENX,       y,y1a,y1b,y2a,y2b,etiqueta)}
{gamau}ANOTAR_EVENTO(5,30+alpha+U+1, 180+30, grados,enx,217,90,220,190,220, 'Gama');

{ANOTAR_EVENTO(GRAD1,GRAD2,GRAD, ENX,       y,y1a,y1b,y2a,y2b,etiqueta)}
{beta}ANOTAR_EVENTO(6,30+alpha+1, 180+30, grados,enx,80,77,enY2-66,77,200, 'Beta');

{ANOTAR_EVENTO(GRAD1,GRAD2,GRAD, ENX,       y,y1a,y1b,y2a,y2b,etiqueta)}
{Ui}ANOTAR_EVENTO(4,-30+alpha+1,-30+alpha+U+1, grados,enx,403,400,433,400,eny3, 'U');

{ANOTAR_EVENTO(GRAD1,GRAD2,GRAD, ENX,       y,y1a,y1b,y2a,y2b,etiqueta)}
{gamai}ANOTAR_EVENTO(3,alpha-90+U+1, alpha-90+U+gama+1, grados,enx,310,307,335,307,335, 'Gama');
end;


{indicar el tiempo de simulacin a el graficador}
traxp.t:=t;
{relacin de seales a graficar con los canales deseados}


{....grafica 0................................................}
trazo(0,v[4]);                     { TENSION EN LA CARGA R-L-E }
trazo(0,0);
enY1:=PUNTOY+22; {paso la ordenada y que pinta la onda a la variable enY por medio de la funcion puntox}
  if alpha<150 then
  {RELLENAR_EVENTO(GRAD1,     GRAD2,    GRADOS,ENX,  y1,   y2,   color)}
  RELLENAR_EVENTO(30+alpha, 30+alpha+U, grados,enx, enY1, enY2,    14);


trazo(2,v[7]-v[8]);                { TENSION de fase R-S }
enY2:=PUNTOY+22; {paso la ordenada y que pinta la onda a la variable enY por medio de la funcion puntox}

trazo(3,v[7]-v[9]);                { TENSION de fase R-T }
trazo(4,v[8]-v[9]);                { TENSION de fase S-T }
trazo(5,v[8]-v[7]);                { TENSION de fase S-R }
trazo(6,v[9]-v[7]);                { TENSION de fase T-R }
trazo(7,v[9]-v[8]);                { TENSION de fase T-S }

SetLineStyle(0,0,3);
trazo(11, (v[17]-v[5])*10 /10);{ Int por R de carga}
SetLineStyle(0,0,0);

trazo(15, v[5]);                   { TENSION de E }

{.............................grafica 1................................}
trazo(1, (v[16]-v[1])    *80);              { i fase R }
trazo(1,0);
trazo(9, (v[7]-v[6])*0.08    );              { v fase R }


trazo(10, (v[11]-v[4])  *220-40);    { intensidad por T3 }
trazo(10,0-40);                    	{ tension en el  T3 }
if (grados>alpha-90+U+1)  and (grados<alpha-90+U+120) then
					trazo(13, (v[8]-v[9])*0.12-40)
					else

if (grados>alpha-90+U+120)  and (grados<alpha-90+U+120+119-u) then
					trazo(13, (v[8]-v[7])*0.12-40)  {tension en el T3}
					else
					trazo(13, -40);


trazo(8,  (v[12]-v[4])  *220-80);     { intensidad por T5 }
trazo(8,0-80);


trazo(14,  (v[0]-v[14])  *220-120);     { intensidad por T6 }
trazo(14,0-120);
enY3:=PUNTOY+262; {paso la ordenada y que pinta la onda a la variable enY por medio de la funcion puntox}




	{borrado de la pantalla despus de cada simulacin}
	if t >= tfinal then
	begin
		for k:= 0 to 15 do
		begin
		borrecanal(k,0);
		desligue(k);
		borde;
		grid;
		linea0;
		end;
		t:=t-tfinal+tinicial;
	end;
END;


{---------------------------------------------------------------------}

PROCEDURE FIN;
BEGIN
	halt;
END;


{---------------------------------------------------------------------}

PROCEDURE INICIALIZACION_PARAMETROS;
BEGIN
{valores iniciales de los parametros que no se controlan}
t_absoluto:=0;
t_anterior:=0;
tension:=100;
intensidad_anterior:=10;
alpha:=120;
  R_carga:=10;
  pila:=150;
primer_ciclo:=TRUE;
marca:=false;
bandera_ventana1:=TRUE;
bandera_ventana2:=TRUE;
bandera_ventana3:=TRUE;
bandera_ventana4:=TRUE;
bandera_ventana5:=TRUE;
bandera_ventana6:=TRUE;
l_conmu:=2e-3;
id:=5;
END;

procedure Run_4_falla;
{----------------------------------------------------------------------}
{******************************PRINCIPAL*******************************}
{----------------------------------------------------------------------}
BEGIN
INICIALIZACION_PARAMETROS;

{Indicamos a Simeep donde estn las funciones que preparamos}
FilUSR.Cirt1:=Cirt1;
FilUSR.Cirt2:=Cirt2;
FilUSR.FuncsR:=FuncsR;
FilUSR.Inicio:=Inicio;
FilUSR.Pesca:=Pesca;
FilUSR.Fin:=Fin;

{Pantalla de controles}
UCntrl.init;
INSIGNIA(502,14,'',120,42);
{------------------PARA VISUALIZAR TEXTO EN LA SIMULACION--------------}

UCntrl.insertdisplay(new(PCtrlVerTexto,init
(    0,'  INVERSOR A I=Cte. ',
		 '        CARGA',
		 '      R - L - E')));

UCntrl.insertdisplay(new(PCtrlVerTexto,init
(    9,' FALLA DE CONMUTACION ',
		 '         POR ',
		 'CAIDA DE SEAL DE RED ')));


{---------------PARA CONTROLAR VARIABLES EN LA SIMULACION--------------}


{-----------------PARA VER VARIABLES EN LA SIMULACION------------------}

UCntrl.insertdisplay(new(PCtrlVer2Var,init
{ renglon, nombre1, uni1, deci1,  var1 , nombre2, uni2, deci2, var2}
(    5,  CHR(225),  '',      1  ,  Beta,  CHR(224),  '',   1 , Alpha)));


UCntrl.insertdisplay(new(PCtrlVer2Var,init
{ renglon, nombre1, uni1, deci1,  var1 , nombre2, uni2, deci2, var2}
(    3, 'u',  '',      1  ,  U , 'Gama',  '',   1 , gama)));


UCntrl.insertdisplay(new(PCtrlVer2Var,init
{ renglon,  nombre1,  uni1, deci1,  var1 , nombre2,  uni2, deci2, var2}
(    1,    'Tiempo',   'Sg',   3  ,  t_absoluto ,  'Grados',  '',    0 ,Grados)));


UCntrl.insertdisplay(new(PCtrlVer2Var,init
{ renglon, nombre1, uni1, deci1,  var1 , nombre2, uni2, deci2, var2}
(    2, 'v_carga',  'V',     1  , v[4] , 'i_carga', 'A',   3 , Intensidad)));

UCntrl.insertdisplay(new(PCtrlVer2Var,init
{ renglon, nombre1, uni1, deci1,  var1 , nombre2, uni2, deci2, var2}
(    4 ,'E',  'V',    1  , Pila , 'R_carga', 'Ohm', 1 , R_carga)));

{----------------------------------------------------------------------}
{Inicio de Simulaciones}
PASEO;
end;


END.
