unit u_conred54;
interface
{
***********************************************************
"Puente de tiristores: notches"
Autores: JRomero - Arodri
Fecha: 18-04-98

		 * tensines de entrada (todas las de  linea),
		 contrastada con la de salida tomando como carga
		 una fuente de corriente.
		 * tensiones uRS en U1 y uRS en U2.

		 OBS: para implementar el disparo por el control arcocoseno
		 se toma como referencia a la fase R y se supone que esta es
		 Vp sin(w*t).
**********************************************************
}

procedure Run_conred54;

implementation
uses
wincrt, xmatdefs, FilUSR, UCntrl, Simul4, traxp, variable,
lib_basi, libep02, libep, libdig01, memorias, dibus;

const w=PI*100;           {frecuencia de red=50 hz}
		sexrad=PI/180;      {constante de conversin de sexagesimal a rad}
		periodo=20e-3;      {periodo=2*PI/w}
		grillay=10;          {divisiones de la grilla en y}
		grillax=12;			  {divisiones de la grilla en x}
		nper=1;				  {nmero de periodos a visualizar   (nper>=1)}
		rshunt=0.001;		  {valor de resitencias de medicin de corriente}
		NumeroPuntos=512;		{puntos de muestreo}
		LN=1e-3;					{inductancia en la linea}

var   alpha,lcc,wt:NReal;
		{ variables definidas para muestrear UD}
		UD,
		tMuestra,
		NMuestra:Nreal;
		mem1:Tmemoria;

(*********************************************************************
  Funcin para el disparo del tiristor.
*********************************************************************)
{
	El parmetro ALPHA es tomado como control del disparo del tiristor.
}

function disparo(k:integer): boolean;
var vref:NREAL;
begin
	vref:=-cos(alpha*sexrad);
	disparo:=(vref <= sin(w*t - 2*PI/3 - (k-1) * PI/3)) and (cos(w*t - 2*PI/3 - (k-1) * PI/3)>=0);
{	DISPARO:=TRUE;}
end;

(***********************************************************************
	Funciones de definicin del circuito

	Cirt1: componentes no booleanos
	Cirt2: componentes booleanos
***********************************************************************)

procedure cirt1;
begin
vg(1,11,12,311);							{generador R de 220 Vrms}
vg(2,11,13,311);							{generador S de 220 Vrms}
vg(3,11,14,311);							{generador T de 220 Vrms}

{U1}
l(12,15,lN);
r(12,15,1000);
l(13,16,lN);
r(13,16,1000);
l(14,17,lN);
r(14,17,1000);

{U2}
l(15,1,lcc);
r(15,1,1000);
l(16,2,lcc);
r(16,2,1000);
l(17,3,lcc);
r(17,3,1000);


{resistencias de medicin de corrientes}
r(1,4,rshunt);
r(2,5,rshunt);
r(3,6,rshunt);
r(1,8,rshunt);
r(2,9,rshunt);
r(3,10,rshunt);

ig(0,7,0,10);								{fuente de corriente Id=1 A}

end;

procedure cirt2;
begin
th(4,7,disparo(1));							{Tiristor 1}
th(0,10,disparo(2));							{Tiristor 2}
th(5,7,disparo(3));							{Tiristor 3}
th(0,8,disparo(4));							{Tiristor 4}
th(6,7,disparo(5));							{Tiristor 5}
th(0,9,disparo(6));							{Tiristor 6}
end;


(************************************************************************
	Definicin de la seal del generador VG[1]
************************************************************************)
procedure funcsr(t:NReal);
begin
rf[1]:=sin(w*t);				{R}
rf[2]:=sin(w*t-2*PI/3);    {S}
rf[3]:=sin(w*t-4*PI/3);    {T}
end;




(************************************************************************
	Procedimientos necesarios de Simeep:

	inicio:	inicializacin de simulaciones, def. de pantalla,etc
	pesca: 	captura e impresin en pantalla de variables observadas
	fin:     procedimiento de finalizacin

************************************************************************)

procedure inicio;
begin
	nn:=17;					{nmero de nodos, sin incluir tierra (0)}
	nindep:=3;     		{nmero de funciones definidas en funcsr = numero de generadores}
	tinicial:=0;			{tiempo inicial de la simulacin}
	tfinal:=nper*periodo;	{tiempo final de la simulacin}


	{parmetros de simulacin}
	dtmax0:=5e-6;
	dtmin:=dtmax0/100;
	PasoDivisor:=6;
	TmaxTmin:=1e3;

	{inicializacin de la unidad de grficos}
	traxp.tinicial:=tinicial;
	traxp.tfinal:=tfinal;

	{corrientes iniciales de Lccs}
	x0[1]:=-7.9633468206E-5;
	x0[2]:=-10.124321997;
	x0[3]:=10.12440163;
	x0[4]:=-7.9633468206E-5;
	x0[5]:=-10.124321997;
	x0[6]:=10.12440163;

	{inicializacin del modo grfico}
	iniciegr;

	{grillas en pantalla}
	gridx:=grillax;
	gridy:=grillay;

	{matriz de visualizacin de 1 por 4}
	subplot(1,3);


	{primera pantalla}
	definaY(0,-750,150);
	titulo('uD(t) (amarillo) y tensiones de linea: +-RS(rojo),+-ST(negro),+-TR(negro)');
	xlabel('30/DIV');
	ylabel('150 V/DIV');
	linea0;
	grid;

	{segunda pantalla}
	definaY(1,-750,150);
	titulo('Tensin uRS1 en el borne del puente (U2)');
	xlabel('30 /DIV');
	ylabel('150V/DIV');
	grid;

	{tercera pantalla}
	definaY(2,-750,150);
	titulo('Tensin uRS2 antes de Lcc (U1)');
	xlabel('30/DIV');
	ylabel('150 V/DIV');
	linea0;
	grid;

	{canal 11,3,4,5,6,7 en la misma pantalla que el canal 0}
	superponga(8,0);
	superponga(3,0);
	superponga(4,0);
	superponga(5,0);
	superponga(6,0);
	superponga(7,0);



	{colores a mostrar por canal}

	{primera pantalla}
	definacolor(0,amarillo);			{uD}
	definacolor(8,rojo);			{RS}
	definacolor(3,negro);      {ST}
	definacolor(4,negro);       {TR}
	definacolor(5,rojo);			{RS}
	definacolor(6,negro);      {ST}
	definacolor(7,negro);       {TR}

	{segunda pantalla}
	definacolor(1,rojo);

	{segunda pantalla}
	definacolor(2,azul);


end;

{____________________________________________________________________}

procedure fin;
begin
TermineGr;
halt;
end;

{____________________________________________________________________}

procedure pesca;

var   k,enx,eny1:integer;
		grados:NReal;
begin

	traxp.t:=t;					{indicamos a traxp el tiempo de simulacin}
	wt:=w/sexrad*t;


	{*etiquetas de grficas*}
	grados:=(w/sexrad)*t;
	enX:=PUNTOX+21; {paso la ordenada x que pinta la onda a la variable enX por medio de la funcion puntox}
	{ANOTAR_EVENTO(numeracin, GRAD1,GRAD2,GRAD, ENX, y,y1a,y1b,y2a,y2b,etiqueta)}
	{alpha}ANOTAR_EVENTO(1,30,30+alpha,grados,enx,30,25,140,25,140, CHR(224));


	{captura de valores}

	{primera pantalla}
	trazo(8,v[12]-v[13]);			{RS}
	trazo(3,v[13]-v[14]);      {ST}
	trazo(4,v[14]-v[12]);       {TR}
	trazo(5,v[13]-v[12]);			{SR}
	trazo(6,v[14]-v[13]);      {TS}
	trazo(7,v[12]-v[14]);       {RT}
	trazo(0,v[7]+10);			{uD}
	trazo(0,v[7]-10);			{uD}

	{segunda pantalla}
	trazo(1,v[1]-v[2]);


	{tercerda pantalla}
	trazo(2,v[15]-v[16]);


	{etiquetas}
	ANOTAR_TEXTO(5,26+alpha,grados,enx,15, amarillo,'1->5');
	ANOTAR_TEXTO(6,86+alpha,grados,enx,15, amarillo,'2->6');
	ANOTAR_TEXTO(7,146+alpha,grados,enx,15, amarillo,'3->1');
	ANOTAR_TEXTO(8,206+alpha,grados,enx,15, amarillo,'4->2');
	ANOTAR_TEXTO(9,266+alpha,grados,enx,15, amarillo,'5->3');
	ANOTAR_TEXTO(10,320+alpha,grados,enx,15, amarillo,'6->4');


	{pesca de UD para muestreo}
	if tMuestra>=periodo/6 then
	begin
		tMuestra:=0;
		NMuestra:=NMuestra+1;

		mem1.fft;
		ud:=mem1.ValorMedio;
		mem1.retrocesobarrido(periodo/6);
	end
	else tMuestra:=t-NMuestra*periodo/6;
	mem1.tic(tMuestra,v[7]);

	if t >= tfinal then
	begin
	{llegamos al final de la simulacin}

		{para el muestreo de UD}
		tMuestra:=0;
		NMuestra:=0;

		for k:= 0 to 8 do
		begin
			borrecanal(k,0);
			desligue(k);
			borde;
			grid;
			linea0;

		end;

		{nueva simulacin}
		t:= t-tfinal+tinicial;


	end;



end;


(*********************************************************************
 Principal
*********************************************************************)
procedure Run_conred54;
BEGIN
	quita:=5;			{separaciones de pantallas}

	{para el muestreo de UD}
	UD:=470;	{valor "inicial", antes de hacer el primer calculo}
	NMuestra:=0;
	tMuestra:=0;
	mem1:= TMemoria.Create_init(periodo/6/128,128,0,0);


	{decimos a simeep donde estan nuestras funciones}
	FilUSR.Cirt1:=Cirt1;
	FilUSR.Cirt2:=Cirt2;
	FilUSR.FuncsR:=FuncsR;
	FilUSR.Inicio:=Inicio;
	FilUSR.Pesca:=Pesca;
	FilUSR.Fin:=Fin;

	{definicin de controles}
	UCntrl.init;

	UCntrl.insertdisplay(new(PCtrlVerTexto, init
	{ rnglon, texto1  ,            texto2,             texto3}
	(	0,	'Puente de tiristores','con iL=Id para','visualizar los notches')));

	UCntrl.insertdisplay(new(PCtrlVerTexto, init
	{ rnglon, texto1  ,            texto2,             texto3}
	(	1,	'uRS vista desde U1 y','U2, con LN=1mH.','')));


	UCntrl.insert(new(PCtrlBotonVar,Init
	{renglon, nombre,   unidad,decimales, min, max,   def, inc,    var}
	(  8,   ' Disparo',  ''  ,0        ,   0, 20,     10,  1,  alpha)));

	UCntrl.insert(new(PCtrlBotonVar,Init
	{renglon, nombre,   unidad,decimales, min, max,   def, inc,    var}
	(  7,   ' Lcc',  'mH'  ,0        ,   1, 20,     10,  1,  lcc)));

	UCntrl.insertdisplay(new(PCtrlVer2Var,init
	{ renglon, nombre1, uni1,deci1,var1 ,nombre2, uni2,deci2,var2}
	(       6, '  <uD>',  'V',  0  ,ud ,'   wt', '',  1  ,wt)));

	paseo;												  {simulacin}

	mem1.Free;
end;
end.
