unit u_conred55;

interface

{
***********************************************************
"Puente de tiristores:
 Contenido de armnicos de la corriente de fase R"

Autores: JRomero - Arodri
Fecha: 18-04-98

    * Se observara la corriente de fase R de un puente de tiristores
    y se podr variar u entre 0 y 10

**********************************************************
}

procedure Run_conred55;

implementation

uses
  wincrt, xmatdefs, FilUSR, UCntrl, Simul4, traxp, variable,
  lib_basi, libep02, libep, libdig01, memorias, PlotMems, dibus;

const
  w = PI * 100;           {frecuencia de red=50 hz}
  sexrad = PI / 180;      {constante de conversin de sexagesimal a rad}
  periodo = 20e-3;      {periodo=2*PI/w}
  grillay = 10;          {divisiones de la grilla en y}
  grillax = 12;        {divisiones de la grilla en x}
  nper = 1;          {nmero de periodos a visualizar   (nper>=1)}
  rshunt = 0.001;      {valor de resitencias de medicin de corriente}
  NumeroPuntos = 512;    {puntos de muestreo}
  Up = 311;          {tensin pico de linea}

var
  id, u, alpha, alpharad, lcc: NReal;
  id_boton, alpha_boton, lcc_boton: NReal;  {para realizar el loop de Hasta Nuevo valor}
  LOOP_NUEVO_VALOR: boolean;

  {variable de muestreo}
  mem1: Tmemoria;


(***********************************************************************
  Funciones de definicin del circuito

  Cirt1: componentes no booleanos
  Cirt2: componentes booleanos
***********************************************************************)

procedure cirt1;
begin
  ig(1, 0, 1, 1);              {corriente iR de 220 Vrms}
  r(1, 0, 1);
end;

procedure cirt2;
begin
end;


(************************************************************************
  Definicin de la seal del generador VG[1]
************************************************************************)
procedure funcsr(t: NReal);
var
  aux, wt: NReal;

  function ik(v: NReal): NReal;
  var
    aux: NReal;
  begin
    if lcc = 0 then
      ik := 0
    else
      ik := (1.4142 * Up) / (w * lcc) * (cos(alpharad) - cos(alpharad + v));
  end;

begin
  alpharad := alpha * sexrad;
  wt := w * t;
  aux := cos(alpharad) - w * Lcc * Id / (1.4142 * Up);
  u := ArcTan(sqrt(1 - sqr(aux)) / aux) - alpharad;

  if wt < (PI / 12 + alpharad) then
    aux := 0
  else
  if wt < (PI / 12 + alpharad + u) then
    aux := ik(wt - PI / 12 - alpharad)
  else
  if wt < (PI / 12 + alpharad + 2 * PI / 3) then
    aux := Id
  else
  if wt < (PI / 12 + alpharad + u + 2 * PI / 3) then
    aux := Id - ik(wt - (PI / 12 + 2 * PI / 3) - alpharad)
  else
  if wt < (PI + PI / 12 + alpharad) then
    aux := 0
  else
  if wt < (PI + PI / 12 + alpharad + u) then
    aux := -ik(wt - (PI + PI / 12) - alpharad)
  else
  if wt < (PI + PI / 12 + alpharad + 2 * PI / 3) then
    aux := -Id
  else
  if wt < (PI + PI / 12 + alpharad + u + 2 * PI / 3) then
    aux := -Id + ik(wt - (PI + PI / 12 + 2 * PI / 3) - alpharad)
  else
    aux := 0;

  rf[1] := aux;

  u := u / sexrad;
end;




(************************************************************************
  Procedimientos necesarios de Simeep:

  inicio:  inicializacin de simulaciones, def. de pantalla,etc
  pesca:   captura e impresin en pantalla de variables observadas
  fin:     procedimiento de finalizacin

************************************************************************)

procedure inicio;
begin
  nn := 1;          {nmero de nodos, sin incluir tierra (0)}
  nindep := 1;         {nmero de funciones definidas en funcsr = numero de generadores}
  tinicial := 0;      {tiempo inicial de la simulacin}
  tfinal := nper * periodo;  {tiempo final de la simulacin}


  {parmetros de simulacin}
  dtmax0 := 5e-6;
  dtmin := dtmax0 / 100;
  PasoDivisor := 6;
  TmaxTmin := 1e3;

  {inicializacin de la unidad de grficos}
  traxp.tinicial := tinicial;
  traxp.tfinal := tfinal;

  {inicializacin del modo grfico}
  iniciegr;

  {grillas en pantalla}
  gridx := grillax;
  gridy := grillay;

  {matriz de visualizacin de 1 por 4}
  subplot(1, 2);


  {primera pantalla}
  definaY(0, -5, 1);    {*****funcion de iR falla para I grande*****}
  titulo('iR');
  xlabel('30/DIV');
  ylabel('1 A/DIV');
  linea0;
  grid;

  {segunda pantalla}
  definaY(1, 0, 10);
  titulo('Magnitudes de armnicos (1-25) respecto al primero.');

  DefinaColor(0, rojo);

end;

{____________________________________________________________________}

procedure fin;
begin
  TermineGr;
  halt;
end;

{____________________________________________________________________}

procedure pesca;

var
  k: integer;
begin

  if not LOOP_NUEVO_VALOR then
  begin
    traxp.t := t;          {indicamos a traxp el tiempo de simulacin}

    trazo(0, v[1]);
    mem1.tic(t, v[1]);


    if t >= tfinal then
    begin

      {mostrar espectros en pantalla1}
      borrecanal(1, 0);
      desligue(1);
      borde;
      gridx := 23;
      mem1.fft;
      PlotMem_EspectroUnU1Bar_0_25(1, mem1);
      mem1.RetrocesoBarrido(Periodo);
      gridx := grillax;
      gridy := grillay;


      if (alpha_boton = alpha) and (lcc_boton = lcc) and (id_boton = id) then
      begin
        LOOP_NUEVO_VALOR := True;
        while ((alpha_boton = alpha) and (lcc_boton = lcc) and (id_boton = id)) do
        begin
          FilUsr.Pesca;
        end;

        alpha := alpha_boton;
        lcc := lcc_boton;
        id := id_boton;

        LOOP_NUEVO_VALOR := False;
      end
      else
      begin
        alpha := alpha_boton;
        lcc := lcc_boton;
        id := id_boton;
      end;


      {llegamos al final de la simulacin}

      {pantalla 0}
      borrecanal(0, 0);
      desligue(0);
      borde;
      grid;
      linea0;

      {nueva simulacin}
      t := t - tfinal + tinicial;

    end;

  end;
end;


(*********************************************************************
 Principal
*********************************************************************)
procedure Run_conred55;
begin
  quita := 10;      {separaciones de pantallas}

  {para setear el sistema de LOOP por nuevo valor}
  LOOP_NUEVO_VALOR := False;
  alpha := 0;
  lcc := 0;
  id := 2;

  {muestreo}
  mem1 := TMemoria.Create_init(periodo / NumeroPuntos, NumeroPuntos, 0, 0);

  {decimos a simeep donde estan nuestras funciones}
  FilUSR.Cirt1 := Cirt1;
  FilUSR.Cirt2 := Cirt2;
  FilUSR.FuncsR := FuncsR;
  FilUSR.Inicio := Inicio;
  FilUSR.Pesca := Pesca;
  FilUSR.Fin := Fin;


  {definicin de controles}
  UCntrl.init;

  UCntrl.insertdisplay(new(PCtrlVerTexto, init
    { rnglon, texto1  ,            texto2,             texto3}
    (0, 'Puente de tiristores', 'con iL=Id para ver el', 'espectro de pot. de iR')));

  UCntrl.insertdisplay(new(PCtrlVer2Var, init(6, ' u. comm.', '',
    2, u, 'tiempo', 'S', 5, t)));

  UCntrl.insert(new(PCtrlBotonVar, Init
    {renglon, nombre,   unidad,decimales, min, max,   def, inc,    var}
    (7, ' Id', 'A', 0, 1, 5, 2, 1, id_boton)));

  UCntrl.insert(new(PCtrlBotonVar, Init
    {renglon, nombre,   unidad,decimales, min, max,   def, inc,    var}
    (8, ' Disparo', '', 0, 0, 30, 0, 1, alpha_boton)));

  UCntrl.insert(new(PCtrlBotonVar, Init
    {renglon, nombre,   unidad,decimales, min, max,   def, inc,    var}
    (9, '  L comm.', 'mH', 0, 0, 40, 0, 1, lcc_boton)));

  paseo;                          {simulacin}

  mem1.Free;
end;

end.
