(*
			======================================================
			INVERSORES: CURSO BASICO BASADO EN EL SIMULADOR SIMEEP
			======================================================


Simul02.cir

+-----------------------------------------------------------------+
|		 Instituto de Ingeniera Elctrica                            |
|		 Facultad de Ingeniera                                       |
|		 Universidad de la Repblica                                  |
|                                                                 |
|		 http://www.iie.edu.uy/docs/potencia/simeep.htm               |
|		 e-mail: gcp@iie.edu.uy  rch@iie.edu.uy  wu@iie.edu.uy        |
+-----------------------------------------------------------------+

*)


program usuario;
{$F+}
uses winCRT, xMatDefs, FilUSR,
		Simul2,
      traxp,variable,lib_basi,libep02,libep, Memorias, PlotMems, UCntrl;

const
	NCiclos = 3; { Nmero de ciclos de un barrido }
	uControl: NReal = 0.1; { entrada al comando arcoseno (-1,1)}
	rshnt= 0.001; { resistencia para medidas de corriente }

	Periodo = 20E-3; { 50Hz }
	NPuntosDeLasMemorias = 1024 div 2;
	UltimaArmonicaAGraficar: integer = 10;
	PeriodoDeMuestreoDeLasMemorias = Periodo{*NCiclos} / (NPuntosDeLasMemorias);

	Edc: NReal = 200; { Tensin de la fuente de continua }
	Iac: NReal = 10; { Amplitud de la corriente de carga }
	d_a: NReal = 0; { atraso de la a(t) respecto de la carga en p.u. del peiodo}
	RetardoRamaB: NReal = 0.5; { Atraso de la ramaB respecto de la A en p.u. }
	Tabla_d1: NReal = 0.5/2;
	distorsion: NReal = 0;
	r1:NReal = 0;
	r3:Nreal = 0;
	r5:NReal = 0;
	r7:NREal = 0;
	r9:NREal =0;
	r11: NReal =0;

var
	mem1,  mem2: TMemoria;

procedure cirt1;
begin
	vg(0, 0, 1, Edc/2);
	vg(0, 7, 0, Edc/2);
	Ig(1, 5, 6, Iac);

	r(1,2,rshnt);
	r(2,3,rshnt);
	r(4,5,rshnt);

end; (* cirt1 *)


function tablaconmutacion( d: NReal ): boolean;
begin
	if d<tabla_d1 then tablaconmutacion:= true
	else
		tablaconmutacion:= false;
		{
		if d<tabla_d2 then tablaconmutacion:= false
		else
			if d<tabla_d3 then tablaconmutacion:= true
			else tablaconmutacion:= true;
			}
end;

function a(t:NReal):boolean;
var
	d: NReal;
begin
	d:= Frac(t/Periodo);
	while  d<0 do d:= d+1;
	if d>0.5 then d:= 1-d;
	if d>0.25 then a:= not( tablaconmutacion( 0.5-d))
	else a:= tablaconmutacion(d);
end;


procedure cirt2;
begin
	ll2p(3, 4, 7, a(t));
	ll2p(2, 6, 7, a(t-RetardoRamaB*Periodo));
end;

procedure funcsr(t: NReal);
begin
	rf[1]:= cos(2*pi*t/Periodo + d_a*pi/180);
end;


procedure inicio;
begin


nn:=7;
nindep:=1;


tinicial:=0;
tfinal:=Periodo*nciclos;
dtmax0:=(tfinal-tinicial)/2000;

PasoDivisor:=6;

TmaxTmin:=1000;

traxp.tinicial:=tinicial;
traxp.tfinal:=tfinal;

iniciegr;

gridx:= 10;
gridy:= 10;
subplot(2,2);

definaY(0,-10,20/gridy);
ylabel('2A/DIV');
titulo('Idc');
grid;
linea0;

definaY(1,-250,50);
ylabel('50V/DIV');
titulo('Vac (Azul) - Iac (Rojo)');
grid;
linea0;

activecanal(2);
titulo('EspectPot(idc)');
xlabel('1n/DIV');

activecanal(3);
titulo('EspectPot(vac)');
xlabel('1n/DIV');

superponga(4,1);
definacolor(4, rojo);

end;


procedure fin;
begin
	readln;
	TermineGr;
end;

procedure pesca;
var
	tecla: char;
	idc, iac, i_2_4: NReal;
	k: integer;

begin
	traxp.t:=t;

	idc:=(v[1]-v[2])/rshnt;
	mem1.tic( t, idc);
	trazo(0, idc);

	mem2.tic(t, v[5]-v[6]);
	trazo(1, v[5]-v[6]);

	iac:= (v[4]-v[5])/rshnt;
	trazo(4, iac*10);


	if t >= tfinal then
	begin
		{
		PlotMem_t( 4, mem1, 1, NPuntosDeLasMemorias);
		}
		mem1.fft;
		borrecanal(2,0);
		desligue(2);
		borde;
		PlotMem_EspectroUn( 2, mem1, 0, UltimaArmonicaAGraficar );
		mem2.fft;
		distorsion:= mem2.DistorsionArmonica_25;
		r1:= mem2.PotenciaARmonica(1);
		r3:= sqrt(mem2.PotenciaARmonica(3)/r1);
		r5:= sqrt(mem2.PotenciaARmonica(5)/r1);
		r7:= sqrt(mem2.PotenciaARmonica(7)/r1);
		r9:= sqrt(mem2.PotenciaARmonica(9)/r1);
		r11:= sqrt(mem2.PotenciaARmonica(11)/r1);
		borrecanal(3,0);
		desligue(3);
		borde;
		PlotMem_EspectroUnU1( 3, mem2, 0, UltimaArmonicaAGraficar);
		gridy:= 10;
		gridx:=10;
		for k:= 0 to 1 do
		begin
			borrecanal(k,0);
			desligue(k);
			grid;
			borde;
			linea0;
		end;
			borrecanal(4,0);
			desligue(4);
			grid;
			borde;
			linea0;
		t:= t-tfinal+tinicial;
		mem1.RetrocesoBarrido(tfinal-tinicial);
		mem2.RetrocesoBarrido(tfinal-tinicial);
	end;
end;

begin
FilUSR.Cirt1:=Cirt1;
FilUSR.Cirt2:=Cirt2;
FilUSR.FuncsR:=FuncsR;
FilUSR.Inicio:=Inicio;
FilUSR.Pesca:=Pesca;

{ Inicializacin de las memorias }
mem1:= TMemoria.Create_init(	PeriodoDeMuestreoDeLasMemorias, NPuntosDeLasMemorias, 0, 0);
mem2:= TMemoria.Create_init(	PeriodoDeMuestreoDeLasMemorias, NPuntosDeLasMemorias, 0, 0);

{ Inicializamos la lista de controles. }
UCntrl.init;


{ Agregamos un control que es solamente un ttulo }
UCntrl.insert(new(PCtrlTexto, init(
			1,             { nmero del renglon en la banda de texto }
			'CONTROLES:'
			))); { nmero de caracteres del intertexto }

{ Agregamos control de la variable real d_a }
UCntrl.insert(new(PCtrlNRealInc, Init(
			'f',           { letra de control }
			2,             { nmero del renglon en la banda de texto }
			'F.P.:',        { Texto antes del valor }
			'[deg]', { texto posterior al valor }
			6, 1,          { Formato del valor Campo:Decimales }
			0, 180, 1, 1,  {Valmin, ValMax, ValDef, ValInc }
			d_a            { Variable controlada }
			)));

UCntrl.insert( new(PCtrlProcedure, Init(
			's',
			12,
			'Retorno)  =  Salir',
			fin )));  { variable controlada }

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			4,             { nmero del renglon en la banda de texto }
			'Dst.Arm.:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			6,3,          { Formato del valor Campo }
			distorsion            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			5,             { nmero del renglon en la banda de texto }
			'U3/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			8,3,          { Formato del valor Campo }
			r3            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			6,             { nmero del renglon en la banda de texto }
			'U5/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			8,3,          { Formato del valor Campo }
			r5            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			7,             { nmero del renglon en la banda de texto }
			'U7/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			8,3,          { Formato del valor Campo }
			r7            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			8,             { nmero del renglon en la banda de texto }
			'U9/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			8,3,          { Formato del valor Campo }
			r9           { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			9,             { nmero del renglon en la banda de texto }
			'U11/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			r11          { Variable controlada }
			)));


paseo;
fin;

{ destruccin de las memorias }
mem1.Free;
mem2.Free;

end.
