(*
			======================================================
			INVERSORES: CURSO BASICO BASADO EN EL SIMULADOR SIMEEP
			======================================================


Simul05.cir

+-----------------------------------------------------------------+
|		 Instituto de Ingeniera Elctrica                            |
|		 Facultad de Ingeniera                                       |
|		 Universidad de la Repblica                                  |
|                                                                 |
|		 http://www.iie.edu.uy/docs/potencia/simeep.htm               |
|		 e-mail: gcp@iie.edu.uy  rch@iie.edu.uy  wu@iie.edu.uy        |
+-----------------------------------------------------------------+

*)

program usuario;
{$F+}
uses winCRT, xMatDefs, FilUSR,
		Simul2,traxp,variable,lib_basi,libep02,libep,libdig01,
		Memorias, PlotMems, uCntrl;

const
	NCiclos = 2; { Nmero de ciclos de un barrido }
	uControl: NReal = 0.1; { entrada al comando arcoseno (-1,1)}
	rshnt= 0.001; { resistencia de para medidas de corriente }

	Periodo = 20E-3; { 50Hz }
	p: integer = 9; {pulsacion de la portadora}
	pmax = 31; pmin = 3;

	NPuntosDeLasMemorias = 1024 div 2;
	PeriodoDeMuestreoDeLasMemorias = Periodo{*NCiclos} / NPuntosDeLasMemorias;

	Edc: NReal = 200; { Tensin de la fuente de continua }
	Iac: NReal = 10; { Amplitud de la corriente de carga }
	d_a: NReal = 0; { atraso de la a(t) respecto de la carga en p.u. del peiodo}
	RetardoRamaB: NReal = 0.25; { Atraso de la ramaB respecto de la A en p.u. }
	Tabla_d1: NReal = 0.5/2;
	m: NReal = 0.6; {indice de modulacion}
	distorsion: NReal = 0;
	r1:NReal = 0;
	r3:Nreal = 0;
	r5:NReal = 0;
	r7:NREal = 0;
	r9:NREal =0;
	r11: NReal =0;

var
	mem1,  mem2: TMemoria;
	Per_tri : NReal;

procedure cirt1;
begin
	vg(0, 0, 1, Edc/2);
	vg(0, 7, 0, Edc/2);
	Ig(1, 5, 6, Iac);

	r(1,2,rshnt);
	r(2,3,rshnt);
	r(4,5,rshnt);

end; (* cirt1 *)


function tablaconmutacion( d: NReal ): boolean;
begin
	if d<tabla_d1 then tablaconmutacion:= true
	else
		tablaconmutacion:= false;
		{
		if d<tabla_d2 then tablaconmutacion:= false
		else
			if d<tabla_d3 then tablaconmutacion:= true
			else tablaconmutacion:= true;
			}
end;

function referencia(t:NReal):NReal;
begin
	referencia:= m * sin(2*pi*t/Periodo);
end;

function menosrefe(t:NReal):NReal;
begin
	menosrefe:= -m * sin(2*pi*t/Periodo);
end;

function A(t:NReal):boolean;
var
	d: NReal;
begin

	A:= triangular(t/ Per_tri) > menosrefe(t);
end;

function B(t:NReal):boolean;
var
	d: NReal;
begin

	B:= triangular(t/ Per_tri) > referencia(t);
end;

function filtroA:boolean;
begin
	filtroA:= sin(2*pi*t/Periodo )  > 0;
end;

procedure cirt2;
begin
	ll2p(3, 4, 7, A(t));
	ll2p(2, 6, 7, B(t));
end;

procedure funcsr(t: NReal);
begin
	rf[1]:= sin(2*pi*t/Periodo -  d_a*pi/180);
end;


procedure inicio;
begin

Per_tri:= Periodo / p;

nn:=7;
nindep:=1;


tinicial:=0;
tfinal:=Periodo*nciclos;
dtmax0:=(tfinal-tinicial)/4000;

PasoDivisor:=10;

TmaxTmin:=2000;

traxp.tinicial:=tinicial;
traxp.tfinal:=tfinal;

iniciegr;

gridx:= 10;
gridy:= 10;
subplot(2,2);

definaY(0,-15,30/gridy);
ylabel('3A/DIV');
titulo('Idc');
grid;
linea0;

definaY(1,-500,100);
ylabel('100V/DIV - 10A/DIV');
titulo('Vac(A) Iac(R) portadora y modulante');
grid;
{linea0;}

activecanal(2);
titulo('Espectro de Idc (Un)');
xlabel('3n/DIV');

activecanal(3);
titulo('Espectro de Vac (Un/U1)');
xlabel('3n/DIV');

superponga(4,1);
definacolor(4, Rojo);

superponga(5,1);


superponga(6,1);
definacolor(6, Rojo);
superponga(7,1);
definacolor(7, Verde);



end;


procedure fin;
begin
	readln;
	TermineGr;
end;

procedure pesca;
var
	tecla: char;
	idc, iac, i_2_4: NReal;
	k: integer;

begin
	traxp.t:=t;


	Per_tri:= Periodo/p;
	dtmax0:= Per_tri/100;

	idc:=(v[1]-v[2])/rshnt;
	mem1.tic( t, idc);
	trazo(0, idc);

	mem2.tic(t, v[5]-v[6]);
	trazo(1, (v[5]-v[6])+200);

	iac:= (v[4]-v[5])/rshnt;
	trazo(4, iac*10+200);

	trazo(5, triangular(t/ Per_tri)*100-300);
	trazo(6, referencia(t)*100-300);
	trazo(7, menosrefe(t)*100-300);

	if t >= tfinal then
	begin
		mem1.fft;
		borrecanal(2,0);
		desligue(2);
		borde;
		PlotMem_EspectroUn( 2, mem1, 0, 30 );
		mem2.fft;
		distorsion:= mem2.DistorsionArmonica_25;
		r1:= mem2.PotenciaARmonica(1);
		r3:= sqrt(mem2.PotenciaARmonica(3)/r1);
		r5:= sqrt(mem2.PotenciaARmonica(5)/r1);
		r7:= sqrt(mem2.PotenciaARmonica(7)/r1);
		r9:= sqrt(mem2.PotenciaARmonica(9)/r1);
		r11:= sqrt(mem2.PotenciaARmonica(11)/r1);

		borrecanal(3,0);
		desligue(3);
		borde;
		PlotMem_EspectroUnU1( 3, mem2, 0, 30);


		gridy:= 10;
		gridx:=10;
		for k:= 0 to 1 do
		begin
			borrecanal(k,0);
			desligue(k);
			grid;
			borde;
			linea0;
		end;
		for k:=4 to 7 do
		begin
			borrecanal(k,0);
			desligue(k);
			grid;
			borde;
{			linea0;}
		end;
{		t:= t-tfinal+tinicial;}
		t:= 0;
		mem1.RetrocesoBarrido(tfinal-tinicial);
		mem2.RetrocesoBarrido(tfinal-tinicial);
	end;

end;


begin
FilUSR.Cirt1:=Cirt1;
FilUSR.Cirt2:=Cirt2;
FilUSR.FuncsR:=FuncsR;
FilUSR.Inicio:=Inicio;
FilUSR.Pesca:=Pesca;

{ Inicializacin de las memorias }
mem1:= TMemoria.Create_init(	PeriodoDeMuestreoDeLasMemorias, NPuntosDeLasMemorias, 0, 0);
mem2:= TMemoria.Create_init(	PeriodoDeMuestreoDeLasMemorias, NPuntosDeLasMemorias, 0, 0);

uCntrl.init;

{ Agregamos un control que es solamente un ttulo }
UCntrl.insert(new(PCtrlTexto, init(
			1,             { nmero del renglon en la banda de texto }
			'CONTROLES:'
			))); { nmero de caracteres del intertexto }

{ Agregamos control de la variable real d_a }
UCntrl.insert(new(PCtrlNRealInc, Init(
			'f',           { letra de control }
			3,             { nmero del renglon en la banda de texto }
			'F.P.:',        { Texto antes del valor }
			'[deg]', { texto posterior al valor }
			5, 1,          { Formato del valor Campo:Decimales }
			0, 180, 1, 1,  {Valmin, ValMax, ValDef, ValInc }
			d_a            { Variable controlada }
			)));


UCntrl.insert( new(PCtrlProcedure, Init(
			's',
			15,
			'Retorno)  =  Salir',
			fin )));  { variable controlada }


UCntrl.insert(new(PCtrlNRealInc, Init(
			'm',           { letra de control }
			4,             { nmero del renglon en la banda de texto }
			'ind. mod.:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			6, 3,          { Formato del valor Campo:Decimales }
			0.3, 0.95, 0.3, 0.1,  {Valmin, ValMax, ValDef, ValInc }
			m            { Variable controlada }
			)));


UCntrl.insert(new(PCtrlNEntero, Init(
			'p',           { letra de control }
			5,             { nmero del renglon en la banda de texto }
			'frec. pul.:',        { Texto antes del valor }
			'[u]', { texto posterior al valor }
			6,          { Formato del valor Campo }
			pmin, pmax, pmin, 2,  {Valmin, ValMax, ValDef, ValInc }
			p            { Variable controlada }
			)));


UCntrl.insertDisplay( new(PDsplyNReal, Init(
			7,             { nmero del renglon en la banda de texto }
			'Dst.Arm.:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			8,3,          { Formato del valor Campo }
			distorsion            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			8,             { nmero del renglon en la banda de texto }
			'U3/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			8,3,          { Formato del valor Campo }
			r3            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			9,             { nmero del renglon en la banda de texto }
			'U5/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			8,3,          { Formato del valor Campo }
			r5            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			10,             { nmero del renglon en la banda de texto }
			'U7/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			8,3,          { Formato del valor Campo }
			r7            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			11,             { nmero del renglon en la banda de texto }
			'U9/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			8,3,          { Formato del valor Campo }
			r9           { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			12,             { nmero del renglon en la banda de texto }
			'U11/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			8,3,          { Formato del valor Campo }
			r11          { Variable controlada }
			)));


paseo;
fin;

{ destruccin de las memorias }
mem1.Free;
mem2.Free;

end.
