(*
			======================================================
			INVERSORES: CURSO BASICO BASADO EN EL SIMULADOR SIMEEP
			======================================================


Simul07.cir

+-----------------------------------------------------------------+
|		 Instituto de Ingeniera Elctrica                            |
|		 Facultad de Ingeniera                                       |
|		 Universidad de la Repblica                                  |
|                                                                 |
|		 http://www.iie.edu.uy/docs/potencia/simeep.htm               |
|		 e-mail: gcp@iie.edu.uy  rch@iie.edu.uy  wu@iie.edu.uy        |
+-----------------------------------------------------------------+

*)

program usuario;
{$F+}
uses winCRT, xMatDefs, FilUSR,
		Simul2,traxp,variable,lib_basi,libep02,libep,
		libdig01, Memorias, PlotMems, uCntrl,
		tabrama, pwm_modo;

const
	NCiclos = 1; { Nmero de ciclos de un barrido }
	uControl: NReal = 0.1; { entrada al comando arcoseno (-1,1)}
	rshnt= 0.001; { resistencia para medidas de corriente }

	Periodo = 20E-3; { 50Hz }
	per = 20E-3;
	pw = per/2;
	NPuntosDeLasMemorias = 1024 div 2;
	PeriodoDeMuestreoDeLasMemorias = Periodo{*NCiclos} / (NPuntosDeLasMemorias);
	a1: NReal = 18.93;
	a2: NReal = 36.78;
	a3: NReal = 49.08;
	Edc: NReal = 200; { Tensin de la fuente de continua }
	Iac: NReal = 10; { Amplitud de la corriente de carga }
	d_a: NReal = 0; { atraso de la a(t) respecto de la carga en p.u. del peiodo}
	RetardoRamaB: NReal = 0.5; { Atraso de la ramaB respecto de la A en p.u. }
	Tabla_d1: NReal = 0.5/2;
	distorsion: NReal = 0;
	r1:NReal = 0;
	r3:Nreal = 0;
	r5:NReal = 0;
	r7:NREal = 0;
	r9:NREal =0;
	r11: NReal =0;

var
	mem1,  mem2: TMemoria;
	Barredor: TTablaRama;
	kArmonicosAEliminar: fila;
	nArmonicosAEliminar: integer;
	Modulacion: NReal;
	dtmincc: NReal;
	ModoEliminacion, ModElim: integer;

procedure cirt1;
begin
	vg(0, 0, 1, Edc/2);
	vg(0, 7, 0, Edc/2);
	Ig(1, 5, 6, Iac);

	r(1,2,rshnt);
	r(2,3,rshnt);
	r(4,5,rshnt);
	r(2,8,rshnt);

end; (* cirt1 *)


function a(t:NReal):boolean;
begin
	case ModElim of
	3: a:= Barredor.Salida(t/Periodo);
	2: a:= Barredor.Salida(t/Periodo);
	1: a:= not( frac( t/Periodo ) < 0.5);
	end;
end;


function b(t: NReal): boolean;
begin
	case ModElim of
	3: b:= frac( t/Periodo ) < 0.5;
	2: b:= not( Barredor.Salida(t/Periodo));
	1: b:= Barredor.Salida(t/Periodo);
	end;
end;


procedure cirt2;
begin
	ll2p(3, 4, 7, a(t));
	ll2p(8, 6, 7, b(t));
end;

procedure funcsr(t: NReal);
begin
	rf[1]:= -sin(2*pi*t/Periodo -  d_a*pi/180);
end;






procedure CrearBarredor(
	var Barredor: TTablaRama;
	var kArmonicosAEliminar: fila;
	Modulacion: NReal;
	NArmonicosAEliminar: integer );
var
	res: boolean;
	k: integer;
begin
	ModElim:= ModoEliminacion;
	determinarmodo( ModoEliminacion);
	Barredor:= TTablaRama.Create_InitDim( NArmonicosAEliminar + 1);
	res:= CalcAng(
		kArmonicosAEliminar,
		NArmonicosAEliminar + 1,
		Modulacion,
		vector(pointer(@Barredor.pv[1])^));
	for k:= 1 to Barredor.n do
		Barredor.pon_e(k, Barredor.e(k)/ dospi );
	dtmincc:=Barredor.MinimoTiempoEntreConmutaciones*Periodo;
	dtmax:= dtmincc/3;
	dtmincc:= dtmincc*1e6;
end;




procedure inicio;
begin


nn:=8;
nindep:=1;


tinicial:=0;
tfinal:=Periodo*nciclos;
dtmax0:=(tfinal-tinicial)/2000;

PasoDivisor:=6;

TmaxTmin:=1000;

traxp.tinicial:=tinicial;
traxp.tfinal:=tfinal;

iniciegr;

gridx:= 10;
gridy:= 10;
subplot(2,2);

definaY(0,-24, 80/gridy);
ylabel('8A/DIV');
titulo('Idc (Azul)  Ia1 (Rojo)  Ib1 (Verde)');
grid;
{linea0;}

definaY(1,-250,50);
ylabel('50V/DIV  -  5A/DIV');
titulo('Vac (Azul) - Iac (Rojo)');
grid;
linea0;


activecanal(2);
titulo('Espectro de Idc (Un)');
xlabel('6n/DIV');

activecanal(3);
titulo('Espectro de Vac (Un/U1)');
xlabel('6n/DIV');

superponga(4,0);
definacolor(4,Rojo);

superponga(5,0);
definacolor(5,Verde);

superponga(6,1);
definacolor(6,Rojo);

end;


procedure fin;
begin
	readln;
	TermineGr;
end;

procedure pesca;
var
	tecla: char;
	idc, iac, ia1, ib1: NReal;
	k: integer;

begin
	traxp.t:=t;

	idc:=(v[1]-v[2])/rshnt;
	mem1.tic( t, idc);
	trazo(0, idc-8);

	ia1:= (v[2]-v[3])/rshnt;
	trazo(4,ia1+16);

	ib1:= (v[2]-v[8])/rshnt;
	trazo(5,ib1+40);

	mem2.tic(t, v[5]-v[6]);
	trazo(1, v[5]-v[6]);

	iac:= (v[4]-v[5])/rshnt;
	trazo(6, iac*10);

	if t >= tfinal then
	begin
		Barredor.Free;
		CrearBarredor(
			Barredor,
			kArmonicosAEliminar,
			Modulacion,
			NArmonicosAEliminar );

		mem1.fft;
		borrecanal(2,0);
		desligue(2);
		borde;

		PlotMem_EspectroUn( 2, mem1, 0, 60 );

		mem2.fft;
		distorsion:= mem2.DistorsionArmonica_25;
		r1:= mem2.PotenciaARmonica(1);
		r3:= sqrt(mem2.PotenciaARmonica(3)/r1);
		r5:= sqrt(mem2.PotenciaARmonica(5)/r1);
		r7:= sqrt(mem2.PotenciaARmonica(7)/r1);
		r9:= sqrt(mem2.PotenciaARmonica(9)/r1);
		r11:= sqrt(mem2.PotenciaARmonica(11)/r1);

		borrecanal(3,0);
		desligue(3);
		borde;
		PlotMem_EspectroUnU1( 3, mem2, 0, 60);

		gridy:= 10;
		gridx:=10;
		for k:= 0 to 1 do
		begin
			borrecanal(k,0);
			desligue(k);
			grid;
			borde;
			linea0;
		end;
		for k:= 4 to 5 do
		begin
			borrecanal(k,0);
			desligue(k);
			grid;
			borde;
{			linea0;}
		end;
			borrecanal(6,0);
			desligue(6);
			grid;
			borde;
			linea0;
		t:= t-tfinal+tinicial;
		mem1.RetrocesoBarrido(tfinal-tinicial);
		mem2.RetrocesoBarrido(tfinal-tinicial);
	end;
end;



begin
FilUSR.Cirt1:=Cirt1;
FilUSR.Cirt2:=Cirt2;
FilUSR.FuncsR:=FuncsR;
FilUSR.Inicio:=Inicio;
FilUSR.Pesca:=Pesca;

{ Inicializacin de las memorias }
mem1:= TMemoria.Create_init(	PeriodoDeMuestreoDeLasMemorias, NPuntosDeLasMemorias, 0, 0);
mem2:= TMemoria.Create_init(	PeriodoDeMuestreoDeLasMemorias, NPuntosDeLasMemorias, 0, 0);

ModoEliminacion:= 2;
ModElim:= 2;

for nn:= 1 to MMax do
	kArmonicosAEliminar[nn]:= (nn-1)*2+1;

NArmonicosAEliminar:= 10;
Modulacion:= 0.6;

CrearBarredor(
	Barredor,
	kArmonicosAEliminar,
	Modulacion, NArmonicosAEliminar );

uCntrl.init;

{ ++++++++++++++++++++++++++
			 Controles
+++++++++++++++++++++++++++}

{ Agregamos un control que es solamente un ttulo }
UCntrl.insert(new(PCtrlTexto, init(
			1,             { nmero del renglon en la banda de texto }
			'CONTROLES:'
			))); { nmero de caracteres del intertexto }

{ Agregamos control de la variable real d_a }
UCntrl.insert(new(PCtrlNRealInc, Init(
			'f',           { letra de control }
			3,             { nmero del renglon en la banda de texto }
			'F.P.:',        { Texto antes del valor }
			'[deg]', { texto posterior al valor }
			5, 1,          { Formato del valor Campo:Decimales }
			0, 180, 1, 1,  {Valmin, ValMax, ValDef, ValInc }
			d_a            { Variable controlada }
			)));


UCntrl.insert( new(PCtrlProcedure, Init(
			's',
			17,
			'Retorno)  =  Salir',
			fin )));  { variable controlada }


UCntrl.insert(new(PCtrlNRealInc, Init(
			'u',           { letra de control }
			4,             { nmero del renglon en la banda de texto }
			'u1:',        { Texto antes del valor }
			'[p.u.]', { texto posterior al valor }
			6, 2,          { Formato del valor Campo:Decimales }
			0.1, 0.75, 0.6, 0.05,  {Valmin, ValMax, ValDef, ValInc }
			Modulacion            { Variable controlada }
			)));

UCntrl.insert(new(PCtrlNEntero, Init(
			'm',           { letra de control }
			5,             { nmero del renglon en la banda de texto }
			'M-1:',        { Texto antes del valor }
			'[u]', { texto posterior al valor }
			6,          { Formato del valor Campo }
			1, 18, 10, 1,  {Valmin, ValMax, ValDef, ValInc }
			NArmonicosAEliminar  { Variable controlada }
			)));



UCntrl.insert(new(PCtrlNEntero, Init(
			'q',           { letra de control }
			6,             { nmero del renglon en la banda de texto }
			'MODO:',        { Texto antes del valor }
			'', { texto posterior al valor }
			6,          { Formato del valor Campo }
			1, 3, 2, 1,  {Valmin, ValMax, ValDef, ValInc }
			ModoEliminacion  { Variable controlada }
			)));


{ ++++++++++++++++++++++++++
			 Displays
+++++++++++++++++++++++++++}
UCntrl.insertDisplay( new(PDsplyNReal, Init(
			8,             { nmero del renglon en la banda de texto }
			'Dst.Arm.:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			6,3,          { Formato del valor Campo }
			distorsion            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			9,             { nmero del renglon en la banda de texto }
			'U3/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			6,3,          { Formato del valor Campo }
			r3            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			10,             { nmero del renglon en la banda de texto }
			'U5/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			6,3,          { Formato del valor Campo }
			r5            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			11,             { nmero del renglon en la banda de texto }
			'U7/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			6,3,          { Formato del valor Campo }
			r7            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			12,             { nmero del renglon en la banda de texto }
			'U9/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			6,3,          { Formato del valor Campo }
			r9           { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			13,             { nmero del renglon en la banda de texto }
			'U11/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			6,3,          { Formato del valor Campo }
			r11          { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			15,             { nmero del renglon en la banda de texto }
			'dtmin:',        { Texto antes del valor }
			'[us]', { texto posterior al valor }
			6,1,          { Formato del valor Campo }
			dtmincc          { Variable controlada }
			)));

paseo;
fin;

{ destruccin de las memorias }
mem1.Free;
mem2.Free;

end.
