(*
			======================================================
			INVERSORES: CURSO BASICO BASADO EN EL SIMULADOR SIMEEP
			======================================================


Simul09.cir

+-----------------------------------------------------------------+
|		 Instituto de Ingeniera Elctrica                            |
|		 Facultad de Ingeniera                                       |
|		 Universidad de la Repblica                                  |
|                                                                 |
|		 http://www.iie.edu.uy/docs/potencia/simeep.htm               |
|		 e-mail: gcp@iie.edu.uy  rch@iie.edu.uy  wu@iie.edu.uy        |
+-----------------------------------------------------------------+

*)

program usuario;
{$F+}

uses winCRT, xMatDefs, FilUSR,
		Simul2,traxp,variable,lib_basi,libep02,libep,
		libdig01, Memorias, PlotMems, uCntrl;

const
	NCiclos = 1;        { Nmero de ciclos de un barrido }
	uControl: NReal = 0.1;     { entrada al comando arcoseno (-1,1)}
	rshnt= 0.001;        { resistencia de para medidas de corriente }

	Periodo = 20E-3;      { 50Hz }
	pw = periodo/2;
	p: integer = 9; 		{pulsacion de la portadora}
	pmax = 31; pmin = 3;
	NPuntosDeLasMemorias = 512 ;
	MaxUltimaArmonica = NPuntosDeLasMemorias div 2;
	UltimaArmonicaAGraficar: integer = 30;
	PeriodoDeMuestreoDeLasMemorias = Periodo{*NCiclos} / NPuntosDeLasMemorias;

	Edc: NReal = 200; 		{ Tensin de la fuente de continua }
	Iac: NReal = 10; 			{ Amplitud de la corriente de carga }
	RetardoRamaB: NReal = 0.5; { Atraso de la ramaB respecto de la A en p.u. }

	R0: NReal = 20;
	Rvar: NReal = 20;
	Rmin = 1; Rmax = 200;

	m: NReal = 0.6; 				{indice de modulacion}
	distorsion: NReal = 0;
	r1:NReal = 0;
	r3:Nreal = 0;
	r5:NReal = 0;
	r7:NREal = 0;
	r9:NREal =0;
	r11: NReal =0;

var
	Per_tri : NReal;
	mem1,  mem2, mem3, mem4: TMemoria;

procedure cirt1;
begin
	vg(0, 0, 1, Edc/2);
	vg(0, 2, 0, Edc/2);

	r(1,3,rshnt);
	r(3,4,rshnt);
	r(5,6,rshnt);

	R(6, 9, R0);
	R(7, 9, R0);
	R(8, 9, Rvar);

end; (* cirt1 *)

function referencia(t:NReal):NReal;
begin
	referencia:= m * sin(2*pi*t/Periodo );
end;

function A(t:NReal):boolean;
var
	d: NReal;
begin
	A:= triangular(t/ Per_tri) > referencia(t);
end;

procedure cirt2;
begin
	ll2p(4, 5, 2, A(t+2*periodo/3));
	ll2p(3, 7, 2, A(t+periodo/3));
	ll2p(3, 8, 2, A(t));
end;

procedure funcsr(t: NReal);
begin
end;

procedure inicio;
begin

Per_tri:= Periodo / p;

nn:= 9;
nindep:=0;

tinicial:=0;
tfinal:=Periodo*nciclos;
dtmax0:=(tfinal-tinicial)/1000;

PasoDivisor:=6;
TmaxTmin:=1000;

traxp.tinicial:=tinicial;
traxp.tfinal:=tfinal;

iniciegr;

gridx:= 10;
gridy:= 10;
subplot(2,2);

definaY(0,-500,100);
ylabel('100V/DIV');
titulo('V[6]az   V[7]r   V[8]v');
grid;

definaY(1,-600,100);
ylabel('100V/DIV');
titulo('V[6]-V[7]az  V[9]r  V[6]-V[9]v');
grid;

activecanal(2);
titulo('Espectro V[6]az   V[9]r');
xlabel('1n/DIV');

activecanal(3);
titulo('Espec.(Un) V[6]-V[7]az V[6]-V[9]v');
xlabel('1n/DIV');

superponga( 4, 0);
DefinaColor(4, Rojo );

superponga( 5, 0);
DefinaColor(5, Verde );

superponga( 6, 1);
DefinaColor(6, Rojo );

superponga( 7, 1);
DefinaColor(7, Verde );

superponga( 8, 1);
DefinaColor(8, Rojo );

superponga( 9, 1);
DefinaColor(9, Verde );

superponga( 10, 1);
DefinaColor(10, Azul );

superponga( 11, 0);
DefinaColor(11, Azul );

superponga( 12, 0);
DefinaColor(12, Rojo );

superponga( 13, 0);
DefinaColor(13, Verde );
end;

procedure fin;
begin
	readln;
	TermineGr;
end;

procedure pesca;
var
	tecla: char;
	k: integer;
begin
	traxp.t:=t;

	Per_tri:= Periodo / p;
	dtmax0:= Per_tri/100;

	mem1.tic( t, v[6]);
	trazo(0, v[6]+300);
	trazo(4, v[7]);
	trazo(5, v[8]-300);

	mem2.tic(t, v[6]-v[7]);
	trazo(1, v[6]-v[7]+100);
	trazo(6, v[9]-200);
	trazo(7, v[6]-v[9]-400);
	trazo(8, -200);
	trazo(9, -400);
	trazo(10, 100);
	trazo(11, 300);
	trazo(12, 0);
	trazo(13, -300);

	mem3.tic( t, v[6]-v[9] );
{	mem4.tic( t, v[9] );}

	if t >= tfinal then
	begin
		mem1.fft;
		borrecanal(2,0);
		desligue(2);
		borde;
		mem2.fft;
		mem3.fft;
{		mem4.fft;}
		DefinaColor(2, Azul);
		PlotMem_EspectroUn( 2, mem1, 0, UltimaArmonicaAGraficar );
{		holdon(2);
		DefinaColor(2, Rojo);
		PlotMem_EspectroUn( 2, mem4, 0, UltimaArmonicaAGraficar);
		holdoff(2);
}
		distorsion:= mem2.DistorsionArmonica_25;
		r1:= mem2.PotenciaARmonica(1);
		r3:= sqrt(mem2.PotenciaARmonica(3)/r1);
		r5:= sqrt(mem2.PotenciaARmonica(5)/r1);
		r7:= sqrt(mem2.PotenciaARmonica(7)/r1);
		r9:= sqrt(mem2.PotenciaARmonica(9)/r1);
		r11:= sqrt(mem2.PotenciaARmonica(11)/r1);
		borrecanal(3,0);
		desligue(3);
		borde;
		DefinaColor(3, Azul);
		PlotMem_EspectroUn( 3, mem2, 0, UltimaArmonicaAGraficar);
		holdon(3);
		DefinaColor(3, Verde);
		PlotMem_EspectroUn( 3, mem3, 0, UltimaArmonicaAGraficar);
{		DefinaColor(3, Rojo);
		PlotMem_EspectroUn( 3, mem4, 0, UltimaArmonicaAGraficar);
 }
		holdoff(3);
		gridy:= 10;
		gridx:=10;
		for k:= 0 to 1 do
		begin
			borrecanal(k,0);
			desligue(k);
			grid;
			borde;
		end;
		for k:= 4 to 7 do
		begin
			borrecanal(k,0);
			desligue(k);
			grid;
			borde;
		end;
		t:= t-tfinal+tinicial;
		mem1.RetrocesoBarrido(tfinal-tinicial);
		mem2.RetrocesoBarrido(tfinal-tinicial);
		mem3.RetrocesoBarrido(tfinal-tinicial);
{		mem4.RetrocesoBarrido(tfinal-tinicial);}
	end;
end;

begin
FilUSR.Cirt1:=Cirt1;
FilUSR.Cirt2:=Cirt2;
FilUSR.FuncsR:=FuncsR;
FilUSR.Inicio:=Inicio;
FilUSR.Pesca:=Pesca;

{ Inicializacin de las memorias }
mem1:= TMemoria.Create_init(	PeriodoDeMuestreoDeLasMemorias, NPuntosDeLasMemorias, 0, 0);
mem2:= TMemoria.Create_init(	PeriodoDeMuestreoDeLasMemorias, NPuntosDeLasMemorias, 0, 0);
mem3:= TMemoria.Create_init(	PeriodoDeMuestreoDeLasMemorias, NPuntosDeLasMemorias, 0, 0);
{mem4:= TMemoria.Create_init(	PeriodoDeMuestreoDeLasMemorias, NPuntosDeLasMemorias, 0, 0);}

uCntrl.init;

{ Agregamos un control que es solamente un ttulo }
UCntrl.insert(new(PCtrlTexto, init(
			1,             { nmero del renglon en la banda de texto }
			'CONTROLES:'
			))); { nmero de caracteres del intertexto }

UCntrl.insert( new(PCtrlProcedure, Init(
			's',
			9,
			'Retorno)  =  Salir',
			fin )));  { variable controlada }

UCntrl.insert(new(PCtrlNRealInc, Init(
			'r',           { letra de control }
			3,             { nmero del renglon en la banda de texto }
			'R3:',        { Texto antes del valor }
			'[ohm]', { texto posterior al valor }
			6, 1,          { Formato del valor Campo:Decimales }
			Rmin, Rmax, 20, 1,  {Valmin, ValMax, ValDef, ValInc }
			Rvar            { Variable controlada }
			)));

UCntrl.insert(new(PCtrlNRealInc, Init(
			'm',           { letra de control }
			4,             { nmero del renglon en la banda de texto }
			'Ind.Mod.:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7, 3,          { Formato del valor Campo:Decimales }
			0.3, 0.95, 0.3, 0.1,  {Valmin, ValMax, ValDef, ValInc }
			m            { Variable controlada }
			)));

UCntrl.insert(new(PCtrlNEntero, Init(
			'p',           { letra de control }
			5,             { nmero del renglon en la banda de texto }
			'Frec.Pul.:',        { Texto antes del valor }
			'[u]', { texto posterior al valor }
			7,          { Formato del valor Campo }
			pmin, pmax, pmin, 2,  {Valmin, ValMax, ValDef, ValInc }
			p            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			7,             { nmero del renglon en la banda de texto }
			'Dst.V6-V7:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			distorsion            { Variable controlada }
			)));

(*
UCntrl.insertDisplay( new(PDsplyNReal, Init(
			8,             { nmero del renglon en la banda de texto }
			'U3/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			r3            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			9,             { nmero del renglon en la banda de texto }
			'U5/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			r5            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			10,             { nmero del renglon en la banda de texto }
			'U7/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			r7            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			11,             { nmero del renglon en la banda de texto }
			'U9/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			r9           { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			12,             { nmero del renglon en la banda de texto }
			'U11/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			r11          { Variable controlada }
			)));
*)

paseo;
fin;

{ destruccin de las memorias }
mem1.Free;
mem2.Free;
mem3.Free;
{mem4.done;}
end.
