(*
			======================================================
			INVERSORES: CURSO BASICO BASADO EN EL SIMULADOR SIMEEP
			======================================================


Simul10.cir

+-----------------------------------------------------------------+
|		 Instituto de Ingeniera Elctrica                            |
|		 Facultad de Ingeniera                                       |
|		 Universidad de la Repblica                                  |
|                                                                 |
|		 http://www.iie.edu.uy/docs/potencia/simeep.htm               |
|		 e-mail: gcp@iie.edu.uy  rch@iie.edu.uy  wu@iie.edu.uy        |
+-----------------------------------------------------------------+

*)

program usuario;
{$F+}
uses winCRT, xMatDefs, FilUSR,
		Simul2,
      traxp,variable,lib_basi,libep02,libep,
		libdig01, Memorias, PlotMems, uCntrl;

const
	NCiclos = 1; { Nmero de ciclos de un barrido }
	uControl: NReal = 0.1; { entrada al comando arcoseno (-1,1)}
	rshnt= 0.001; { resistencia de para medidas de corriente }

  f = 50;
	X: NReal = 1;
	Y: NReal = 1;

	R0: NReal = 10;
	Rmin = 1; Rmax = 100;
	Periodo = 20E-3; { 50Hz }
	p: integer = 9; {pulsacion de la portadora}
	pmax = 21; pmin = 3;
	m: NReal = 0.6; {indice de modulacion}

	NPuntosDeLasMemorias = 1024 div 2;
	UltimaArmonicaAGraficar = 30;
	PeriodoDeMuestreoDeLasMemorias = Periodo{*NCiclos} / NPuntosDeLasMemorias;

	Edc: NReal = 200; { Tensin de la fuente de continua }
	Iac: NReal = 10; { Amplitud de la corriente de carga }
	d_a: NReal = 0; { atraso de la a(t) respecto de la carga en p.u. del peiodo}
	RetardoRamaB: NReal = 0.25; { Atraso de la ramaB respecto de la A en p.u. }
	Tabla_d1: NReal = 0.5/2;
	distorsion: NReal = 0;
	r1:NReal = 0;
	r3:Nreal = 0;
	r5:NReal = 0;
	r7:NREal = 0;
	r9:NREal =0;
	r11: NReal =0;

var
	mem1,  mem2: TMemoria;
	Per_tri : NReal;
	C1: NReal;
	L1: NReal;
	L2: NReal;
	C2: NReal;
	ncr: NReal;

procedure cirt1;
begin
	vg(0, 0, 1, Edc/2);
	vg(0, 2, 0, Edc/2);

	r(1,3,rshnt);
	r(4,5,rshnt);

	c(5,6,C1);
	l(6,7,L1);

	c(7,0,C2);
	l(7,0,L2);
	r(7,0,R0);

end; (* cirt1 *)

function referencia(t:NReal):NReal;
begin
	referencia:= m * sin(2*pi*t/Periodo);
end;

function B(t:NReal):boolean;
var
	d: NReal;
begin
	B:= triangular(t/ Per_tri) > referencia(t);
end;

procedure cirt2;
begin
	ll2p(3, 4, 2, not(B(t)));
end;

procedure funcsr(t: NReal);
begin
end;

procedure inicio;
begin
	C1:= 1 / (X*2*pi*f);
	L1:= X / (2*pi*f);
	L2:= 1 / (Y*2*pi*f);
	C2:= Y / (2*pi*f);
	ncr:= (sqrt(1/(X*Y)) + sqrt(4+1/(X*Y)))/2;

	for nn:=1 to 4 do x0[nn]:= 0;
	Per_tri:= Periodo / p;

nn:=7;
nindep:=0;

tinicial:=0;
tfinal:=Periodo*nciclos;
dtmax0:=(tfinal-tinicial)/2000;

PasoDivisor:=6;
TmaxTmin:=1000;

traxp.tinicial:=tinicial;
traxp.tfinal:=tfinal;

iniciegr;

gridx:= 10;
gridy:= 10;
subplot(2,2);

definaY(0,-250,50);
ylabel('10A/DIV - 100V/DIV');
titulo('Isalida(az)   Vsalida(r)');
grid;
linea0;


definaY(1,-500,100);
ylabel('100V/DIV');
titulo('Vcarga (az)  Vtriang.(az)  Vrefer.(r)');
grid;
{linea0;}

activecanal(2);
titulo('Espectro de Vsalida');
xlabel('3n/DIV');

activecanal(3);
titulo('Espectro de Vcarga');
xlabel('3n/DIV');

superponga(5,1);
definacolor(5, Azul);

superponga(6,1);
definacolor(6, Rojo);

superponga(4,0);
definacolor(4, Rojo);

superponga(7,1);
definacolor(7, Azul);

superponga(8,1);
definacolor(8, Azul);

end;

procedure fin;
begin
	readln;
	TermineGr;
end;

procedure pesca;
var
	tecla: char;
	iac, i_2_4: NReal;
	k: integer;

begin

	traxp.t:=t;
	Per_tri:= Periodo/p;
	dtmax0:= Per_tri/200;
	C1:= 1 / (X*2*pi*f);
	L1:= X / (2*pi*f);
	L2:= 1 / (Y*2*pi*f);
	C2:= Y / (2*pi*f);
	ncr:= (sqrt(1/(X*Y)) + sqrt(4+1/(X*Y)))/2;


	iac:=(v[4]-v[5])/rshnt;
{	mem1.tic(t, idc);}
	trazo(0, iac);
	mem1.tic(t, v[4]);
	trazo(4, v[4]);

	mem2.tic( t, v[7]);
	trazo(1, v[7]+200);
	trazo(5, triangular(t/ Per_tri)*100-200);
	trazo(6, referencia(t)*100-200);
	trazo(7, 200);
	trazo(8, -200);

	if t >= tfinal then
	begin
		mem1.fft;
		mem2.fft;
{		mem3.fft;}
		borrecanal(2,0);
		desligue(2);
		borde;
		DEfinaColor(2, Azul);
		PlotMem_EspectroUn( 2, mem1, 0, UltimaArmonicaAGraficar );

		distorsion:= mem2.DistorsionArmonica_25;
{		r1:= mem2.PotenciaARmonica(1);
		r3:= sqrt(mem2.PotenciaARmonica(3)/r1);
		r5:= sqrt(mem2.PotenciaARmonica(5)/r1);
		r7:= sqrt(mem2.PotenciaARmonica(7)/r1);
		r9:= sqrt(mem2.PotenciaARmonica(9)/r1);
		r11:= sqrt(mem2.PotenciaARmonica(11)/r1);
}
		borrecanal(3,0);
		desligue(3);
		borde;
		DefinaColor(3, Azul);
		PlotMem_EspectroUn( 3, mem2, 0, UltimaArmonicaAGraficar);
		gridy:= 10;
		gridx:= 10;
		for k:= 0 to 1 do
		begin
			borrecanal(k,0);
			desligue(k);
			grid;
			borde;
			linea0;
		end;
			borrecanal(4,0);
			desligue(4);
			grid;
			borde;
			linea0;
		for k:=5 to 6 do
		begin
			borrecanal(k,0);
			desligue(k);
			grid;
			borde;
{			linea0;}
		end;
		t:= t-tfinal+tinicial;
		mem1.RetrocesoBarrido(tfinal-tinicial);
		mem2.RetrocesoBarrido(tfinal-tinicial);
{		mem3.RetrocesoBarrido(tfinal-tinicial);}
	end;
end;

begin
FilUSR.Cirt1:=Cirt1;
FilUSR.Cirt2:=Cirt2;
FilUSR.FuncsR:=FuncsR;
FilUSR.Inicio:=Inicio;
FilUSR.Pesca:=Pesca;

{ Inicializacin de las memorias }
mem1:= TMemoria.Create_init(	PeriodoDeMuestreoDeLasMemorias, NPuntosDeLasMemorias, 0, 0);
mem2:= TMemoria.Create_init(	PeriodoDeMuestreoDeLasMemorias, NPuntosDeLasMemorias, 0, 0);


uCntrl.init;

{ Agregamos un control que es solamente un ttulo }
UCntrl.insert(new(PCtrlTexto, init(
			1,             { nmero del renglon en la banda de texto }
			'CONTROLES:'
			))); { nmero de caracteres del intertexto }

UCntrl.insert( new(PCtrlProcedure, Init(
			's',
			13,
			'Retorno)  =  Salir',
			fin )));  { variable controlada }

UCntrl.insert(new(PCtrlNRealInc, Init(
			'r',           { letra de control }
			3,             { nmero del renglon en la banda de texto }
			'R:',        { Texto antes del valor }
			'[ohm]', { texto posterior al valor }
			6, 1,          { Formato del valor Campo:Decimales }
			Rmin, Rmax, 20, 1,  {Valmin, ValMax, ValDef, ValInc }
			R0            { Variable controlada }
			)));

UCntrl.insert(new(PCtrlNRealInc, Init(
			'x',           { letra de control }
			4,             { nmero del renglon en la banda de texto }
			'X:',        { Texto antes del valor }
			'[u]', { texto posterior al valor }
			8, -3,          { Formato del valor Campo:Decimales }
			0.1, 5, 1, 0.1,  {Valmin, ValMax, ValDef, ValInc }
			X            { Variable controlada }
			)));

UCntrl.insert(new(PCtrlNRealInc, Init(
			'y',           { letra de control }
			5,             { nmero del renglon en la banda de texto }
			'Y:',        { Texto antes del valor }
			'[u]', { texto posterior al valor }
			8, -3,          { Formato del valor Campo:Decimales }
			0.1, 5, 1, 0.1,  {Valmin, ValMax, ValDef, ValInc }
			Y           { Variable controlada }
			)));

UCntrl.insert(new(PCtrlNRealInc, Init(
			'm',           { letra de control }
			6,             { nmero del renglon en la banda de texto }
			'Ind.Mod.:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7, 3,          { Formato del valor Campo:Decimales }
			0.3, 0.95, 0.3, 0.1,  {Valmin, ValMax, ValDef, ValInc }
			m            { Variable controlada }
			)));

UCntrl.insert(new(PCtrlNEntero, Init(
			'p',           { letra de control }
			7,             { nmero del renglon en la banda de texto }
			'Frec.Pul.:',        { Texto antes del valor }
			'[u]', { texto posterior al valor }
			7,          { Formato del valor Campo }
			pmin, pmax, pmin, 2,  {Valmin, ValMax, ValDef, ValInc }
			p            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			9,             { nmero del renglon en la banda de texto }
			'nCr:',        { Texto antes del valor }
			'[u]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			ncr            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			10,             { nmero del renglon en la banda de texto }
			'Dst.Vcar.:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			distorsion            { Variable controlada }
			)));
(*
UCntrl.insertDisplay( new(PDsplyNReal, Init(
			6,             { nmero del renglon en la banda de texto }
			'Dst.V6-V9:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			dist69            { Variable controlada }
			)));
*)

(*
UCntrl.insertDisplay( new(PDsplyNReal, Init(
			6,             { nmero del renglon en la banda de texto }
			'U3/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			r3            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			7,             { nmero del renglon en la banda de texto }
			'U5/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			r5            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			8,             { nmero del renglon en la banda de texto }
			'U7/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			r7            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			9,             { nmero del renglon en la banda de texto }
			'U9/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			r9           { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			10,             { nmero del renglon en la banda de texto }
			'U11/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			r11          { Variable controlada }
			)));
*)

paseo;
fin;

{ destruccin de las memorias }
mem1.Free;
mem2.Free;

end.
