(*
			======================================================
			INVERSORES: CURSO BASICO BASADO EN EL SIMULADOR SIMEEP
			======================================================

Simul11.cir

+-----------------------------------------------------------------+
|		 Instituto de Ingeniera Elctrica                            |
|		 Facultad de Ingeniera                                       |
|		 Universidad de la Repblica                                  |
|                                                                 |
|		 http://www.iie.edu.uy/docs/potencia/simeep.htm               |
|		 e-mail: gcp@iie.edu.uy  rch@iie.edu.uy  wu@iie.edu.uy        |
+-----------------------------------------------------------------+
*)

program usuario;
{$F+}

uses winCRT, xMatDefs, FilUSR,
		Simul2,traxp,variable,lib_basi,libep02,libep,
		libdig01, Memorias, PlotMems, uCntrl;

const
	NCiclos = 1; { Nmero de ciclos de un barrido }
	uControl: NReal = 0.1; { entrada al comando arcoseno (-1,1)}
	rshnt= 0.001; { resistencia de para medidas de corriente }

	Periodo = 20E-3; { 50Hz }
	pw = periodo/2;
	p: integer = 9; {pulsacion de la portadora}
	pmax = 31; pmin = 3;
	NPuntosDeLasMemorias = 256 ;
	MaxUltimaArmonica = NPuntosDeLasMemorias div 2;
	UltimaArmonicaAGraficar: integer = 30;
	PeriodoDeMuestreoDeLasMemorias = Periodo{*NCiclos} / NPuntosDeLasMemorias;

	Edc: NReal = 200; { Tensin de la fuente de continua }
	Iac: NReal = 10; { Amplitud de la corriente de carga }
	d_a: NReal = 0; { atraso de la a(t) respecto de la carga en p.u. del peiodo}
	RetardoRamaB: NReal = 0.5; { Atraso de la ramaB respecto de la A en p.u. }

	L0: NReal = 0.1e-1;{Hy}
	C0: NReal = 10e-6; {F}
	R0: NReal = 20;
	L00: NReal = 0.1e-1;{Hy}
	C00: NReal = 10e-6; {F}
	R00: NReal = 20;
	Rvar: NReal = 20;
	Rmin = 1; Rmax = 200;

	m: NReal = 0.6; {indice de modulacion}
	distorsion: NReal = 0;
	r1:NReal = 0;
	r3:Nreal = 0;
	r5:NReal = 0;
	r7:NREal = 0;
	r9:NREal =0;
	r11: NReal =0;

var
	Per_tri : NReal;
	mem1,  mem2, mem3, mem4: TMemoria;
	ffiltro:Nreal;

procedure cirt1;
begin
	vg(0, 0, 1, Edc/2);
	vg(0, 2, 0, Edc/2);

	r(1,3,rshnt);
	r(3,4,rshnt);
	r(5,6,rshnt);

	l(6, 9, L0);
	l(7, 10, L0);
	l(8, 11, L0);

	r(9,12,R0);
	r(10,12,R0);
	r(11,12,R0);

	c(9,12,C0);
	c(10,12,C0);
	c(11,12,C0);


	r(8, 11, 1000);
	r(7, 10, 1000);
	r(6, 9, 1000);


end; (* cirt1 *)

function referencia(t:NReal):NReal;
begin
	referencia:= m * sin(2*pi*t/Periodo );
end;

function A(t:NReal):boolean;
var
	d: NReal;
begin

	A:= triangular(t/ Per_tri) > referencia(t);
end;

procedure cirt2;
begin
	ll2p(4, 5, 2, A(t+2*periodo/3));
	ll2p(3, 7, 2, A(t+periodo/3));
	ll2p(3, 8, 2, A(t));
end;

procedure funcsr(t: NReal);
begin
end;


procedure inicio;
begin
ffiltro:=1/2/pI/sqrt(L0*C0);
Per_tri:= Periodo / p;
for nn:= 1 to 6 do x0[nn]:= 0;
nn:= 12;
nindep:=0;
tinicial:=0;
tfinal:=Periodo*nciclos;
dtmax0:=(tfinal-tinicial)/1000;

PasoDivisor:=6;
TmaxTmin:=1000;

traxp.tinicial:=tinicial;
traxp.tfinal:=tfinal;

iniciegr;

gridx:= 10;
gridy:= 10;
subplot(2,2);

definaY(0,-500,100);
ylabel('100V/DIV');
titulo('V6(az)   V9-V12(r)   V12(v)');
grid;

definaY(1,-5, 1);
ylabel('1A/DIV');
titulo('Idc(az)    Isalida(v)');
grid;

activecanal(2);
titulo('Espectros  V6-V12(az)  V9-V12(r)');
xlabel('3n/DIV');

activecanal(3);
titulo('Espectro   Isalida');
xlabel('3n/DIV');

superponga( 4, 0);
DefinaColor(4, Rojo );

superponga( 5, 0);
DefinaColor(5, Verde );

superponga( 7, 1);
DefinaColor(7, Verde );

superponga( 11, 0);
DefinaColor(11, Azul );

superponga( 12, 0);
DefinaColor(12, Rojo );

superponga( 13, 0);
DefinaColor(13, Verde );

end;


procedure fin;
begin
	readln;
	TermineGr;
end;

procedure pesca;
var
	tecla: char;
	k: integer;
	i13, i34, i56: NReal;

begin
	ffiltro:=1/2/pI/sqrt(L00*C00);
	traxp.t:=t;
	Per_tri:= Periodo / p;
	dtmax0:= Per_tri/100;

	mem1.tic( t, v[6]-V[12]);
	mem2.tic(t, v[9]-v[12]);
	trazo(0, v[6]+300);
	trazo(4, v[9]-v[12]);
	trazo(5, v[12]-300);

	i13:= (v[1]-V[3])/rshnt;
	i34:= (v[3]-V[4])/rshnt;
	i56:= (v[5]-V[6])/rshnt;

	mem3.tic( t, i56 );
	trazo(1, i13);
	trazo(7, i56);

	trazo(11, 300);
	trazo(12, 0);
	trazo(13, -300);


	if t >= tfinal then
	begin
		L0:=L00;
		C0:=C00;
		R0:=R00;

		mem1.fft;

		borrecanal(2,0);
		desligue(2);
		borde;

		mem2.fft;
		mem3.fft;

		DefinaColor(2, Azul);
		PlotMem_EspectroUn( 2, mem1, 0, UltimaArmonicaAGraficar );
		distorsion:= mem2.DistorsionArmonica_25;

		r1:= mem2.PotenciaARmonica(1);
		r3:= sqrt(mem2.PotenciaARmonica(3)/r1);
		r5:= sqrt(mem2.PotenciaARmonica(5)/r1);
		r7:= sqrt(mem2.PotenciaARmonica(7)/r1);
		r9:= sqrt(mem2.PotenciaARmonica(9)/r1);
		r11:= sqrt(mem2.PotenciaARmonica(11)/r1);

		DefinaColor(2, Rojo);
		holdon(2);
		PlotMem_EspectroUn( 2, mem2, 0, UltimaArmonicaAGraficar);
		holdoff(2);

		borrecanal(3,0);
		desligue(3);
		borde;
		DefinaColor(3, Verde);
		PlotMem_EspectroUn( 3, mem3, 0, UltimaArmonicaAGraficar);

		gridy:= 10;
		gridx:=10;
		for k:= 0 to 1 do
		begin
			borrecanal(k,0);
			desligue(k);
			grid;
			borde;

		end;

		for k:= 4 to 5 do
		begin
			borrecanal(k,0);
			desligue(k);
			grid;
			borde;
		end;
			borrecanal(7,0);
			desligue(7);
			grid;
			borde;
		t:=0;
{		t:= t-tfinal+tinicial;}
		mem1.RetrocesoBarrido(tfinal-tinicial);
		mem2.RetrocesoBarrido(tfinal-tinicial);
		mem3.RetrocesoBarrido(tfinal-tinicial);
	end;



end;






begin
FilUSR.Cirt1:=Cirt1;
FilUSR.Cirt2:=Cirt2;
FilUSR.FuncsR:=FuncsR;
FilUSR.Inicio:=Inicio;
FilUSR.Pesca:=Pesca;

{ Inicializacin de las memorias }
mem1:= TMemoria.Create_init(	PeriodoDeMuestreoDeLasMemorias, NPuntosDeLasMemorias, 0, 0);
mem2:= TMemoria.Create_init(	PeriodoDeMuestreoDeLasMemorias, NPuntosDeLasMemorias, 0, 0);
mem3:= TMemoria.Create_init(	PeriodoDeMuestreoDeLasMemorias, NPuntosDeLasMemorias, 0, 0);

uCntrl.init;


{ Agregamos un control que es solamente un ttulo }
UCntrl.insert(new(PCtrlTexto, init(
			1,             { nmero del renglon en la banda de texto }
			'CONTROLES:'
			))); { nmero de caracteres del intertexto }


UCntrl.insert( new(PCtrlProcedure, Init(
			's',
			22,
			'Retorno) = Salir',
			fin )));  { variable controlada }


UCntrl.insert(new(PCtrlNRealInc, Init(
			'r',           { letra de control }
			3,             { nmero del renglon en la banda de texto }
			'R:',        { Texto antes del valor }
			'[ohm]', { texto posterior al valor }
			6, 1,          { Formato del valor Campo:Decimales }
			Rmin, Rmax, 20, 1,  {Valmin, ValMax, ValDef, ValInc }
			R00            { Variable controlada }
			)));

UCntrl.insert(new(PCtrlNRealInc, Init(
			'l',           { letra de control }
			4,             { nmero del renglon en la banda de texto }
			'L:',        { Texto antes del valor }
			'[Hy]', { texto posterior al valor }
			8, -3,          { Formato del valor Campo:Decimales }
			10e-3, 100e-3, 1e-3, 1e-3,  {Valmin, ValMax, ValDef, ValInc }
			L00            { Variable controlada }
			)));

UCntrl.insert(new(PCtrlNRealInc, Init(
			'c',           { letra de control }
			5,             { nmero del renglon en la banda de texto }
			'C:',        { Texto antes del valor }
			'[F]', { texto posterior al valor }
			8, -3,          { Formato del valor Campo:Decimales }
			1e-6, 100e-6, 1, 1e-6,  {Valmin, ValMax, ValDef, ValInc }
			C00            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			7,             { nmero del renglon en la banda de texto }
			'f filtro:',        { Texto antes del valor }
			'Hz', { texto posterior al valor }
			6,0,          { Formato del valor Campo }
			ffiltro            { Variable controlada }
			)));

UCntrl.insert(new(PCtrlNEntero, Init(
			'p',           { letra de control }
			9,             { nmero del renglon en la banda de texto }
			'Frec.Pul.:',        { Texto antes del valor }
			'[u]', { texto posterior al valor }
			7,          { Formato del valor Campo }
			pmin, pmax, pmin, 2,  {Valmin, ValMax, ValDef, ValInc }
			p            { Variable controlada }
			)));

UCntrl.insert(new(PCtrlNRealInc, Init(
			'm',           { letra de control }
			10,             { nmero del renglon en la banda de texto }
			'Ind.Mod.:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7, 3,          { Formato del valor Campo:Decimales }
			0.3, 0.95, 0.3, 0.1,  {Valmin, ValMax, ValDef, ValInc }
			m            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			13,             { nmero del renglon en la banda de texto }
			'Dst.V9-V12:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			distorsion            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			15,             { nmero del renglon en la banda de texto }
			'U3/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			r3            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			16,             { nmero del renglon en la banda de texto }
			'U5/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			r5            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			17,             { nmero del renglon en la banda de texto }
			'U7/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			r7            { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			18,             { nmero del renglon en la banda de texto }
			'U9/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			r9           { Variable controlada }
			)));

UCntrl.insertDisplay( new(PDsplyNReal, Init(
			19,             { nmero del renglon en la banda de texto }
			'U11/U1:',        { Texto antes del valor }
			'[pu]', { texto posterior al valor }
			7,3,          { Formato del valor Campo }
			r11          { Variable controlada }
			)));





paseo;
fin;

{ destruccin de las memorias }
mem1.Free;
mem2.Free;
mem3.Free;
end.
