program tutor02;
{$F+}
uses
	wincrt, xmatdefs, FilUSR, UCntrl, Simul2, traxp, variable,
	lib_basi, libep02, libep, libdig01;

const period_on:NReal=10e-3;

procedure cirt1;
begin
vg(1,0,1,1);
r(1,2,100);
c(2,0,10e-6);
end;

procedure cirt2;
begin
end;

procedure funcsr(t:NReal);
begin
rf[1]:=pulsoc(t,0,period_on,20e-3,1,3);
end;

procedure inicio;
begin
nn:=2;
nindep:=1;
tinicial:=0;
x0[1]:=0;
tfinal:=100e-3;
dtmax0:=5e-6;
dtmin:=dtmax0/100;
PasoDivisor:=6;
TmaxTmin:=1e3;

traxp.tinicial:=tinicial;
traxp.tfinal:=tfinal;

iniciegr;

gridx:=10;
gridy:=10;
subplot(1,2);

definaY(0,0,0.3);
titulo('Tensin en el Condensador');
xlabel('2 ms/DIV');
ylabel('0.3 V/DIV');
linea0;
grid;

definaY(1,0,0.3);
titulo('Tensin de la Fuente');
xlabel('2 ms/DIV');
ylabel('0.3 V/DIV');
linea0;
grid;

definacolor(1,rojo);
definacolor(0,verde);
end;

procedure fin;
begin
TermineGr;
end;

procedure pesca;

var   k:integer;


begin
traxp.t:=t;
trazo(0,x[1]);
trazo(1,v[1]);

if t >= tfinal then
begin

   for k:= 0 to 1 do
   begin
	borrecanal(k,0);
	desligue(k);
	grid;
	borde;
	linea0;
   end;
   t:= t-tfinal+tinicial;
end;
end;

begin
FilUSR.Cirt1:=Cirt1;
FilUSR.Cirt2:=Cirt2;
FilUSR.FuncsR:=FuncsR;
FilUSR.Inicio:=Inicio;
FilUSR.Pesca:=Pesca;

UCntrl.init;

{ Agregamos un control que es solamente un ttulo }
UCntrl.insert(new(PCtrlTexto, init(
			1,             { nmero del renglon en la banda de texto }
			'CONTROLES:'
			))); { nmero de caracteres del intertexto }

{ Agregamos control de la variable real d_a }
UCntrl.insert(new(PCtrlNRealInc, Init(
			'f',           { letra de control }
			2,             { nmero del renglon en la banda de texto }
			'Tiempo on:',        { Texto antes del valor }
			's', { texto posterior al valor }
			1, 3,          { Formato del valor Campo:Decimales }
			0,20e-3, 10e-3, 1e-3,  {Valmin, ValMax, ValDef, ValInc }
			period_on            { Variable controlada }
			)));

UCntrl.insert( new(PCtrlProcedure, Init(
			's',
			12,
			'Retorno)  =  Salir',
			fin )));  { variable controlada }


paseo;
end.
