{+doc
+NOMBRE: tabrama
+CREACION: 8.8.96
+AUTORES: gcp, rch
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO: Definicin de objeto barredor de tablas.
+PROYECTO: SiMEEP

+REVISION:
+AUTOR:
+DESCRIPCION:

-doc}

unit tabrama;
interface
uses
	MatReal, xmatdefs, horrores;

type
	TTablaRama = object( TVectR )
		k1, k2: integer;
		Salida0: boolean;
		constructor InitReadTxt( NombArch: string );
		constructor InitDim( xN: integer );
		function Salida( d: NReal ): boolean;
		function MinimoTiempoEntreConmutaciones: NReal;
	end;


implementation


procedure UpStr(var s: string );
var
	k:integer;
begin
	for k:= 1 to length(s) do s[k]:= UpCase(s[k]);
end;



constructor TTablaRama.InitReadTxt( NombArch: string );
var
	f: text;
	_k: integer;
	m: NReal;
	unidades: string;
	kconv: NReal;
begin
	assign( f, NombArch );
	reset(f);
	readln( f, unidades );

	UpStr(unidades);
   kconv:= 1;
	if pos('GRAD', unidades) > 0 then kconv:= 1/360
	else
	if pos('RAD', unidades) > 0 then kconv:= 1/2/pi
	else
	if pos('PU', unidades) = 0 then
		if pos('P.U.', unidades)= 0 then
		begin
			close(f);
			error('unidades malas en: '+NombArch);
      end;

	readln( f, N );
   init( N );
	for _k:=  1 to N do
   begin
		readln( f, m  );
		pon_e(_k, m*kconv);
	end;
	close(f);
	k1:= 0; k2:= 0;
   Salida0:= true;
end;


constructor TTablaRama.InitDim( xN: integer );
begin
	TVectR.init( xN );
	k1:= 0; k2:= 0;
	Salida0:= true;
end;

function TTablaRama.Salida( d: NReal ): boolean;
begin
	d:= frac(d);
	if d < 1/4 then
	begin
		if (k1=0) or (e(k1)<= d) then
      begin
			if (k2=N+1) or ( d < e(k2) ) then
				Salida:= Salida0
			else
			begin
				k1:= k2;
				k2:= k1+1;
				Salida0:= not Salida0;
				Salida:= Salida( d );
			end
		end
		else
		begin
			k2:= k1;
			k1:= k1 -1;
			Salida0:= not Salida0;
			Salida:= salida(d);
		end
	end
	else
		if d < 1/2 then salida:= salida( 1/2- d)
	else salida:= not salida( d- 1/2)
end;






function TTablaRama.MinimoTiempoEntreConmutaciones: NReal;
var
	min: NReal;
	dt: NReal;
	_k: integer;
begin
	min:= e(1);
	for _k:= 2 to N do
	begin
		dt:= e(_k)-e(_k-1);
		if dt < min then min:= dt;
	end;
	dt:= 2*(1/2-e(N));
	if dt < min then min:= dt;
	MinimoTiempoEntreConmutaciones:= min;
end;

	

end.





