program usuario;
{$F+}
uses
	traxp, {iso90,} GRCH3d00,
	FilUSR, Simul2, variable, xmatdefs,
	lib_basi, libep02, libep;
	



procedure cirt1;
begin
{------------------------------------------------------------}
	vg(		{ Generador de tensin independiente }
		0,    { Dependencia con t }
		0,1,  { Conexiones }
		200   { Valor: 200 V }
	);
{------------------------------------------------------------}
	r( 		{ Resistencia }
		3,4,	{ Conexiones }
		0.5     { Valor: 5 ohm }
	);
{------------------------------------------------------------}
	L(       { Bobina }
		2,3, 	{ Conexiones }
		1e-3	{ Valor: 10 mH }
	);
{------------------------------------------------------------}
	c(
		4,0,
		10e-6
	);
{------------------------------------------------------------}
	r(
		4,0,
		120
	);
{------------------------------------------------------------}
end; (* cirt1 *)


procedure cirt2;
begin
{------------------------------------------------------------}
	d2(
		0,2,
		0.01
	); (* D1 *)
{------------------------------------------------------------}
	ll2trans(
		1,2,
		1,10000,
		sin(pi/30e-6*t)>0
	);
{------------------------------------------------------------}
end;



procedure funcsr(t:NReal);
begin
end;





var
	a:trazo3d;


procedure Def3D;
begin
	a.init;
	a.definax(tinicial,(tfinal-Tinicial));
	a.definaz(0,10);
	a.definay(0,250);
	a.definadireccion(tfinal,500,10);
	a.ColorFondo:=blanco;
	a.ColorTrazo:=negro;
	a.ColorAux:=azul;
	a.COlorGrid:=azul;
	a.asigneCanal(2);

	a.encuadre;
	a.gridx:=10;
	a.gridy:=10;
	a.gridz:=10;
	a.gridXY;
	a.gridYZ;
	a.GridZX;
	Desligue(2);
end;



procedure inicio;
begin
nn:=4;
nindep:=0;
tinicial:=0;
x0[1]:=0;
x0[2]:=0;

tfinal:=2500e-6;
dtmax0:=7e-6;
dtmin:=dtmax0/300;
PasoDivisor:=5;
TmaxTmin:=1e3;


{-- Definicin de las salidas grficas --}

traxp.tinicial:=tinicial;
traxp.tfinal:=tfinal;
iniciegr;

subplot(2,2);

definaY(0,-1,1);
titulo('Corriente del Inductor');
xlabel('40 us/DIV');
ylabel('1 A/DIV');
linea0;
grid;

definaY(1,-50,50);
ylabel('50 V/DIV');
titulo('v[2]');
xlabel('40 us/DIV');
linea0;
grid;


definaY(3,-50,50);
titulo('Tensin del Condensador');
xlabel('40 us/DIV');
ylabel('50 V/DIV');
linea0;
grid;


{
definaY(2,-1,1);
definaX(2,0,50);
titulo('State Plane');
xlabel('50 V/DIV');
ylabel('1 A/DIV');
linea0;
grid;
}


activeCanal(2);
xlabel('250 us/DIV');
ylabel('25 V/DIV');
titulo('Trayectoria del Convertidor 1A/DIV ');

def3D;

end;

procedure fin;
begin
readln;
TermineGr;
end;

procedure pesca;
begin

traxp.t:=t;
trazo(0,X0[1]);
trazo(1,v[2]);
{
trazoXY(2,x0[2],x0[1]);
}
trazo(3,x0[2]);

a.trazo(t,x0[2],x0[1]);

end;






begin
FilUSR.Cirt1:=Cirt1;
FilUSR.Cirt2:=Cirt2;
FilUSR.FuncsR:=FuncsR;
FilUSR.Inicio:=Inicio;
FilUSR.Pesca:=Pesca;
paseo;
fin
end.
