
(*
Puente 12 pulsos doble va alimentado con
transformador trifsico  simulado mediante dos juegos de fuentes
desfasadas 30 grados, considerando las fugas del mismo
para tener en cuenta el fenmeno de solapamiento.
*)

program usuario;
{$F+}
uses winCRT, xMatDefs, FilUSR,UCntrl,
     Simul2,traxp,variable,lib_basi,libep02,libep;
const
	EBateria: NReal= 100;

	NCiclos = 2;
	cuartoT = 5.0e-3;
	w50 = 314.159;
	Tgama = 6.6666e-3; {20 ms/3}
	tau = Tgama/2;

	uControl: NReal = 0.1; { entrada al comando arcoseno (-1,1)}


	rd= 0.01; { resistencia de los Tiristores en conduccion }
	rfugas=1000; {resistencia de los Tiristores apagados }

	raux = 100; {resistencia de amortiguamiento para calcular}

	lf = 3e-3; {inductancias de fugas del trafo}
	va = 179; { tensin de alimentacin }

	l0 = 38e-3; {inductor de salida}
	C0 = 1000e-6; {condensador de salida}
	r0 = 100; {resistencia de carga}

	IHold = 0.0E-3;
	vgama = 0.6;

const
	va1: boolean = true;
	va2: boolean = false;
	va3: boolean = true;

var
        test:integer;

procedure cirt1;
begin
	vg(1,4,3,va);
	vg(2,4,1,va);
	vg(3,4,2,va);

        vg(2,14,13,va*sqrt(3));
	vg(3,15,10,va*sqrt(3));
	vg(1,13,15,va*sqrt(3));

	r(5,1,raux);
	r(6,2,raux);
	r(7,3,raux);

        r(11,13,raux);
	r(10,14,raux);
	r(12,15,raux);

	l(8,9,l0);
	r(8,9, rfugas);

	vg(4, 0,9, 1);

	l(1,5,2*lf);
	l(2,6,2*lf);
	l(3,7,2*lf);

        l(11,13,lf);
	l(10,14,lf);
	l(12,15,lf);

	r(5,8,rfugas);
	r(6,8,rfugas);
	r(7,8,rfugas);
	r(16,5,rfugas);
	r(16,6,rfugas);
	r(16,7,rfugas);

        r(13,16,rfugas);
	r(14,16,rfugas);
	r(15,16,rfugas);
	r(0,13,rfugas);
	r(0,14,rfugas);
	r(0,15,rfugas);

end; (* cirt1 *)


Type
	TFunFase = function ( x: NReal ):NReal;

function fase1(tx:NReal):NReal; far;
var
	m: NReal;
begin
	m:= cos(w50*tx);
	fase1:= m;
end;

function fase2(tx:NReal):NReal; far;
begin
	fase2:=fase1(tx-Tgama);
end;

function fase3(tx:NReal):NReal; far;
begin
	fase3:=fase1(tx+Tgama);
end;


function g(k:integer;t:NReal):boolean;
begin
	g:=uControl> fase1(t-(k-2)*tau)
end;


function g2ario(k:integer;t:NReal):boolean;
begin
	g2ario:=uControl> fase1(t-(k-2)*tau -tgama/4)
end;



procedure cirt2;
begin

	th2Hold(7,8,rd,IHold, vgama, g(1,t) and g(6,t));
	th2Hold(16,6,rd,IHold, vgama, g(2,t) and g(1,t));
	th2Hold(5,8,rd,IHold, vgama, g(3,t) and g(2,t));
	th2Hold(16,7,rd,IHold, vgama, g(4,t) and g(3,t));
	th2Hold(6,8,rd,IHold, vgama, g(5,t) and g(4,t));
	th2Hold(16,5,rd,IHold, vgama, g(6,t) and g(5,t));

        th2Hold(15,16,rd,IHold, vgama,  g2ario(1,t) and g2ario(6,t));
	th2Hold(0,14,rd,IHold, vgama, g2ario(2,t) and g2ario(1,t));
	th2Hold(13,16,rd,IHold, vgama,  g2ario(3,t) and g2ario(2,t));
	th2Hold(0,15,rd,IHold, vgama, g2ario(4,t) and g2ario(3,t));
	th2Hold(14,16,rd,IHold, vgama,  g2ario(5,t) and g2ario(4,t));
	th2Hold(0,13,rd,IHold, vgama, g2ario(6,t) and g2ario(5,t));

end;

procedure funcsr(t: NReal);
begin
	rf[1]:= fase1(t);
	rf[2]:= fase2(t);
	rf[3]:= fase3(t);
	rf[4]:= EBateria;
end;


procedure inicio;
begin

for nn:= 1 to 7 do x0[nn]:=0; {inicializo variables de estado}

nn:=16;
nindep:=4;


tinicial:=0;
tfinal:=20e-3*nciclos;
dtmax0:=(tfinal-tinicial)/300;

PasoDivisor:=6;

TmaxTmin:=1e3;

traxp.tinicial:=tinicial;
traxp.tfinal:=tfinal;

(* {$IFDEF GrafOut} *)
iniciegr;

gridx:=10;
subplot(2,3);

gridy:=8;
definaY(0,-1,1/4);
ylabel('0.25/DIV');
titulo('uControl');
grid;
linea0;

superponga(9,0);
superponga(10,0);
superponga(11,0);

gridY:=7;
definaY(1,0,1);
ylabel('on/off');
titulo('Tiristores');
grid;
linea0;

superponga(12,1);
superponga(13,1);
superponga(14,1);
superponga(15,1);
superponga(16,1);

gridy:=8;
definaY(2,-400,100);
ylabel('100 V/DIV');
titulo('vth6');
grid;
linea0;

gridy:=8;
definaY(3,-400,100);
ylabel('100 V/DIV');
titulo('v[8]');
grid;
linea0;

superponga(7,3);

definaY(4,-5,5);
titulo('Corriente del Inductor');
ylabel('5 A/DIV');
grid;
linea0;

gridy:=8;
definaY(5,-400,100);
ylabel('100 V/DIV');
titulo('v56');
grid;
linea0;
superponga(18,2);
superponga(17,2);
definacolor(17,rojo);

superponga(19,5);

(* {$ENDIF } *)
end;


procedure PlotRef( canal: integer; var va: boolean; ff: TFunFase; t:NReal);
begin

	if ff(t-CuartoT)>0 then
	begin
		if not va then
		begin
			va:= true;
			desligue(canal);
		end;
		trazo(canal, ff(t));
	end
	else
	begin
		if va then
		begin
			va:= false;
			desligue(canal);
		end;
		trazo(canal, -ff(t));
	end;

end;


procedure PlotTiristor( canal: integer; nT: integer);
begin
	if dx[nt*2-1] then
	begin
		trazo(canal, 0.5+nt);
		if dx[nt*2] then trazo(canal, -0.1+nt);
	end
	else
	begin
		trazo(canal, 0.0+nt);
		if not dx[nt*2] then trazo(canal, -0.1+nt);
	end;
end;


procedure fin;
begin
readln;
TermineGr;
end;

procedure pesca;
var
	tecla: char;
        k:integer;

begin

traxp.t:=t;

trazo(7,v[9]);
trazo(4,x[1]);
trazo(3,v[8]);
trazo(0, uControl);

trazo(5,v[5]-v[8]);
if g(3,t) and g(2,t) then test:=1
   else test:=0;
trazo(19,test*200);


trazo(18,v[13]-v[16]);
if g2ario(3,t) and g2ario(2,t) then test:=1
   else test:=0;
trazo(17,test*200);

PlotRef( 9, va1, fase1, t);
PlotRef( 10, va2, fase2, t);
PlotRef( 11, va3, fase3, t);

plotTiristor( 1, 1);
plotTiristor( 12, 2);
plotTiristor( 13, 3);
plotTiristor( 14, 4);
plotTiristor( 15, 5);
plotTiristor( 16, 6);

	if t >= tfinal then
	begin


		for k:= 0 to 5 do
		begin
			borrecanal(k,0);
			desligue(k);
			grid;
			borde;
			linea0;
		end;
			t:= t-tfinal+tinicial;
	end;

end;






begin
FilUSR.Cirt1:=Cirt1;
FilUSR.Cirt2:=Cirt2;
FilUSR.FuncsR:=FuncsR;
FilUSR.Inicio:=Inicio;
FilUSR.Pesca:=Pesca;





{ Inicializamos el driver de controladores }
uCntrl.init;

{ Agregamos un control que es solamente un ttulo }
uCntrl.insert(new(PCtrlTexto, init(
			1,             { nmero del renglon en la banda de texto }
			'CONTROLES:'
			))); { nmero de caracteres del intertexto }

{ Agregamos control de la variable real uControl }
uCntrl.insert(new(PCtrlNRealInc, Init(
			'Q',           { letra de control }
			2,             { nmero del renglon en la banda de texto }
			'UControl:',        { Texto antes del valor }
			'[V]', { texto posterior al valor }
			5, 3,          { Formato del valor Campo:Decimales }
			-1, 1, 0.1, 0.05,  {Valmin, ValMax, ValDef, ValInc }
			uControl            { Variable controlada }
			)));

uCntrl.insert(new(PCtrlNRealInc, Init(
			'W',           { letra de control }
			3,             { nmero del renglon en la banda de texto }
			'EBateria:',        { Texto antes del valor }
			'[V]', { texto posterior al valor }
			3, 1,          { Formato del valor Campo:Decimales }
			-80, 80, 50, 1,  {Valmin, ValMax, ValDef, ValInc }
			EBateria            { Variable controlada }
			)));


{ Al apretar la letra 's' o 'S' se correr el procedimiento fin }
uCntrl.insert( new(PCtrlProcedure, Init(
			's',
			12,
			'Retorno)  =  Salir',
			fin )));  { procedimiento a ejecutar }
paseo;
fin
end.
