unit DIBUS;

interface

procedure INSIGNIA(x, y: integer; nombre: string; long, alt: integer);
procedure INSIGNIA_ON(x, y: integer; nombre: string; long, alt: integer);
procedure MARCO_DESNIVEL(X1, Y1, X2, Y2, SOMBRA, BRILLO: integer);
procedure ESPERAR;
procedure DIBUJO_CONTROL_BOTONERA(Anchopx, Altopx: integer);
procedure PONER_VENTANA(X1, Y1, X2, Y2: integer; texto1, texto2, texto3, texto4: string);
procedure PONER_VENTANA_CREDITOS;
procedure PONER_FLECHITA(X, Y: integer; derecha: boolean);
procedure ANOTAR_EVENTO(numero: integer; GRADOS1, GRADOS2, grados: real;
  enx, Y, Y1a, Y1b, Y2a, Y2b: integer; ETIQUETA: string);
procedure ANOTAR_TEXTO(numero: integer; GRADOS, GRAD: real; enx, Y, COLOR: integer;
  ETIQUETA: string);
procedure RELLENAR_EVENTO(GRADOS1, GRADOS2, grados: real; enx, Y1, Y2, COLOR: integer);

implementation

{-----------------------------------------------------------------------}
var
  guardado_enx: array[1..30] of integer;
  bandera_evento: array[1..30] of boolean;
  bandera_texto: array[1..30] of boolean;

  fondo_ventana: longint;
  Puntero_ventana: Pointer;
  fondo_flechita: longint;
  Puntero_flechita: Pointer;

  i: integer;

procedure INSIGNIA(x, y: integer; nombre: string; long, alt: integer);
begin
  SetLineStyle(0, 0, 0);
  SetColor(0);
  Line(x, y, x + long - 4, y);
  Line(x + long, y + 4, x + long, y + alt - 4);
  Line(x + long - 4, y + alt, x, y + alt);
  Line(x - 4, y + alt - 4, x - 4, y + 4);
  ARC(x, y + 4, 90, 180, 4);
  ARC(x + long - 4, y + 4, 0, 90, 4);
  ARC(x + long - 4, y + alt - 4, 270, 0, 4);
  ARC(x, y + alt - 4, 180, 270, 4);

  SetLineStyle(0, 0, 0);
  SetColor(8);

  Line(x - 2, y + 2, x - 2, y + alt - 2);
  Line(x - 1, y + 3, x - 1, y + alt - 1);
  Line(x - 3, y + 3, x - 3, y + alt - 3);
  Line(x - 2, y + alt - 2, x + long - 2, y + alt - 2);

  Line(x - 1, y + alt - 1, x + long - 3, y + alt - 1);

  SetFillStyle(1, 7);
  Bar(x - 1, y + 2, x + long - 3, y + alt - 3);

  SetColor(15);                     {..Brillos blancos..}
  Line(x - 1, y + 1, x + long - 4, y + 1);
  if alt > 25 then
  begin
    Line(x, y + 2, x + long - 3, y + 2);
    PutPixel(x + long - 3, y + 3, 15);
  end;
  Line(x + long - 1, y + 4, x + long - 1, y + alt - 4);
  Line(x + long - 2, y + 2, x + long - 2, y + alt - 3);
  PutPixel(x + long - 4, y + 2, 15);
  PutPixel(x + long - 3, y + 3, 15);

  PutPixel(x - 1, y + alt - 3, 8);
  PutPixel(x - 1, y + 3, 8);

  PutPixel(x - 2, y + 2, 7);

  PutPixel(x + long - 3, y + 2, 15);
  PutPixel(x + long - 3, y + alt - 3, 15);
  PutPixel(x + long - 2, y + alt - 2, 15);

  if alt > 34 then   {.........Boton especial del logotipo......}
  begin
    SetTextStyle(TriplexFont, 0, 2);
    SetColor(0);
    OutTextXY(x + 5, y + 1, 'SiMEEP');   {sombra}
    SetColor(15);
    OutTextXY(x + 7, y - 1, 'SiMEEP');  {luz}
    SetColor(4);
    OutTextXY(x + 6, y, 'SiMEEP');      {logo}
    SetTextStyle(smallfont, 0, 2);
        {  SetColor(0);
          OutTextXY(x+11, y+27, 'C r  d i t o   s');}
  end

  else
  begin
    SetTextStyle(smallfont, 0, 2);

    SetColor(0);
    if alt >= 16 then
      OutTextXY(x + 3, y + 4, nombre) {botones salir o pausa}
    else
      OutTextXY(x + 3, y + 1, nombre);{botones normales de control}

  end;
end;

{.........................................................................}


procedure INSIGNIA_ON(x, y: integer; nombre: string; long, alt: integer);
begin
  SetLineStyle(0, 0, 0);
  SetColor(0);
  Line(x, y, x + long - 4, y);
  Line(x + long, y + 4, x + long, y + alt - 4);
  Line(x + long - 4, y + alt, x, y + alt);
  Line(x - 4, y + alt - 4, x - 4, y + 4);
  ARC(x, y + 4, 90, 180, 4);
  ARC(x + long - 4, y + 4, 0, 90, 4);
  ARC(x + long - 4, y + alt - 4, 270, 0, 4);
  ARC(x, y + alt - 4, 180, 270, 4);

  SetColor(0);
  Line(x - 1, y + 1, x + long - 3, y + 1);
  Line(x + long - 1, y + 3, x + long - 1, y + alt - 2);
  Line(x - 3, y + 3, x - 3, y + alt - 3);
  Line(x - 1, y + alt - 1, x + long - 3, y + alt - 1);

  SetLineStyle(0, 0, 0);
  SetColor(8);
  Line(x + long - 3, y + 3, x + long - 3, y + alt - 3);
  Line(x + long - 2, y + 3, x + long - 2, y + alt - 2);

  Line(x - 2, y + 2, x + long - 2, y + 2);
  Line(x - 3, y + 3, x + long - 1, y + 3);
  Line(x - 3, y + 4, x + long - 1, y + 4);

  SetFillStyle(1, 7);
  Bar(x - 2, y + 3, x + long - 3, y + alt - 2);

  PutPixel(x - 2, y + alt - 2, 8);
  PutPixel(x - 2, y + 3, 8);

  PutPixel(x + long - 3, y + 3, 8);
  PutPixel(x + long - 3, y + alt - 2, 8);
  PutPixel(x + long - 3, y + alt - 2, 8);


  PutPixel(x + long - 1, y + 4, 0);
  PutPixel(x + long - 2, y + 2, 0);
  PutPixel(x + long - 1, y + 3, 0);
  SetTextStyle(smallfont, 0, 2);

  if alt > 34 then   {.........Boton especial del logotipo......}
  begin
    SetTextStyle(TriplexFont, 0, 4);
    SetColor(0);
    OutTextXY(x + 3, y + 3, 'SiMEEP');   {sombra}
    SetColor(15);
    OutTextXY(x + 5, y + 1, 'SiMEEP');  {luz}
    SetColor(4);
    OutTextXY(x + 4, y + 2, 'SiMEEP');
    SetTextStyle(smallfont, 0, 2);
{          SetColor(0);
          OutTextXY(x+7, y+29, 'C r  d i t o   s');}
  end

  else
  begin
    SetTextStyle(smallfont, 0, 2);
    SetColor(0);
    if alt >= 16 then
      OutTextXY(x + 1, y + 6, nombre)
    else
      OutTextXY(x + 1, y + 3, nombre);
  end;
  SetColor(0);
end;

{.........................................................................}

{-----------------------------------------------------------------------}

procedure MARCO_DESNIVEL(X1, Y1, X2, Y2, SOMBRA, BRILLO: integer);
begin
  SetLineStyle(0, 0, 0);
  SetColor(brillo);
  Line(x2, y2, x1, y2);
  Line(x1, y2, x1, y1);
  SetLineStyle(0, 0, 0);
  SetColor(sombra);
  Line(x1, y1, x2, y1);
  Line(x2, y1, x2, y2);
end;

{-----------------------------------------------------------------------}

procedure ESPERAR;    {..Espera hasta que se pulse cualquier tecla..}
var
  Ch: char;
begin

  repeat
  until keyPressed;
  Ch := ReadKey;
  if Ch = #0 then
    Ch := ReadKey;

  repeat
  until not keyPressed;
  Ch := ReadKey;
  if Ch = #0 then
    Ch := ReadKey;
end;

{-----------------------------------------------------------------------}

function CONVERTIR(L: longint): string;
var
  seg: string;
begin
  Str(L, seg);
  Convertir := seg;
end;

{-----------------------------------------------------------------------}

procedure DIBUJO_CONTROL_BOTONERA(Anchopx, Altopx: integer);
begin
  SetFillStyle(1, 6);  {.fondo marron.}
  Bar(1, 1, Anchopx, Altopx); //640,480);

  SetFillStyle(1, 1);  {.fondo gris.}
  Bar(Anchopx - (640 - 493), 11, AnchoPx - (640 - 629), AltoPx - (480 - 468));

  Marco_desnivel(Anchopx - (640 - 489), 6, anchopx - (640 - 632), altopx - (480 - 473), 14, 0);
  {Bloque soporte para las teclas}
  Marco_desnivel(anchopx - (640 - 492), 9, anchopx - (640 - 629), altopx - (480 - 470), 0, 11);
  {Bloque soporte para las teclas}
end;

{-----------------------------------------------------------------------}

procedure PONER_VENTANA(X1, Y1, X2, Y2: integer; texto1, texto2, texto3, texto4: string);
var
  x, y: word;
  der, izq, cnt: boolean;

begin
{$IFDEF USARRATON}
  PUNTERO_OFF;
{$ENDIF}

  Fondo_ventana := ImageSize(x1, y1, x2, y2);
  GetMem(Puntero_ventana, Fondo_ventana);
  GetImage(x1, y1, x2, y2, Puntero_ventana^);

  SetFillStyle(1, 0);
  Bar(X1, Y1 + 10, X2 - 10, Y2);
  SetFillStyle(1, 7);
  Bar(X1 + 10, Y1, X2, Y2 - 10);
  Marco_desnivel(X1 + 10, Y1, X2, Y2 - 10, 15, 0);
  SetFillStyle(1, 15);
  Bar(X1 + 10 + 10, Y1 + 10, X2 - 10, Y2 - 10 - 10);
  Marco_desnivel(X1 + 4 + 10, Y1 + 4, X2 - 4, Y2 - 4 - 10, 0, 15);

  SetColor(0);
  OutTextXY(x1 + 25, y1 + 15, texto1);
  OutTextXY(x1 + 25, y1 + 25, texto2);
  OutTextXY(x1 + 25, y1 + 35, texto3);
  OutTextXY(x1 + 25, y1 + 45, texto4);
  SetColor(0);
{$IFDEF USARRATON}
  PUNTERO_ON;

  {esperar boton derecho o tecla}
  repeat
    LEER_RATON(x, y, izq, cnt, der)
  until der or keypressed;

  repeat
    LEER_RATON(x, y, izq, cnt, der)
  until not der;
  PUNTERO_OFF;
{$ENDIF}

  PutImage(x1, y1, Puntero_ventana^, NormalPut);
  FreeMem(Puntero_ventana, Fondo_ventana);
{$IFDEF USARRATON}
  PUNTERO_ON;
{$ENDIF}
end;

{-----------------------------------------------------------------------}
procedure PONER_VENTANA_CREDITOS;
const
  X1 = 49;
  Y1 = 80;
  X2 = 449;
  Y2 = 400;

var
  x, y: word;
  der, izq, cnt: boolean;

begin

{$IFDEF USARRATON}
  PUNTERO_OFF;
{$ENDIF}

  Fondo_ventana := ImageSize(x1, y1, x2, y2);
  GetMem(Puntero_ventana, Fondo_ventana);
  GetImage(x1, y1, x2, y2, Puntero_ventana^);

  SetFillStyle(1, 0);
  Bar(X1, Y1 + 10, X2 - 10, Y2);
  SetFillStyle(1, 7);
  Bar(X1 + 10, Y1, X2, Y2 - 10);
  Marco_desnivel(X1 + 10, Y1, X2, Y2 - 10, 15, 0);
  SetFillStyle(1, 15);
  Bar(X1 + 10 + 10, Y1 + 10, X2 - 10, Y2 - 10 - 10);
  Marco_desnivel(X1 + 4 + 10, Y1 + 4, X2 - 4, Y2 - 4 - 10, 0, 15);

  SetTextStyle(TriplexFont, 0, 4);
  SetColor(4);
  OutTextXY(x1 + 149, y1 + 25, 'SiMEEP');
  SetLineStyle(0, 0, 2);
  Line(x1 + 149, y1 + 60, x1 + 149 + 105, y1 + 60);
  Line(x1 + 149, y1 + 61, x1 + 149 + 105, y1 + 61);

  SetTextStyle(DefaultFont, 0, 0);
  SetColor(1);
  CirCle(x1 + 153, y1 + 74, 6);
  OutTextXY(x1 + 142, y1 + 70, ' (c) Ruben Chaer');
  SetTextStyle(smallFont, 0, 2);
  OutTextXY(x1 + 35, y1 + 83, 'Simulador de Mquinas Elctricas y Electrnica de Potencia');


  SetTextStyle(defaultfont, 0, 0);
  SetColor(0);
  OutTextXY(x1 + 70, y1 + 133, '          Contribuyeron:');
  SetColor(1);
  OutTextXY(x1 + 70, y1 + 153, ' Alberto Rodriguez Ollacarizqueta');
  OutTextXY(x1 + 70, y1 + 168, '    Jos Javier Romero Galeano');
  SetTextStyle(smallfont, 0, 2);
  SetTextStyle(TriplexFont, 0, 2);
  SetColor(1);
  OutTextXY(x1 + 135, y1 + 178, '     ISTEC ');
  SetTextStyle(0, 0, 0);
  SetColor(0);
  OutTextXY(x1 + 70, y1 + 240, '    Universidad de la Repblica');
  OutTextXY(x1 + 70, y1 + 255, ' Instituto de Ingeniera Elctrica');
  OutTextXY(x1 + 70, y1 + 270, '          Uruguay , 1998');
  SetTextStyle(smallfont, 0, 2);

{$IFDEF USARRATON}
  PUNTERO_ON;

  {esperar boton derecho o izquierdo o tecla}
  repeat
    LEER_RATON(x, y, izq, cnt, der)
  until der or izq or keypressed;

  repeat
    LEER_RATON(x, y, izq, cnt, der)
  until not der and not izq;

  PUNTERO_OFF;
{$ENDIF}
  PutImage(x1, y1, Puntero_ventana^, NormalPut);
  FreeMem(Puntero_ventana, Fondo_ventana);
{$IFDEF USARRATON}
  PUNTERO_ON;
{$ENDIF}

end;

{-----------------------------------------------------------------------}

procedure PONER_FLECHITA(X, Y: integer; derecha: boolean);
var
  ch: char;
begin
{  Fondo_flechita:=ImageSize(x-10,y-10,x+30,y+10);
  GetMem(Puntero_flechita, Fondo_flechita);
  GetImage(x-10,y-40, x+30,y+40, Puntero_flechita^);
 }

  SetLineStyle(0, 0, 3);
  SetColor(15);
  Delay(300);
  if derecha = False then
  begin
    Line(x, y, x, y + 30);
    Line(x, y, x - 5, y + 10);
    Line(x, y, x + 5, y + 10);
  end
  else
  begin
    Line(x, y, x + 30, y);
    Line(x + 30, y, x + 25, y - 5);
    Line(x + 30, y, x + 25, y + 5);
  end;
  SetLineStyle(0, 0, 0);
end;

{----------------------------------------------------------------------}

procedure QUITAR_FLECHITA(X, Y: integer);
begin
  PutImage(x - 10, y - 40, Puntero_flechita^, NormalPut);
  SetLineStyle(0, 0, 0);
  FreeMem(Puntero_flechita, Fondo_flechita);
end;

{----------------------------------------------------------------------}

procedure ANOTAR_EVENTO(numero: integer; GRADOS1, GRADOS2, grados: real;
  enx, Y, Y1a, Y1b, Y2a, Y2b: integer; ETIQUETA: string);
begin
  SetColor(15);

  if (grados >= GRADOS1) and (grados < GRADOS2) and (bandera_evento[numero] = True) then
  begin
    guardado_enX[numero] := enx;{guardo el primer punto}
    bandera_evento[numero] := False;
  end;

  if (grados >= GRADOS2) and (bandera_evento[numero] = False) then
    {....final...}
  begin
    SetLineStyle(0, 0, 0); {pinto la linea del primer punto}
    Line(guardado_enX[numero] - 1, Y1a, guardado_enx[numero] - 1, Y1b);

    {linea horizontal}
    Line(guardado_enX[numero] - 1, y, enX - 1, y);

    {pinto linea del segundo punto}
    Line(enX - 1, y2a, enX - 1, y2b);
    {flecha1}
    Line(enx - 1 - 1, y, enX - 3 - 1, y - 2);
    Line(enX - 1 - 1, y, enX - 3 - 1, y + 2);
    {flecha2}
    Line(guardado_enx[numero] + 1, y, guardado_enx[numero] + 3, y - 2);
    Line(guardado_enx[numero] + 1, y, guardado_enx[numero] + 3, y + 2);
    if enX - guardado_enx[numero] >= 25 then
      OutTextXY(guardado_enX[numero] + 5, y - 13, etiqueta)
    else
      OutTextXY(guardado_enX[numero] - 10, y - 13, etiqueta);
    bandera_evento[numero] := True;
  end;

end;

{----------------------------------------------------------------------}

procedure RELLENAR_EVENTO(GRADOS1, GRADOS2, grados: real; enx, Y1, Y2, COLOR: integer);
begin
  if (grados >= grados1) and   {.intervalo a rellenar.}
    (grados <= grados2) then
  begin
    SetColor(Color);
    Line(enX, Y1, enX, Y2);
  end;
end;

{----------------------------------------------------------------------}

procedure ANOTAR_TEXTO(numero: integer; GRADOS, GRAD: real; enx, Y, COLOR: integer;
  ETIQUETA: string);
begin
  SetColor(15);

  if (grad <= GRADOS + 2) and (grad >= GRADOS) and (bandera_texto[numero] = True) then
  begin
    SetTextStyle(smallfont, 0, 2);
    SetColor(color);
    OutTextXY(enX, y, etiqueta);
    bandera_texto[numero] := False;
  end;

  if grad < 1 then
    bandera_texto[numero] := True;
end;

{----------------------------------------------------------------------}


begin
  for i := 1 to 30 do
  begin
    bandera_evento[i] := True;
    bandera_texto[i] := True;
  end;
end.
