{+doc
+NOMBRE: plotmems
+CREACION: 1.7.94
+AUTORES: rch
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO:  implementacin de mtodos de presentacin grafica del
	contenido de memorias digitales
+PROYECTO: SiMEEP

+REVISION:
+AUTOR: rch
+DESCRIPCION:
-doc}
unit plotmems;

interface
uses
	xMatDefs,
	MatReal,
	traxp,
	memorias;

procedure PlotMem_t( canal: integer; var Memoria: TMemoria; bar1, bar2: integer );
procedure PlotMem_EspectroDePotencia( canal: integer; var Memoria: TMemoria; bar1, bar2: integer );
procedure PlotMem_EspectroUnU1( canal: integer; var Memoria: TMemoria; bar1, bar2: integer );
procedure PlotMem_EspectroUn( canal: integer; var Memoria: TMemoria; bar1, bar2: integer );
procedure PlotMem_EspectroDePotenciaBar( canal: integer; var Memoria: TMemoria; bar1, bar2,colorPar,colorImpar: integer );
procedure PlotMem_EspectroUnU1Bar( canal: integer; var Memoria: TMemoria; bar1, bar2,colorPar,colorImpar: integer );
procedure PlotMem_EspectroUnBar( canal: integer; var Memoria: TMemoria; bar1, bar2,colorPar,colorImpar: integer );
procedure PlotMem_EspectroUnU1Bar_0_25( canal: integer; var Memoria: TMemoria);

implementation

procedure PlotMem_t( canal: integer; var Memoria: TMemoria; bar1, bar2: integer );
begin
	PlotRealVect( canal, bar2-bar1+1, Memoria.pv[bar1]);
end;

procedure PlotMem_EspectroDePotencia( canal: integer; var Memoria: TMemoria; bar1, bar2: integer );
var
	a: TVectR;
	k, nArmonicos: integer;
begin
	nArmonicos:= (bar2-bar1+1);
	a:= TVectR.Create_init( nArmonicos);
	for k:= bar1 to bar2 do
		a.pon_e( k-bar1+1, Memoria.PotenciaArmonica(k));
	PlotRealVect( canal, bar2-bar1+1, a.pv[1]);
	a.Free;
end;

procedure PlotMem_EspectroUnU1( canal: integer; var Memoria: TMemoria; bar1, bar2: integer );
var
	a: TVectR;
	k, nArmonicos: integer;
	U1: NReal;
begin
	nArmonicos:= (bar2-bar1+1);
	a:= TVectR.Create_init( nArmonicos);
	U1:= sqrt(Memoria.PotenciaArmonica(1));
	for k:= bar1 to bar2 do
		a.pon_e( k-bar1+1, sqrt(Memoria.PotenciaArmonica(k))/U1);
	PlotRealVect( canal, nArmonicos, a.pv[1]);
	a.Free;
end;

procedure PlotMem_EspectroUn( canal: integer; var Memoria: TMemoria; bar1, bar2: integer );
var
	a: TVectR;
	k, nArmonicos: integer;
begin
	nArmonicos:= (bar2-bar1+1);
	a:= TVectR.Create_init( nArmonicos);
	for k:= bar1 to bar2 do
		a.pon_e( k+1-bar1, sqrt(Memoria.PotenciaArmonica(k)));
	PlotRealVect( canal, nArmonicos, a.pv[1]);
	a.Free;
end;

procedure PlotMem_EspectroDePotenciaBar( canal: integer; var Memoria: TMemoria; bar1, bar2,colorPar,colorImpar: integer );
{limitacin: no se puede usar para superponer, y los colores para armonicos pares impares deben indicarse
 el nivel de continua si hay, se imprime en negro}
var
	a: TVectR;
	k, nArmonicos: integer;
begin
	gridx:=bar2-bar1;
	nArmonicos:= (bar2-bar1+1);
	a:= TVectR.Create_init( nArmonicos);

	for k:= bar1 to bar2 do
		a.pon_e( k-bar1+1, Memoria.PotenciaArmonica(k));
	PlotRealVectBar( canal, bar2-bar1+1, a.pv[1],colorPar,colorImpar,bar1);
	a.Free;
end;

procedure PlotMem_EspectroUnU1Bar( canal: integer; var Memoria: TMemoria; bar1, bar2,colorPar,colorImpar: integer );
{limitacin: no se puede usar para superponer, y los colores para armonicos pares impares deben indicarse
 el nivel de continua si hay, se imprime en negro}

var
	a: TVectR;
	k, nArmonicos: integer;
	U1: NReal;
begin
	gridx:=bar2-bar1;
	nArmonicos:= (bar2-bar1+1);
	a:= TVectR.Create_init( nArmonicos);
	U1:= sqrt(Memoria.PotenciaArmonica(1));
	for k:= bar1 to bar2 do
		a.pon_e( k-bar1+1, sqrt(Memoria.PotenciaArmonica(k))/U1);
	PlotRealVectBar( canal, nArmonicos, a.pv[1],colorPar,colorImpar,Bar1);
	a.Free;
end;

procedure PlotMem_EspectroUnBar( canal: integer; var Memoria: TMemoria; bar1, bar2,colorPar,colorImpar: integer);
{limitacin: no se puede usar para superponer, y los colores para armonicos pares impares deben indicarse
 el nivel de continua si hay, se imprime en negro}
var
	a: TVectR;
	k, nArmonicos: integer;
begin
	gridx:=bar2-bar1;
	nArmonicos:= (bar2-bar1+1);
	a:= TVectR.Create_init( nArmonicos);
	for k:= bar1 to bar2 do
		a.pon_e( k+1-bar1, sqrt(Memoria.PotenciaArmonica(k)));
	PlotRealVectBar( canal, nArmonicos, a.pv[1],colorPar,colorImpar,Bar1);
	a.Free;
end;

procedure PlotMem_EspectroUnU1Bar_0_25( canal: integer; var Memoria: TMemoria);
{limitacin: no se puede usar para superponer, y los colores para armonicos pares impares deben indicarse
 el nivel de continua si hay, se imprime en negro}

const   bar1=0;
		  bar2=26;
		  colorPar=azul;
		  colorImpar=rojo;
var
	k, nArmonicos: integer;
	U1: NReal;
begin
	gridx:=bar2-bar1;
	nArmonicos:= (bar2-bar1+1);
	U1:= sqrt(Memoria.PotenciaArmonica(1));
	gridy:=6;
	definay(canal,0,0.2);
	DefinaX(canal,1,(nArmonicos-1)/gridx);
	definacolor(canal,7);
	ylabel('20% /DIV');
	gridhorizontal;
	xlabel('O  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25');

	for k:= bar1 to bar2 do
	begin
		if odd(k) then	PlotRealBar(canal, nArmonicos,k-bar1+1,colorImpar, sqrt(Memoria.PotenciaArmonica(k))/U1 ,0)
		else if k<>0 then PlotRealBar(canal, nArmonicos,k-bar1+1,colorPar, sqrt(Memoria.PotenciaArmonica(k))/U1 ,0)
		else PlotRealBar(canal, nArmonicos,k-bar1+1,negro, sqrt(Memoria.PotenciaArmonica(k))/U1 ,0);


	end;

end;

end.
