
unit libEP;



interface

uses xMatDefs, variable, Lib_basi;

procedure InducSat(k,h,j:integer;LNSat,LSat,ISat,RES:NReal);
procedure TrNPN(b,c,e:integer;beta,rbe:NReal);
procedure TrPNP(b,c,e:integer;beta,rbe:NReal);
procedure diodonp(k,j:integer;Rd,Rf,Vgama:NReal);
procedure diodo(k,j:integer);
procedure diodoIdeal(k,j:word;rd:NReal);
procedure Zener(k,j:integer;Vz:NReal);
procedure ll(k,j:integer; pos:boolean);
procedure ll2p(k1, km, k0: integer; pos: boolean);
procedure ThIdeal(a,k:integer;g:boolean);
procedure limitar( var y: NReal; ymin, ymax: NReal);


implementation

(* Atencin, estas banderitas son para que los modelos de transisteores
puedan invertir de a una las llaves. *)
var
 TrNPNflipflop:boolean=true;
 TrPNPflipflop:boolean=true;


procedure limitar( var y: NReal; ymin, ymax: NReal);
begin
	if y>ymax then y:= ymax
	else
		if y<ymin then y:= ymin;
end;


procedure InducSat(k,h,j:integer;LNSat,LSat,ISat,RES:NReal);

var
	LTemp:NReal;

begin
nd:=nd+1;
if chek then dx[nd]:=abs((v[k]-v[h])/RES) > Isat
else
	begin
	if dx[nd] then LTemp:=LSat
	else LTemp:=LNSat;
	r(k,h,RES);
	l(h,j,LTemp);
	end;
end; (* InducSat *)

procedure ThIdeal(a,k:integer;g:boolean);
const
     vgama=1;
     rd=0.01;

var
	 dr:NReal;

begin
     nd:=nd+1;
     if chek then begin
                  if ( v[a]>v[k]+vgama) and g then dx[nd]:=true;
                  if v[a]<v[k]+vgama then dx[nd]:=false
                   end

else
	begin
	if dx[nd] then
		begin
		r(a,k,rd);
		ig(0,k,a,vgama/rd);
		end
	else
		(* nada *)
	end;
end;

(***************************14/3/90/RCH************************)
procedure TrNPN(b,c,e:integer;beta,rbe:NReal);


var
 vbe,vbc,betaI,rbc,rfugas:NReal;
 j1,j2:boolean;

begin
vbe:=0.7;
vbc:=0.5;
rbc:=rbe;
rfugas:=3e12;
betaI:=beta/30;

nd:=nd+2;
if chek then
begin
  j1:=dx[nd-1];
  j2:=dx[nd];
  dx[nd-1]:=v[b]>v[e]+vbe;
  dx[nd]:=v[b]>v[c]+vbc;
  if (j1 =not dx[nd-1] ) and ( j2 =not dx[nd]) then
  begin
    TrNPNflipflop:=not TrNPNflipflop;
    if TrNPNflipflop then
      dx[nd-1]:=j1
    else
      dx[nd]:=j2
  end
end
else
 begin
  if dx[nd-1] then
            begin
            r(e,b,rbe);
            ig(0,e,b,vbe/rbe);
            iv(c,e,e,b,beta/rbe);
            ig(0,e,c,vbe/rbe*beta)
            end
  else begin
        r(b,e,rfugas);
        r(c,e,rfugas)
        end;
  if dx[nd] then
            begin
            r(c,b,rbc);
            ig(0,c,b,vbc/rbc);
            iv(e,c,c,b,betaI/rbc);
            ig(0,c,e,vbc/rbc*betaI)
            end
  else begin
        r(b,c,rfugas);
        r(e,c,rfugas)
        end
 end
end; (* TRnpn *)

(**************************************************************)
(***************************15/3/90/RCH************************)
procedure TrPNP(b,c,e:integer;beta,rbe:NReal);
var
 vbe,vbc,betaI,rbc,rfugas:NReal;
 j1,j2:boolean;

begin
vbe:=0.7;
vbc:=0.5;
rbc:=rbe;
rfugas:=3e12;
betaI:=beta/30;

nd:=nd+2;
if chek then
        begin
        j1:=dx[nd-1];
        j2:=dx[nd];
        dx[nd-1]:=v[b]<v[e]-vbe;
        dx[nd]:=v[b]<v[c]-vbc;
        if (j1 =not dx[nd-1] ) and ( j2 =not dx[nd]) then
                          begin
                          TrPNPflipflop:=not TrPNPflipflop;
                          if TrPNPflipflop then dx[nd-1]:=j1
                          else dx[nd]:=j2
                          end
        end
else
 begin
  if dx[nd-1] then
            begin
            r(e,b,rbe);
            ig(0,e,b,-vbe/rbe);
            iv(e,c,b,e,beta/rbe);
            ig(0,e,c,-vbe/rbe*beta)
            end
  else begin
        r(b,e,rfugas);
        r(c,e,rfugas)
        end;
  if dx[nd] then
            begin
            r(c,b,rbc);
            ig(0,c,b,-vbc/rbc);
            iv(c,e,b,c,betaI/rbc);
            ig(0,c,e,-vbc/rbc*betaI)
            end
  else begin
        r(b,c,rfugas);
        r(e,c,rfugas)
        end
 end
end; (* TRpnp *)

(**************************************************************)
procedure diodonp(k,j:integer;Rd,Rf,Vgama:NReal);
(*28/8/89*)
begin
nd:=nd+1;
if chek then dx[nd]:=((v[k]-v[j]-vgama)/rd)>(vgama/rf)
else
 if dx[nd] then rvg(j,k,rd,vgama)
    else r(k,j,rf)

end;(* diodonp *)

procedure diodoIdeal(k,j:word;rd:NReal);
begin
nd:=nd+1;
if chek then dx[nd]:=v[k]>v[j]
else
	if dx[nd] then r(k,j,rd)
	else (* circuito abierto *)
end;


procedure ll(k,j:integer; pos:boolean);
begin
nd:=nd+1;
if chek then dx[nd]:=pos
else
    if dx[nd] then vg(0,k,j,0)
    else (* y(k,j,0) *);
end;

procedure ll2p(k1, km, k0: integer; pos: boolean);
begin
nd:=nd+1;
if chek then dx[nd]:=pos
else
    if dx[nd] then vg(0,k1,km,0)
    else vg(0,k0,km,0);
end;


procedure diodo(k,j:integer);
const
     rd=0.001;     (* resistencia en directa *)
     rf=1e6; (* resistencia de fugas   *)
     vgama=0.7;

begin
diodonp(k,j,rd,rf,vgama);
end; {diodo}

procedure Zener(k,j:integer;Vz:NReal);
begin
diodo(k,j);
diodonp(j,k,0.001,1e6,vz);
end; (* Zener *)

begin

end.
