{+doc
+NOMBRE: ucntrl
+CREACION: 30.06.96
+AUTORES: rch
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO: Definicin de ventana de control de un parmetro para
  Simeep.


+PROYECTO: Simeep.

+REVISION:
+AUTOR:
+DESCRIPCION:
-doc}


unit ucntrl;

interface

uses
  traxp, wingraph,
  //  Objects,
  Classes,
  xMatDefs, FilUsr, DIBUS,
  winCRT
        {$IFDEF RCHFonts}
  , RCHFonts
        {$ENDIF}
        {$IFDEF USARRATON}
  , Raton
        {$ENDIF}        ;

const
  interlineado: NReal = 2;
  ColorTexto: word = Amarillo;
  ticsvisualizacion: integer = 50;
  {valor de conteo para desborde de variables}{contador de captura de visualizacion}
  AltoRenglon = 38 + 5;

type
  {seales de aviso para el objeto PCtrlBoton}
  TMouseEvent = (
    BotonIzqAbajo, BotonIzqArriba,
    Arrivo, Abandono, Movimiento,
    BotonDerAbajo, BotonDerArriba
    );

type

  PCtrl = ^TCtrl;

  TCtrl = object { Genrico. }
    LetraControl: char;
    renglon: integer;
    texto1, texto2: string;
    campo: integer;

    constructor Init(xLetraControl: char; xrenglon: integer;
      xtexto1: string; xtexto2: string; xCampo: integer);
    { nmero de caracteres del intertexto }
    destructor done; virtual;
    procedure ActuarOnKey(Letra: char); virtual;
    procedure ActuarOnMouse(MouseEvent: TMouseEvent); virtual;
    procedure WriteTxt(texto: string); virtual;
    procedure Pintar; virtual;
    procedure Incrementar; virtual;
    procedure Decrementar; virtual;
    function TocadoXY(x, y: integer): boolean; virtual;
  end;


  PCtrlTexto = ^TCtrlTexto;

  TCtrlTexto = object(TCtrl)
    constructor Init(xrenglon: integer; xtexto1: string);
    procedure WriteTxt(texto: string); virtual;
  end;



  PCtrlVerTexto = ^TCtrlVerTexto;

  TCtrlVerTexto = object(TCtrl)
    constructor Init(xrenglon: integer; Texto_Arriba, Texto_Medio, Texto_Abajo: string);
    procedure WriteTxt(texto: string); virtual;
    procedure Pintar; virtual;
  end;

  PCtrlVer2Var = ^TCtrlVer2Var;

  TCtrlVer2Var = object(TCtrl)
    texto3, texto4: string;
    decimales1, decimales2: integer;
    valor_mostrado1, valor_mostrado2: NReal;
    pvar1, pvar2: PNReal;
    constructor Init(xrenglon: integer; xtexto11: string; xtexto12: string;
      xDecimales1: integer; var Variable1: NReal; xtexto21: string;
      xtexto22: string; xDecimales2: integer; var Variable2: NReal);
    procedure ActuarOnKey(Letra: char); virtual;
    procedure WriteTxt(texto: string); virtual;
  end;

  PCtrlBoton = ^TCtrlBoton;

  TCtrlBoton = object(TCtrl)
    xproc: ExtProc;
    Apretado: boolean;
    xx1, yy1, xx2, yy2: integer;
    constructor Init(nxx1, nyy1, nxx2, nyy2: integer; xtexto1: string; nxproc: ExtProc);
    procedure WriteTxt(texto: string); virtual;
    procedure Paint; virtual;
    procedure ActuarOnMouse(MouseEvent: TMouseEvent); virtual;
    function TocadoXY(x, y: integer): boolean; virtual;
  end;


  PCtrlBotonVar = ^TCtrlBotonVar;

  TCtrlBotonVar = object(TCtrlBoton)
    valor: NReal;
    factor: NReal;    {factor que depende de la unidad seleccionada M,k,m,u,n o p}
    desplazamiento: integer;
    boton: integer;  {0 boton izquierdo; 1 derecho}
    pvar: PNReal;
    deci: integer;
    min, max, def, incr: NReal;
    constructor Init(xrenglon: integer; xtexto1, xtexto2: string;
      xdeci: integer; xmin, xmax, xdef, xincr: NReal; var VariableControlada: NReal);
    procedure WriteTxt(texto: string); virtual;
    procedure Paint; virtual;
    procedure ActuarOnMouse(MouseEvent: TMouseEvent); virtual;
    function TocadoXY(x, y: integer): boolean; virtual;
    procedure Incrementar; virtual;
    procedure Decrementar; virtual;
  end;


  PCtrlBotonVar2 = ^TCtrlBotonVar2;

  TCtrlBotonVar2 = object(TCtrlBotonVar)
    pmin, pmax: PNReal;
    constructor Init(xrenglon: integer; xtexto1, xtexto2: string;
      xdeci: integer; var xmin, xmax: NReal; xdef, xincr: NReal;
      var VariableControlada: NReal);
    procedure ActuarOnKey(Letra: char); virtual;
    procedure Incrementar; virtual;
    procedure Decrementar; virtual;
  end;


  PCtrlBotonProc = ^TCtrlBotonProc;

  TCtrlBotonProc = object(TCtrlBoton)
    constructor Init(xrenglon: integer; xtexto1: string; nxproc: ExtProc);
  end;


  PCtrlNRealInc = ^TCtrlNRealInc;

  TCtrlNRealInc = object(TCtrl)
    Decimales: integer;
    MinVal, MaxVal, DefVal, IncVal: NReal;
    pvar: PNReal;

    constructor Init(xLetraControl: char; xrenglon: integer;
      xtexto1: string; xtexto2: string; xCampo, xDecimales: integer;
      xMinVal, xMaxVal, xDefVal, xIncVal: NReal; var VariableControlada: NReal);
    procedure Pintar; virtual;
    procedure Incrementar; virtual;
    procedure Decrementar; virtual;
  end;


  PDsplyNReal = ^TDsplyNReal;

  TDsplyNReal = object(TCtrlNRealInc)
    constructor Init(xrenglon: integer; xtexto1: string; xtexto2: string;
      xCampo, xDecimales: integer; var VariableControlada: NReal);
    procedure ActuarOnKey(Letra: char); virtual;
    procedure WriteTxt(texto: string); virtual;
  end;


  PCtrlNRealFac = ^TCtrlNRealFac;

  TCtrlNRealFac = object(TCtrlNRealInc)
    constructor Init(xLetraControl: char; xrenglon: integer;
      xtexto1: string; xtexto2: string; xCampo, xDecimales: integer;
      xMinVal, xMaxVal, xDefVal, xFacVal: NReal; var VariableControlada: NReal);
    procedure Incrementar; virtual;
    procedure Decrementar; virtual;
  end;


  PCtrlNEntero = ^TCtrlNEntero;

  TCtrlNEntero = object(TCtrl)
    MinVal, MaxVal, DefVal, IncVal: NEntero;
    pvar: PNEntero;

    constructor Init(xLetraControl: char; xrenglon: integer;
      xtexto1: string; xtexto2: string; xCampo: integer;
      xMinVal, xMaxVal, xDefVal, xIncVal: NEntero; var VariableControlada: NEntero);
    procedure Pintar; virtual;
    procedure Incrementar; virtual;
    procedure Decrementar; virtual;
  end;


  PDsplyNEntero = ^TDsplyNEntero;

  TDsplyNEntero = object(TCtrlNEntero)
    constructor Init(xrenglon: integer; xtexto1: string; xtexto2: string;
      xCampo: integer; var VariableControlada: NEntero);
    procedure ActuarOnKey(Letra: char); virtual;
    procedure WriteTxt(texto: string); virtual;
  end;


  PCtrlBoolean = ^TCtrlBoolean;

  TCtrlBoolean = object(TCtrl)
    pvar: ^boolean;

    constructor Init(xLetra: char; xrenglon: integer; xtexto1: string;
      var xvar: boolean);

    procedure Pintar; virtual;
    procedure Incrementar; virtual;
    procedure Decrementar; virtual;

  end;

  PCtrlToggle = ^TCtrlToggle;

  TCtrlToggle = object(TCtrlBoolean)
    constructor Init(xLetra: char; xrenglon: integer; xtexto1: string;
      var xvar: boolean);
    procedure Incrementar; virtual;
    procedure Decrementar; virtual;
  end;


  PCtrlProcedure = ^TCtrlProcedure;

  TCtrlProcedure = object(TCtrl)
    proc: ExtProc;

    constructor Init(xLetra: char; xrenglon: integer; xtexto1: string;
      xproc: ExtProc);

    procedure Pintar; virtual;
    procedure Incrementar; virtual;
    procedure Decrementar; virtual;

  end;


  TControles = object
    lista: TList;
    PActivo: PCtrl;
    constructor Init;
    procedure ActuarOnKey(Letra: char); virtual;
    procedure ActuarOnMouse(x, y: integer; Evento: TMouseEvent); virtual;
    function PTocadoXY(x, y: integer): PCtrl;
    procedure Pintar;
  end;




procedure Init;
procedure Insert(p: pointer);
procedure InsertDisplay(p: pointer);


implementation



var
  UsrPesca, UsrInicio: ExtProc;
  Controles, Displays: TControles;
  I: integer;
  {Estado del MOUSE}
  xx, yy: word;
  izquierda, centro, derecha: boolean;

  {para implementar la pausa en el procedimiento UCTRLpesca}
  PAUSA: boolean;

  {para forzar la visualizacion de variables}
  contador: integer;

procedure Insert(p: pointer);
begin
  Controles.Lista.add(p);
end;

procedure InsertDisplay(p: pointer);
begin
  Displays.lista.add(p);
end;


procedure UCntrlInicio; far;
begin
  UsrInicio;
  Controles.Pintar;
  Displays.Pintar;
end;


procedure Ppausa; far;
begin
  Sound(1000, 40);
  pausa := not pausa;
end;

procedure creditos; far;
begin
  Sound(1000, 40);
  poner_ventana_creditos;
end;



procedure UCntrlPesca; far;
var
  tecla: char;
  x, y: word;
  izq, cnt, der: boolean;
  ocurrio_pausa: boolean;
  color_de_fondo: word;
begin
{$IFDEF USARRATON}

  PUNTERO_ON;
{$ENDIF}
  UsrPesca;

  pausa := False;
  ocurrio_pausa := False;

  repeat {bucle de pausa}




    {forzar visualizaciones}
    contador := contador + 1;
    if contador > ticsvisualizacion then
      contador := 0;

    if contador = ticsvisualizacion then
    begin
      Displays.ActuarOnKey(tecla);
    end;



    if keypressed then
    begin
      tecla := readkey;
      Controles.ActuarOnKey(tecla);
    end
    else
      { Hacemos esto para que los controles que admiten se cambie su
        valor externamente, funcionen}
      Controles.ActuarOnKey('');  {ESTE CARACTER NO SE PUEDE USAR COMO CONTROL}

                        {$IFDEF USARRATON}

    LEER_RATON(x, y, izq, cnt, der);
    if (x <> xx) or (y <> yy) then
      Controles.ActuarOnMouse(x, y, Movimiento);

    if izq <> izquierda then
      if izq then
        Controles.ActuarOnMouse(x, y, BotonIzqAbajo)
      else
        Controles.ActuarOnMouse(x, y, BotonIzqArriba);

    if der <> derecha then
      if der then
        Controles.ActuarOnMouse(x, y, BotonDerAbajo)
      else
        Controles.ActuarOnMouse(x, y, BotonDerArriba);

    xx := x;
    yy := y;
    izquierda := izq;
    centro := cnt;
    derecha := der;

    if pausa then      {liberar al raton a toda la pantalla}
    begin
      ocurrio_pausa := True;
      RANGO_FILA(7, 465);
      RANGO_COLUMNA(5, 625);
    end;
                {$ENDIF}
  until not pausa;

        {$IFDEF USARRATON}
  if ocurrio_pausa then   {reponer los limites del raton al area de control}
  begin
    RANGO_FILA(7, 465);
    RANGO_COLUMNA(490, 625);
  end;

        {$ENDIF}
end;


procedure Init;
begin
  INICIEGR;
  DIBUJO_CONTROL_BOTONERA(GetMaxX, GetMaxY);
{$IFDEF USARRATON}
  INICIALIZAR_RATON;
{$ENDIF}

  Controles.Init;
  Displays.init;
  UsrPesca := FilUsr.Pesca;
  FilUsr.Pesca := UCntrlPesca;
  UsrInicio := FilUsr.Inicio;
  FilUsr.Inicio := UCntrlInicio;

  {logotipo}
  UCntrl.insert(new(PCtrlBoton, Init(GetMaxX - (640 - 502), 14, GetMaxX -
    (640 - 502) + 120, 14 + 42, '', creditos)));

  {botones de pausa y salir}
  UCntrl.insert(new(PCtrlBoton, Init(GetMaxX - (640 - 502), GetMaxY -
    100, GetMaxX - (640 - 554) + 8, GetMaxY - 100 + 12, ' PAUSA', Ppausa)));
  UCntrl.insert(new(PCtrlBoton, Init(GetMaxX - (640 - 567) + 4, GetMaxY -
    100, GetMaxX - (640 - 621) + 4, GetMaxY - 100 + 12, ' SALIR', FilUsr.Fin)));
end;



constructor TCtrl.Init(xLetraControl: char; xrenglon: integer;
  xtexto1: string; xtexto2: string; xCampo: integer);
  { nmero de caracteres del intertexto }
begin
  LetraControl := UpCase(xLetraControl);
  renglon := xrenglon + 3;  {no solapar con boton SIMEEP}
  texto1 := xtexto1;
  texto2 := xtexto2;
  campo := xcampo;
end;

procedure TCtrl.ActuarOnMouse(MouseEvent: TMouseEvent);
begin
end;

function TCtrl.TocadoXY(x, y: integer): boolean;
begin
  TocadoXY := False;
end;

procedure TCtrl.WriteTxt(texto: string);

var
  vp: ViewPortType;
  t: TextSettingsType;
  x1, x2, y1, y2: integer;
  OldColor: word;
begin

  Texto := LetraControl + ') ' + texto;
  GetTextSettings(t);
  SetTextStyle(t.font, HorizDir, t.CharSize);
  SetTextJustify(LeftText, BottomText);

  x1 := GetMaxY + TextWidth('M') * 3;
  x2 := x1 + TextWidth(texto);
  y1 := trunc((renglon * interlineado) * TextHeight('H'));
  y2 := y1 - TextHeight('H');

  GetViewSettings(vp);
  SetViewPort(x1, y2, x2, y1, True);
  ClearViewPort;
  with vp do
    SetViewPort(x1, y1, x2, y2, Clip);
  OldColor := GetColor;
  SetColor(ColorTexto);
  OutTextXY(x1, y1, texto);
  SetColor(OldColor);
  SetTextStyle(t.font, t.Direction, t.CharSize);
  SetTextJustify(t.Horiz, t.Vert);
end;

procedure TCtrl.Pintar;
var
  s: string;
  k: integer;
begin
  s := texto1;
  for k := 1 to campo do
    s := s + ' ';
  s := s + texto2;
  WriteTXT(s);
end;

procedure TCtrl.ActuarOnKey(Letra: char);
begin
  if upCase(letra) = LetraControl then
  begin
    if upCase(Letra) = Letra then
      incrementar
    else
      decrementar;
  end;
end;

procedure TCtrl.Incrementar;
begin
  Pintar;
end;

procedure TCtrl.Decrementar;
begin
  Pintar;
end;


destructor TCtrl.done;
begin
end;

{ Mtodos de TCtrlNRealInc }

constructor TCtrlNRealInc.Init(xLetraControl: char; xrenglon: integer;
  xtexto1: string; xtexto2: string; xCampo, xDecimales: integer;
  xMinVal, xMaxVal, xDefVal, xIncVal: NReal; var VariableControlada: NReal);
begin
  TCtrl.init(xLetraControl, xrenglon, xtexto1, xtexto2, xCampo);
  Decimales := xDecimales;
  MinVal := xMinVal;
  MaxVal := xMaxVal;
  DefVal := xDefVal;
  IncVal := xIncVal;
  pvar := @VariableControlada;
end;

procedure TCtrlNRealInc.Pintar;
var
  s: string;
  k: integer;
begin
  str(pvar^: Campo: Decimales, s);
  s := texto1 + s + texto2;
  writetxt(s);
end;

procedure TCtrlNRealInc.Incrementar;
begin
  pvar^ := pvar^ + IncVal;
  if pvar^ > MaxVal then
    pvar^ := MaxVal;
  Pintar;
end;

procedure TCtrlNRealInc.Decrementar;
begin
  pvar^ := pvar^ - IncVal;
  if pvar^ < MinVal then
    pvar^ := MinVal;
  Pintar;
end;




constructor TCtrlNRealFac.Init(xLetraControl: char; xrenglon: integer;
  xtexto1: string; xtexto2: string; xCampo, xDecimales: integer;
  xMinVal, xMaxVal, xDefVal, xFacVal: NReal; var VariableControlada: NReal);
begin
  TCtrlNRealInc.init(
    xLetraControl,
    xrenglon,
    xtexto1,
    xtexto2,
    xCampo, xDecimales,
    xMinVal, xMaxVal, xDefVal, xFacVal,
    VariableControlada);
end;

procedure TCtrlNRealFac.Incrementar;
begin
  pvar^ := pvar^ * IncVal;
  if pvar^ > MaxVal then
    pvar^ := MaxVal;
  Pintar;
end;

procedure TCtrlNRealFac.Decrementar;
begin
  pvar^ := pvar^ / IncVal;
  if pvar^ < MinVal then
    pvar^ := MinVal;
  Pintar;
end;




constructor TCtrlNEntero.Init(xLetraControl: char; xrenglon: integer;
  xtexto1: string; xtexto2: string; xCampo: integer;
  xMinVal, xMaxVal, xDefVal, xIncVal: NEntero; var VariableControlada: NEntero);
begin
  TCtrl.init(xLetraControl, xrenglon, xtexto1, xtexto2, xCampo);
  MinVal := xMinVal;
  MaxVal := xMaxVal;
  DefVal := xDefVal;
  IncVal := xIncVal;
  pvar := @VariableControlada;
end;

procedure TCtrlNEntero.Pintar;
var
  s: string;
  k: integer;
begin
  str(pvar^: Campo, s);
  s := texto1 + s + texto2;
  writetxt(s);
end;

procedure TCtrlNEntero.Incrementar;
begin
  pvar^ := pvar^ + IncVal;
  if pvar^ > MaxVal then
    pvar^ := MaxVal;
  Pintar;
end;

procedure TCtrlNEntero.Decrementar;
begin
  pvar^ := pvar^ - IncVal;
  if pvar^ < MinVal then
    pvar^ := MinVal;
  Pintar;
end;

{
  Metodos del objeto TCtrlVerTexto
  que muestra una pantalla de tres lineas de texto
}

constructor TCtrlVerTexto.Init(xrenglon: integer;
  Texto_arriba, Texto_medio, Texto_abajo: string);
begin
  SetFillStyle(1, 1);  {.fondo gris.}
  Bar(GetMaxX - (640 - 497),
    xRENGLON * AltoRenglon + 60,
    GetMaxX - (640 - 625),
    xRENGLON * AltoRenglon + 60 + 30 + 15);
  {       MARCO_DESNIVEL(496,xRENGLON*AltoRenglon+60-1, 626,xRENGLON*AltoRenglon+60+31,0,11);}

  SetColor(14);
  OutTextXY(GetMaxX - (640 - 500), xRENGLON * AltoRenglon + 59, texto_Arriba);
  OutTextXY(GetMaxX - (640 - 500), xRENGLON * AltoRenglon + 69 + 5, texto_medio);
  OutTextXY(GetMaxX - (640 - 500), xRENGLON * AltoRenglon + 79 + 10, texto_abajo);
end;

procedure TCtrlVerTexto.WriteTxt(texto: string);
begin
end;

procedure TCtrlVerTexto.Pintar;
begin
end;

{
Metodos de tctrlVer2Var. para mostrar el valor de 2 variables reales
}

constructor TCtrlVer2Var.Init(xrenglon: integer; xtexto11: string;
  xtexto12: string; xDecimales1: integer; var Variable1: NReal;
  xtexto21: string; xtexto22: string; xDecimales2: integer; var Variable2: NReal);
begin
  pvar1 := @variable1;
  pvar2 := @variable2;
  texto1 := xtexto11;
  texto2 := xtexto12;
  texto3 := xtexto21;
  texto4 := xtexto22;
  renglon := xrenglon;
  decimales1 := xdecimales1;
  decimales2 := xdecimales2;
  valor_mostrado1 := 0;
  valor_mostrado2 := 0;

  SetFillStyle(1, 3);  {.fondo gris.}
  Bar(GetmaxX - (640 - 497),
    RENGLON * AltoRenglon + 60,
    getmaxx - (640 - 625),
    RENGLON * AltoRenglon + 60 + 30 + 10);
  {.marco_todo.}
  MARCO_DESNIVEL(getmaxx - (640 - 496),
    RENGLON * AltoRenglon + 60 - 1,
    getmaxx - 640 + 626,
    RENGLON * AltoRenglon + 60 + 31 + 10,
    0, 15);
  MARCO_DESNIVEL(getmaxx - 640 + 497,
    RENGLON * AltoRenglon + 60,
    getmaxx - 640 + 625,
    RENGLON * AltoRenglon + 60 + 30 + 10,
    0, 15);

  SetFillStyle(1, 0); {.pinto display.}
  Bar(getmaxx - 640 + 524 + 25,
    RENGLON * AltoRenglon + 60 + 3,
    getmaxx - 640 + 644 - 43,
    RENGLON * AltoRenglon + 74 + 5);

  Bar(getmaxx - 640 + 524 + 25,
    RENGLON * AltoRenglon + 60 + 17 + 5,
    getmaxx - 640 + 644 - 43,
    RENGLON * AltoRenglon + 60 + 30 - 2 + 10);

  {.marco_display.}
  MARCO_DESNIVEL(getmaxx - 640 + 524 + 25,
    RENGLON * AltoRenglon + 63,
    getmaxx - 640 + 644 - 43,
    RENGLON * AltoRenglon + 74 + 5,
    0, 15);

  {.marco_display.}
  MARCO_DESNIVEL(getmaxx - 640 + 524 + 25,
    RENGLON * AltoRenglon + 60 + 17 + 5,
    getmaxx - 640 + 644 - 43,
    RENGLON * AltoRenglon + 60 + 30 - 2 + 10,
    0, 15);

  {pinto etiqueta de unidad y de variable.}
  SetTextStyle(smallfont, 0, 2);
  SetColor(0);
  OutTextXY(getmaxx - 640 + 500, RENGLON * AltoRenglon + 61 + 4, texto1);
  OutTextXY(getmaxx - 640 + 605, RENGLON * AltoRenglon + 61 + 4, texto2);

  OutTextXY(getmaxx - 640 + 500, RENGLON * AltoRenglon + 76 + 5, texto3);
  OutTextXY(getmaxx - 640 + 605, RENGLON * AltoRenglon + 76 + 5, texto4);
end;


procedure TCtrlVer2Var.ActuarOnKey(Letra: char);
var
  auxtexto: string;
begin
  if valor_mostrado1 <> pvar1^ then
  begin
    valor_mostrado1 := pvar1^;

    SetTextStyle(smallfont, 0, 2);
    SetFillStyle(1, 0);

    Bar(getmaxx - 640 + 524 + 25 + 1,
      RENGLON * AltoRenglon + 60 + 3,
      getmaxx - 640 + 644 - 43,
      RENGLON * AltoRenglon + 74 + 5 - 1);


    SetColor(14);
    str(pvar1^: 6: decimales1, auxtexto);
    OutTextXY(getmaxx - 640 + 560, renglon * AltoRenglon + 60 + 2 + 2, auxtexto);

  end;
  if valor_mostrado2 <> pvar2^ then
  begin
    valor_mostrado2 := pvar2^;

    SetTextStyle(smallfont, 0, 2);
    SetFillStyle(1, 0);

    Bar(getmaxx - 640 + 524 + 25 + 1,
      RENGLON * AltoRenglon + 60 + 17 + 5,
      getmaxx - 640 + 644 - 43,
      RENGLON * AltoRenglon + 60 + 30 - 2 + 10 - 1);

    SetColor(14);
    str(pvar2^: 6: decimales2, auxtexto);
    OutTextXY(getmaxx - 640 + 560, renglon * AltoRenglon + 60 + 16 + 5 + 1, auxtexto);

  end;
end;

procedure TCtrlVer2Var.WriteTxt(texto: string);
begin
end;

{
***************************************
Mtodos de TCtrlBoton
***************************************
***************************************
}

constructor TCtrlBoton.Init(nxx1, nyy1, nxx2, nyy2: integer; xtexto1: string;
  nxproc: ExtProc);
begin
  texto1 := xtexto1;
  xx1 := nxx1;
  yy1 := nyy1;
  xx2 := nxx2;
  yy2 := nyy2;

  apretado := False;
  xproc := nxproc;

  INSIGNIA(xx1, yy1, texto1, xx2 - xx1, yy2 - yy1); {primer PAINT}
end;


procedure TCtrlBoton.WriteTxt(texto: string);
begin
  { para definir en los descendientes}
end;



procedure TCtrlBoton.Paint;
begin
  if Apretado then
  begin
        {$IFDEF USARRATON}
    PUNTERO_OFF;
                  {$ENDIF}
    INSIGNIA_ON(xx1, yy1, texto1, xx2 - xx1, yy2 - yy1);
                  {$IFDEF USARRATON}
    PUNTERO_ON;
                  {$ENDIF}
  end
  else
  begin
                {$IFDEF USARRATON}
    PUNTERO_OFF;
                {$ENDIF}
    INSIGNIA(xx1, yy1, texto1, xx2 - xx1, yy2 - yy1);
                {$IFDEF USARRATON}
    PUNTERO_ON;
                {$ENDIF}
  end;
end;

procedure TCtrlBoton.ActuarOnMouse(MouseEvent: TMouseEvent);
begin
  case MouseEvent of
    BotonIzqAbajo:
    begin
      if not Apretado then
      begin
        Apretado := True;
        Paint;
      end;
    end;
    BotonIzqArriba:
    begin
      if Apretado then
      begin
        Apretado := False;
        xproc;{ Modifica la varible }
        Paint;
      end;
    end;
    Abandono:
    begin
      if Apretado then
      begin
        Apretado := False;
        Paint;
      end;
    end;
  end; {case}
end;

function TCtrlBoton.TocadoXY(x, y: integer): boolean;
begin
  if (x > xx1 - 4) and (y > yy1) and (x < xx2) and (y < yy2) then
    TocadoXY := True
  else
    TocadoXY := False;
end;


{
****************************************************************************
Mtodos de TCtrlBotonVar
***************************************
***************************************
}

constructor TCtrlBotonVar.Init(xrenglon: integer; xtexto1, xtexto2: string;
  xdeci: integer; xmin, xmax, xdef, xincr: NReal; var VariableControlada: NReal);
var
  auxtexto: string;
begin
  texto1 := xtexto1;
  texto2 := xtexto2;
  pvar := @VariableControlada;
  renglon := xrenglon;
  boton := 0;  {inicial}

  deci := xdeci;

  {fijar factor de unidades}
  {no se aceptan espacios en blanco para texto2}
  if texto2 = '' then
    texto2 := ' ';
  case texto2[1] of
    'M': factor := 1e+6;
    'k': factor := 1e+3;
    'K': factor := 1e+3;
    'm': factor := 1e-3;
    'u': factor := 1e-6;
    'n': factor := 1e-9;
    'p': factor := 1e-12;
    else
      factor := 1;
  end;

  min := xmin;
  max := xmax;
  def := xdef;
  incr := xincr;
  valor := def;
  pvar^ := valor * factor;


  desplazamiento := 96; {constante}

  xx1 := getmaxx - 640 + 502;
  yy1 := renglon * AltoRenglon + 74;
  xx2 := getmaxx - 640 + 502 + 22;
  yy2 := renglon * AltoRenglon + 74 + 15;
  apretado := False;

  {........dibuja el soporte y los botones de control.........}

  SetTextStyle(smallfont, 0, 2);
  SetFillStyle(1, 7);  {.fondo gris.}
  Bar(getmaxx - 640 + 497, RENGLON * AltoRenglon + 60,
    getmaxx - 640 + 623, RENGLON * AltoRenglon + 60 + 30);

  {.marco_todo.}
  MARCO_DESNIVEL(getmaxx - 640 + 495, RENGLON * AltoRenglon + 60 - 1,
    getmaxx - 640 + 624, RENGLON * AltoRenglon + 60 + 31, 15, 0);
  MARCO_DESNIVEL(getmaxx - 640 + 494, RENGLON * AltoRenglon + 60 - 2,
    getmaxx - 640 + 625, RENGLON * AltoRenglon + 60 + 32, 15, 0);
  MARCO_DESNIVEL(getmaxx - 640 + 493, RENGLON * AltoRenglon + 60 - 2,
    getmaxx - 640 + 625, RENGLON * AltoRenglon + 60 + 33, 15, 0);
  {.marco_display.}
  MARCO_DESNIVEL(getmaxx - 640 + 504 + 25, RENGLON * AltoRenglon + 60 + 16,
    getmaxx - 640 + 623 - 35, RENGLON * AltoRenglon + 60 + 30 - 3, 0, 15);
  {.marco_variable.}
  MARCO_DESNIVEL(getmaxx - 640 + 529, RENGLON * AltoRenglon + 60 + 2,
    getmaxx - 640 + 589, RENGLON * AltoRenglon + 60 + 13, 0, 15);

  SetFillStyle(1, 0); {.pinto display.}
  Bar(getmaxx - 640 + 530, RENGLON * AltoRenglon + 77,
    getmaxx - 640 + 589, RENGLON * AltoRenglon + 86);

  SetLineStyle(0, 0, 0);
  SetColor(1);            {.pinto valores min, def, max.}
  str(min: 4: 0, auxtexto);
  OutTextXY(getmaxx - 640 + 499, renglon * AltoRenglon + 60 + 1, auxtexto);

  str(max: 4: 0, auxtexto);
  OutTextXY(getmaxx - 640 + 595, renglon * AltoRenglon + 60 + 1, auxtexto);

  SetColor(10);
  str(def: 6: deci, auxtexto);
  OutTextXY(getmaxx - 640 + 533, renglon * AltoRenglon + 60 + 15, auxtexto);

  OutTextXY(getmaxx - 640 + 575, RENGLON * AltoRenglon + 60 + 15, TEXTO2);
  SetColor(0);
  OutTextXY(getmaxx - 640 + 533, RENGLON * AltoRenglon + 60 + 1, TEXTO1);

  INSIGNIA(xx1, yy1, '<<', xx2 - xx1, yy2 - yy1); {primer PAINT}
  INSIGNIA(xx1 + desplazamiento, yy1, '>>', xx2 - xx1, yy2 - yy1); {primer PAINT}
end;



procedure TCtrlBotonVar.WriteTxt(texto: string);
begin
  {a definir en los descendientes}
end;


procedure TCtrlBotonVar.Paint;
begin
  if Apretado then
  begin
                {$IFDEF USARRATON}
    PUNTERO_OFF;
        {$ENDIF}
    if boton = 0 then
      INSIGNIA_ON(xx1 + desplazamiento * boton, yy1, '<<', xx2 - xx1, yy2 - yy1)
    else
      INSIGNIA_ON(xx1 + desplazamiento * boton, yy1, '>>', xx2 - xx1, yy2 - yy1);
                    {$IFDEF USARRATON}
    PUNTERO_ON;
                  {$ENDIF}
  end
  else
  begin
                {$IFDEF USARRATON}
    PUNTERO_OFF;
                 {$ENDIF}
    if boton = 0 then
      INSIGNIA(xx1 + desplazamiento * boton, yy1, '<<', xx2 - xx1, yy2 - yy1)
    else
      INSIGNIA(xx1 + desplazamiento * boton, yy1, '>>', xx2 - xx1, yy2 - yy1);
                 {$IFDEF USARRATON}
    PUNTERO_ON;
                 {$ENDIF}
  end;
end;

procedure TCtrlBotonVar.ActuarOnMouse(MouseEvent: TMouseEvent);
begin
  case MouseEvent of
    BotonIzqAbajo:
    begin
      if not Apretado then
      begin
        Apretado := True;
        Paint;
      end;
    end;
    BotonIzqArriba:
    begin
      if Apretado then
      begin
        Apretado := False;
        case boton of
          0: decrementar;
          1: incrementar;
        end; {case}
        Paint;
      end;
    end;
    Abandono:
    begin
      if Apretado then
      begin
        Apretado := False;
        Paint;
      end;
    end;
  end; {case}
end;

function TCtrlBotonVar.TocadoXY(x, y: integer): boolean;
begin
  if (x > xx1 - 4) and (y > yy1) and (x < xx2) and (y < yy2) then
  begin
    TocadoXY := True;
    boton := 0;
  end
  else
  if (x > xx1 + desplazamiento - 4) and (y > yy1) and (x < xx2 + desplazamiento) and
    (y < yy2) then
  begin
    TocadoXY := True;
    boton := 1;
  end
  else
    TocadoXY := False;
end;


procedure TCtrlBotonVar.incrementar;
var
  auxtexto: string;
begin
  valor := valor + incr;
  if valor > max then
  begin
    Sound(200, 90);
    valor := max;
  end;

  SetTextStyle(smallfont, 0, 2);
  SetFillStyle(1, 0);
  Bar(getmaxx - 640 + 530, RENGLON * AltoRenglon + 77,
    getmaxx - 640 + 572, RENGLON * AltoRenglon + 86);
  SetColor(10);
  str(valor: 6: deci, auxtexto);
  OutTextXY(getmaxx - 640 + 533, renglon * AltoRenglon + 60 + 15, auxtexto);

  pvar^ := valor * factor;
end;

procedure TCtrlBotonVar.decrementar;
var
  auxtexto: string;
begin
  valor := valor - incr;
  if valor < min then
  begin
    Sound(100, 90);
    valor := min;
  end;

  SetTextStyle(smallfont, 0, 2);
  SetFillStyle(1, 0);
  Bar(getmaxx - 640 + 530, RENGLON * AltoRenglon + 77,
    getmaxx - 640 + 570, RENGLON * AltoRenglon + 86);

  SetColor(10);
  str(valor: 6: deci, auxtexto);
  OutTextXY(getmaxx - 640 + 533, renglon * AltoRenglon + 60 + 15, auxtexto);

  pvar^ := valor * factor;
end;


{
****************************************************************************
Mtodos de TCtrlBotonVar2
***************************************
***************************************
}

constructor TCtrlBotonVar2.Init(xrenglon: integer; xtexto1, xtexto2: string;
  xdeci: integer; var xmin, xmax: NReal; xdef, xincr: NReal;
  var VariableControlada: NReal);

begin
  pmin := @xmin;
  pmax := @xmax;
  TCtrlBotonVar.Init(
    xrenglon,
    xtexto1,
    xtexto2,
    xdeci,
    pmin^,
    pmax^,
    xdef,
    xincr,
    VariableControlada);
end;


procedure TCtrlBotonVar2.incrementar;
var
  auxtexto: string;
begin

  if pmin^ <> min then
  begin
    min := pmin^;
                {$IFDEF USARRATON}
    puntero_off;
                {$ENDIF}
    SetFillStyle(1, 7); {.pinto display.}
    Bar(getmaxx - 640 + 499, RENGLON * AltoRenglon + 60 + 1,
      getmaxx - 640 + 528, RENGLON * AltoRenglon + 73);

    SetLineStyle(0, 0, 0);
    SetColor(1);            {.pinto valores min, def, max.}
    str(min: 4: 0, auxtexto);
    OutTextXY(getmaxx - 640 + 499, renglon * AltoRenglon + 60 + 1, auxtexto);
                {$IFDEF USARRATON}
    puntero_on;
                {$ENDIF}
  end;

  if pmax^ <> max then
  begin
    max := pmax^;
                {$IFDEF USARRATON}
    puntero_off;
                {$ENDIF}
    SetFillStyle(1, 7); {.pinto display.}
    Bar(getmaxx - 640 + 595, RENGLON * AltoRenglon + 60 + 1,
      getmaxx - 640 + 621, RENGLON * AltoRenglon + 73);

    SetLineStyle(0, 0, 0);
    SetColor(1);            {.pinto valores min, def, max.}
    str(max: 4: 0, auxtexto);
    OutTextXY(getmaxx - 640 + 595, renglon * AltoRenglon + 60 + 1, auxtexto);
                {$IFDEF USARRATON}
    puntero_on;
                {$ENDIF}
  end;

  valor := pvar^ / factor;
  valor := valor + incr;

  if valor > max then
  begin
    Sound(200, 90);
    valor := max;
  end;

  SetTextStyle(smallfont, 0, 2);
  SetFillStyle(1, 0);
  Bar(getmaxx - 640 + 530, RENGLON * AltoRenglon + 77,
    getmaxx - 640 + 572, RENGLON * AltoRenglon + 86);
  SetColor(10);
  str(valor: 6: deci, auxtexto);
  OutTextXY(getmaxx - 640 + 533, renglon * AltoRenglon + 60 + 15, auxtexto);
  OutTextXY(getmaxx - 640 + 575, RENGLON * AltoRenglon + 60 + 15, TEXTO2);

  pvar^ := valor * factor;
end;

procedure TCtrlBotonVar2.decrementar;
var
  auxtexto: string;
begin

  if pmin^ <> min then
  begin
    min := pmin^;
                {$IFDEF USARRATON}
    puntero_off;
                {$ENDIF}
    SetFillStyle(1, 7); {.pinto display.}
    Bar(getmaxx - 640 + 499, RENGLON * AltoRenglon + 60 + 1,
      getmaxx - 640 + 528, RENGLON * AltoRenglon + 73);

    SetLineStyle(0, 0, 0);
    SetColor(1);            {.pinto valores min, def, max.}
    str(min: 4: 0, auxtexto);
    OutTextXY(getmaxx - 640 + 499, renglon * AltoRenglon + 60 + 1, auxtexto);
                {$IFDEF USARRATON}
    puntero_on;
                {$ENDIF}
  end;

  if pmax^ <> max then
  begin
    max := pmax^;
                {$IFDEF USARRATON}
    puntero_off;
                {$ENDIF}
    SetFillStyle(1, 7); {.pinto display.}
    Bar(getmaxx - 640 + 595, RENGLON * AltoRenglon + 60 + 1,
      getmaxx - 640 + 621, RENGLON * AltoRenglon + 73);

    SetLineStyle(0, 0, 0);
    SetColor(1);            {.pinto valores min, def, max.}
    str(max: 4: 0, auxtexto);
    OutTextXY(getmaxx - 640 + 595, renglon * AltoRenglon + 60 + 1, auxtexto);
                {$IFDEF USARRATON}
    puntero_on;
                {$ENDIF}
  end;

  valor := pvar^ / factor;
  valor := valor - incr;

  if valor < min then
  begin
    Sound(100, 90);
    valor := min;
  end;

  SetTextStyle(smallfont, 0, 2);
  SetFillStyle(1, 0);
  Bar(getmaxx - 640 + 530, RENGLON * AltoRenglon + 77,
    getmaxx - 640 + 570, RENGLON * AltoRenglon + 86);

  SetColor(10);
  str(valor: 6: deci, auxtexto);
  OutTextXY(getmaxx - 640 + 533, renglon * AltoRenglon + 60 + 15, auxtexto);
  OutTextXY(getmaxx - 640 + 575, RENGLON * AltoRenglon + 60 + 15, TEXTO2);

  pvar^ := valor * factor;
end;

procedure TCtrlBotonVar2.ActuarOnKey(Letra: char);
var
  auxtexto: string;
begin

  if pmin^ <> min then
  begin
    min := pmin^;
                {$IFDEF USARRATON}
    puntero_off;
                {$ENDIF}
    SetFillStyle(1, 7); {.pinto display.}
    Bar(getmaxx - 640 + 499, RENGLON * AltoRenglon + 60 + 1,
      getmaxx - 640 + 528, RENGLON * AltoRenglon + 73);

    SetLineStyle(0, 0, 0);
    SetColor(1);            {.pinto valores min, def, max.}
    str(min: 4: 0, auxtexto);
    OutTextXY(getmaxx - 640 + 499, renglon * AltoRenglon + 60 + 1, auxtexto);
                {$IFDEF USARRATON}
    puntero_on;
                {$ENDIF}
  end;

  if pmax^ <> max then
  begin
    max := pmax^;
                {$IFDEF USARRATON}
    puntero_off;
                {$ENDIF}
    SetFillStyle(1, 7); {.pinto display.}
    Bar(getmaxx - 640 + 595, RENGLON * AltoRenglon + 60 + 1,
      getmaxx - 640 + 621, RENGLON * AltoRenglon + 73);

    SetLineStyle(0, 0, 0);
    SetColor(1);            {.pinto valores min, def, max.}
    str(max: 4: 0, auxtexto);
    OutTextXY(getmaxx - 640 + 595, renglon * AltoRenglon + 60 + 1, auxtexto);
                {$IFDEF USARRATON}
    puntero_on;
                {$ENDIF}
  end;

  if (valor * factor) <> pvar^ then
  begin
    valor := pvar^ / factor;
    SetTextStyle(smallfont, 0, 2);
    SetFillStyle(1, 0);
    Bar(getmaxx - 640 + 530, RENGLON * AltoRenglon + 77,
      getmaxx - 640 + 572, RENGLON * AltoRenglon + 86);
    SetColor(7);
    str(valor: 6: deci, auxtexto);
    OutTextXY(getmaxx - 640 + 533, renglon * AltoRenglon + 60 + 15, auxtexto);
    OutTextXY(getmaxx - 640 + 575, RENGLON * AltoRenglon + 60 + 15, TEXTO2);
  end;
end;


(******************************************************)
(*    PcrtlBotonProc                                  *)
(******************************************************)

constructor TCtrlBotonProc.Init(xrenglon: integer; xtexto1: string; nxproc: ExtProc);
var
  auxtexto: string;
begin
  texto1 := xtexto1;
  renglon := xrenglon;

  TCtrlBoton.init(getmaxx - 640 + 497, RENGLON * AltoRenglon + 60,
    getmaxx - 640 + 623, RENGLON * AltoRenglon + 60 + 30, xtexto1, nxproc);
end;


{ Mtodos de TControles }


constructor TControles.Init;
begin
  lista := TList.Create;
end;

procedure TControles.ActuarOnKey(letra: char);

  procedure ActuarControl(p: Pointer); far;
  begin
    TCtrl(p^).ActuarOnKey(letra);
  end;

var
  i: integer;
begin
  for I := 0 to Lista.Count - 1 do
    ActuarControl(lista.Items[i]);
end;

function TControles.PTocadoXY(x, y: integer): PCtrl;
var
  buscando: boolean;
  k: integer;
begin
  buscando := True;
  k := 0;
  while buscando and (k < lista.Count) do
  begin
    if PCtrl(lista.items[k])^.TocadoXY(x, y) then
      buscando := False
    else
      Inc(k);
  end;

  if not buscando then
    PTocadoXY := lista.items[k]
  else
    PTocadoXY := nil;
end;


procedure TControles.ActuarOnMouse(x, y: integer; Evento: TMouseEvent);
begin
  if PActivo = nil then
  begin
    PActivo := PTocadoXY(X, Y);
    if PActivo <> nil then
    begin
      PActivo^.ActuarOnMouse(Arrivo);
      PActivo^.ActuarOnMouse(Evento);
    end;
  end
  else
  if not PActivo^.TocadoXY(x, y) then
  begin
    PActivo^.ActuarOnMouse(Abandono);
    PActivo := PTocadoXY(X, Y);
    if PActivo <> nil then
    begin
      PActivo^.ActuarOnMouse(Arrivo);
      PActivo^.ActuarOnMouse(Evento);
    end;
  end
  else
    PActivo^.ActuarOnMouse(Evento);
end;


procedure WriteCartel;
var
  vp: ViewPortType;
  t: TextSettingsType;
  x1, x2, y1, y2: integer;
  OldColor: word;
  texto: string;
begin

  GetTextSettings(t);
  SetTextStyle(SmallFont, HorizDir, 2);
  SetTextJustify(LeftText, BottomText);
  texto := '(c)IIE-FING';
  x1 := GetMaxX - TextWidth(texto) - 44; // 22+GetMaxY+TextWidth('M')*3;
  x2 := x1 + TextWidth(texto);
  y1 := GetMaxY - TextHeight('H') - 33; //GetMaxY- 470;
  y2 := y1 - TextHeight('H');

  GetViewSettings(vp);
  SetViewPort(x1, y2, x2, y1, True);
  ClearViewPort;
  with vp do
    SetViewPort(x1, y1, x2, y2, Clip);

  OldColor := GetColor;
  SetColor(ColorTexto);
  OutTextXY(x1, y1, texto);
  SetColor(OldColor);

  SetTextStyle(t.font, t.Direction, t.CharSize);
  SetTextJustify(t.Horiz, t.Vert);
end;




procedure TControles.Pintar;

  procedure PintarCntrl(p: Pointer);
  begin
    TCtrl(p^).Pintar;
  end;

var
  OldColor: word;
  i: integer;
begin
  for I := 0 to Lista.Count - 1 do
    PintarCntrl(lista.Items[i]);
  OldColor := GetColor;
{  SetColor( Rojo );
  rectangle( GetMaxY+10, 1, GetMaxX-1, GetMaxY-1);
  rectangle( GetMaxY+8, 1, GetMaxX-1, GetMaxY-1);
  rectangle( GetMaxY+6, 1, GetMaxX-1, GetMaxY-1);}
  WriteCartel;
  SetColor(OldColor);
end;



constructor TCtrlTexto.Init(xrenglon: integer; xtexto1: string);
begin
  TCtrl.Init('l', xrenglon, xtexto1, '', 0);
end;


procedure TCtrlTexto.WriteTxt(texto: string);
var
  vp: ViewPortType;
  t: TextSettingsType;
  x1, x2, y1, y2: integer;
  OldColor: word;
begin

  GetTextSettings(t);
  SetTextStyle(t.font, HorizDir, t.CharSize);
  SetTextJustify(LeftText, BottomText);

  x1 := GetMaxY + TextWidth('M') * 3;
  x2 := x1 + TextWidth(texto);
  y1 := trunc((renglon * interlineado) * TextHeight('H'));
  y2 := y1 - TextHeight('H');

  GetViewSettings(vp);
  SetViewPort(x1, y2, x2, y1, True);
  ClearViewPort;
  with vp do
    SetViewPort(x1, y1, x2, y2, Clip);

  OldColor := GetColor;
  SetColor(ColorTexto);
  OutTextXY(x1, y1, texto);
  SetColor(OldColor);

  SetTextStyle(t.font, t.Direction, t.CharSize);
  SetTextJustify(t.Horiz, t.Vert);
end;



constructor TCtrlBoolean.Init(xLetra: char; xrenglon: integer;
  xtexto1: string; var xvar: boolean);
begin
  TCtrl.Init(xLetra, xRenglon, xTexto1, '', 0);
  pvar := @xvar;
end;

procedure TCtrlBoolean.Pintar;
var
  s: string;
begin
  if pvar^ then
    s := texto1 + ' SI'
  else
    s := texto1 + ' NO';
  WriteTXT(s);
end;


procedure TCtrlBoolean.Incrementar;
begin
  pvar^ := True;
  pintar;
end;

procedure TCtrlBoolean.Decrementar;
begin
  pvar^ := False;
  pintar;
end;



constructor TCtrlToggle.Init(xLetra: char; xrenglon: integer;
  xtexto1: string; var xvar: boolean);
begin
  TCtrlBoolean.Init(xLetra, xRenglon, xTexto1, xvar);
end;


procedure TCtrlToggle.Incrementar;
begin
  Decrementar;
end;

procedure TCtrlToggle.Decrementar;
begin
  pvar^ := not pvar^;
  pintar;
end;




constructor TCtrlProcedure.Init(xLetra: char; xrenglon: integer;
  xtexto1: string; xproc: ExtProc);
begin
  TCtrl.Init(xLetra, xRenglon, xTexto1, '', 0);
  proc := xproc;
end;

procedure TCtrlProcedure.Pintar;
begin
  WriteTXT(texto1);
end;


procedure TCtrlProcedure.Incrementar;
begin
  proc;
end;

procedure TCtrlProcedure.Decrementar;
begin
  proc;
end;




constructor TDsplyNReal.Init(xrenglon: integer; xtexto1: string;
  xtexto2: string; xCampo, xDecimales: integer; var VariableControlada: NReal);
begin
  TCtrl.init('l', xrenglon, xtexto1, xtexto2, xCampo);
  decimales := xdecimales;
  pvar := @VariableControlada;
  defval := pvar^;
end;


procedure TDsplyNReal.ActuarOnKey(Letra: char);
begin
  if defval <> pvar^ then
  begin
    defval := pvar^;
    pintar;
  end;
end;




constructor TDsplyNEntero.Init(xrenglon: integer; xtexto1: string;
  xtexto2: string; xCampo: integer; var VariableControlada: NEntero);
begin
  TCtrl.init('l', xrenglon, xtexto1, xtexto2, xCampo);
  pvar := @VariableControlada;
  defval := pvar^;
end;


procedure TDsplyNEntero.ActuarOnKey(Letra: char);
begin
  if defval <> pvar^ then
  begin
    defval := pvar^;
    pintar;
  end;
end;


procedure TDsplyNEntero.WriteTxt(texto: string);
var
  vp: ViewPortType;
  t: TextSettingsType;
  x1, x2, y1, y2: integer;
  OldColor: word;
begin
  Texto := texto;
  GetTextSettings(t);
  SetTextStyle(t.font, HorizDir, t.CharSize);
  SetTextJustify(LeftText, BottomText);

  x1 := GetMaxY + TextWidth('M') * 3;
  x2 := x1 + TextWidth(texto);
  y1 := trunc((renglon * interlineado) * TextHeight('H'));
  y2 := y1 - TextHeight('H');

  GetViewSettings(vp);
  SetViewPort(x1, y2, x2, y1, True);
  ClearViewPort;
  with vp do
    SetViewPort(x1, y1, x2, y2, Clip);
  OldColor := GetColor;
  SetColor(ColorTexto);
  OutTextXY(x1, y1, texto);
  SetColor(OldColor);
  SetTextStyle(t.font, t.Direction, t.CharSize);
  SetTextJustify(t.Horiz, t.Vert);
end;

procedure TDsplyNReal.WriteTxt(texto: string);
var
  vp: ViewPortType;
  t: TextSettingsType;
  x1, x2, y1, y2: integer;
  OldColor: word;
begin
  Texto := texto;
  GetTextSettings(t);
  SetTextStyle(t.font, HorizDir, t.CharSize);
  SetTextJustify(LeftText, BottomText);

  x1 := GetMaxY + TextWidth('M') * 3;
  x2 := x1 + TextWidth(texto);
  y1 := trunc((renglon * interlineado) * TextHeight('H'));
  y2 := y1 - TextHeight('H');

  GetViewSettings(vp);
  SetViewPort(x1, y2, x2, y1, True);
  ClearViewPort;
  with vp do
    SetViewPort(x1, y1, x2, y2, Clip);
  OldColor := GetColor;
  SetColor(ColorTexto);
  OutTextXY(x1, y1, texto);
  SetColor(OldColor);
  SetTextStyle(t.font, t.Direction, t.CharSize);
  SetTextJustify(t.Horiz, t.Vert);
end;

begin
  xx := 100;
  yy := 100;
  izquierda := False;
  centro := False;
  derecha := False;
end.
