unit variable;
interface
uses
	xMatDefs, CYTipos;

var

(************************************************)
(* Parmetros que hay que especificar en INICIO *)
(************************************************)

	tinicial,   { inicio de la simulacin }
	tfinal:NReal; { Fin de la simulacin }
	dtmax0:NReal; { Mximo paso de tiempo. }

	PasoDivisor,  { Divisor del paso de tiempo crtico (6 es un buen valor)}
	TmaxTmin:NReal; { Relacin entre los pasos de tiempos. Un valor de 1000
						indica que las conmutaciones se afinarn con un paso de
						tiempo 1000 veces menor que el paso de simulacin. }

              	
(**********************)
(* Variables globales *)
(**********************)


{ Matriz general del sistema de ecuaciones }
	m:TMatSistema;

{ Arboles de ecuaciones de nudo mostrando los cortes }
	arbv: TVectVoltIdx;

{ Estados lgicos }
	dx, dx0: TVectEstLog;

{ Estados reales }
	x, x0: TVectEstReal;

{ Indice de direccionamiento del vector de estados reales. Este ndice
permite acceder a las variables de estado. El orden original puede
alterarse en caso de que las variables de estado originales sean redun-
dantes}
	indx: TVectEstRealIdx;

{ Vector de tensiones. v[0] es la tierra }
	v: TVectVolt;

{ Indica cuando se recorre Cirt2 si se est formando el sistema
de ecuaciones o recorriendo los componentes para chequear su estado lgico } 
	chek:boolean;


	t,   { tiempo actual de simulacin }
	t_siguiente, { tiempo siguiente }
	dt, { paso de tiempo actual }
	dtmin, { mnimo valor del paso de tiempo determinado automticamente }
	dtmax { mximo valor del paso de tiempo determinado automticamente }
   :NReal;
 
	rf: TVectIndeps;

	n,
	nm,
	nn,
	nx,
	ndiodos
	:integer;

	nve,
	nvecirt1,
	nd,
	nindep:integer;

	redundancia:word;

implementation

begin
	t:=0;   { tiempo actual de simulacin }
	t_siguiente:=0; { tiempo siguiente }
	dt:=1; { paso de tiempo actual }
	dtmin:=1; { mnimo valor del paso de tiempo determinado automticamente }
	dtmax:=1; { mximo valor del paso de tiempo determinado automticamente }

 
end. (* fin de la unidad de variables *)
