unit hvdc;


interface

uses xMatDefs, variable,ERRORES, CYTIPOS,lib_basi;
const
	w50 = 314.1592654;

procedure Trafo3F_YDY_LRccS(
	p0, p1, p2, p3: integer;
	s1, s2, s3: integer;
        t0, t1, t2, t3: integer;
	nrs: NReal;
        nrt: NReal;
        LccS, RccS: NReal);



implementation

procedure Trafo3F_YDY_LRccS(
	p0, p1, p2, p3: integer;
	s1, s2, s3: integer;
        t0, t1, t2, t3: integer;
	nrs: NReal;
        nrt: NReal;

	LccS, RccS: NReal);
var
	LccSD,LccTY,RccTY,RccSD: NReal;
	nryd: NReal;

begin
	{ Parmetros del tringulo }
	LccSD:= LccS*3; RccSD:= RccS*3;
        LccTY:=LccS*(nrs/nrt)*(nrs/nrt);
        RccTY:=RccS*(nrs/nrt)*(nrs/nrt);
	nryd:= nrs*sqrt(3.0);

	{ Colocacin de los trafos en D }
	TrafoLRccS(	P1, P0, S1, S2, nryd, LccSD, RccSD );
	TrafoLRccS(	P2, P0, S2, S3, nryd, LccSD, RccSD );
	TrafoLRccS(	P3, P0, S3, S1, nryd, LccSD, RccSD );

        { Colocacin de los trafos en Y }
	TrafoLRccS(	P1, P0, T1, T0, nrt, LccTY, RccTY );
	TrafoLRccS(	P2, P0, T2, T0, nrt, LccTY, RccTY );
	TrafoLRccS(	P3, P0, T3, T0, nrt, LccTY, RccTY );

end;
end.