unit lib_basi;


interface

uses xMatDefs, variable,ERRORES, CYTIPOS;
const
	w50 = 314.1592654;

procedure y(k,j:integer;y:NReal);
procedure c(k,j:integer;c:NReal);
procedure crd(k,j:integer;c, rd:NReal);
procedure l(k,j:integer;l:NReal);
procedure Lrd(k,j: integer; L, rd: NReal);

procedure rvg(k,j:integer;res,vgen:NReal);
procedure ig(col,k,j:integer;ig:NReal);
procedure iv(a,b,k,j:integer;y:NReal); (* I(a->b)= y*(j-k) *)
procedure vg(col,k,j:integer;vg:NReal);
procedure TI(k,j,kp,jp:integer;n:NReal);
procedure r(k,j:integer;r:NReal);
procedure vv(k,j,kp,jp:integer;a:NReal); { Vk-Vj = a( Vkp-Vjp ) }
procedure th(a,k:integer;g:boolean);
procedure llave(k,j:integer;t0,ton,periodo:NReal);
function cuadrada(t,periodo,ainf,asup:NReal):NReal;

function pulsob(t:NReal):boolean;
function prb(retardo,periodo,t:NReal):boolean;

procedure TrafoLRccS(
	P1, P2, S1, S2: integer;
	nr: NReal;
	LccS, RccS: NReal );

procedure Trafo3F_DD_LRccS(
	p1, p2, p3: integer;
	s1, s2, s3: integer;
	nr: NReal;
	LccS, RccS: NReal);

procedure Trafo3F_YD_LRccS(
	p0, p1, p2, p3: integer;
		 s1, s2, s3: integer;
	nr: NReal;
	LccS, RccS: NReal);

implementation

procedure pon(k,j:integer;val:NReal);
begin
if (k<>0)and(j<>0) then
   begin
   if arbv[k]<>-1 then pon(arbv[k],j,val)
      else if k<>0 then m[k,j]:=m[k,j]+val
   end
end;




procedure y(k,j:integer;y:NReal);
begin
pon(k,k,y);
pon(k,j,-y);
pon(j,k,-y);
pon(j,j,y)
end;




procedure c(k,j:integer;c:NReal);
var p:integer;
begin
nve:=nve+1;
p:=nn+nve;
pon(k,p,c);
pon(j,p,-c);
if k <>0 then m[p,k]:=1;
if j<>0 then m[p,j]:=-1;
m[p,p+nx]:=1
end;



procedure crd(k,j:integer;c, rd:NReal);
var p:integer;
begin
nve:=nve+1;
p:=nn+nve;
pon(k,p,c);
pon(j,p,-c);
if k <>0 then m[p,k]:=1;
if j<>0 then m[p,j]:=-1;
m[p,p]:=-rd*C;
m[p,p+nx]:=1
end;

procedure L(k,j:integer;L:NReal);
var p:integer;
begin
nve:=nve+1;
p:=nn+nve;
pon(k,p+nx,-1);
pon(j,p+nx,1);
if k<>0 then m[p,k]:=-1;
if j<>0 then m[p,j]:=1;
m[p,p]:=L
end;

procedure LRd(k,j: integer; L, Rd: NReal);
var p:integer;
begin
nve:=nve+1;
p:=nn+nve;
pon(k,p+nx,-1);
pon(j,p+nx,1);
if k<>0 then m[p,k]:=-1;
if j<>0 then m[p,j]:=1;
m[p,p]:=l;
m[p,p+nx]:=-Rd;
end;


{ 14.2.1995 rch@UTE }
procedure TrafoLRccS(
	P1, P2, S1, S2: integer;
	nr: NReal;
	LccS, RccS: NReal );
var
	p: integer;
begin
	{ Notificacion de la aparicion de una variable de estado }
	nve:= nve+1;

	{ (p) es la columna de IL }
	p:= nn+nve+nx;

	pon(P1, p, nr);
	pon(P2, p, -nr);
	pon(S1, p, -1);
	pon(S2, p, 1);

	{ (p) es la ecuacion de la variable de estado y la columna
	de d(IL)/dt }
	p:= nn+nve;
	m[p, P1]:= nr;
	m[p, P2]:= -nr;
	m[p, S1]:= -1;
	m[p, S2]:= 1;
	m[p, p]:= LccS;
	m[p, p+nx]:=-RccS;
end;

procedure Trafo3F_DD_LRccS(
	p1, p2, p3: integer;
	s1, s2, s3: integer;
	nr: NReal;
	LccS, RccS: NReal);
var
	LccSD, RccSD: NReal;

begin
	{ Parmetros del tringulo }
	LccSD:= LccS*3; RccSD:= RccS*3;

	{ Colocacin de los trafos en DD }
	TrafoLRccS(	P1, P2, S1, S2, nr, LccSD, RccSD );
	TrafoLRccS(	P2, P3, S2, S3, nr, LccSD, RccSD );
	TrafoLRccS(	P3, P1, S3, S1, nr, LccSD, RccSD );
end;


procedure Trafo3F_YD_LRccS(
	p0, p1, p2, p3: integer;
		 s1, s2, s3: integer;
	nr: NReal;
	LccS, RccS: NReal);
var
	LccSD, RccSD: NReal;
	nryd: NReal;

begin
	{ Parmetros del tringulo }
	LccSD:= LccS*3; RccSD:= RccS*3;
	nryd:= nr*sqrt(3.0);

	{ Colocacin de los trafos en DD }
	TrafoLRccS(	P1, P0, S1, S2, nryd, LccSD, RccSD );
	TrafoLRccS(	P2, P0, S2, S3, nryd, LccSD, RccSD );
	TrafoLRccS(	P3, P0, S3, S1, nryd, LccSD, RccSD );
end;




procedure rvg(k,j:integer;res,vgen:NReal);
begin
r(k,j,res);
ig(0,k,j,vgen/res);
end;(* rvg *)



procedure ig(col,k,j:integer;ig:NReal);
begin
pon(k,n+nx+col+1,-ig);
pon(j,n+nx+col+1,ig)
end;


procedure iv(a,b,k,j:integer;y:NReal);
begin
pon(a,j,y);
pon(a,k,-y);
pon(b,k,y);
pon(b,j,-y)
end;


procedure borre(var x: TVectFila);
var k:integer;
begin
for k:=1 to nm do x[k]:=0
end;


procedure vg(col,k,j:integer;vg:NReal);

procedure forsum(x,y:integer);
var p:integer;

procedure pase(y,x:integer);
begin
     arbv[y]:=x;
     borre(m[y]);
     if j<>0 then m[y,j]:=1;
     if k<>0 then m[y,k]:=-1;
     m[y,n+nx+col+1]:=vg;
end;{pase}

begin
if arbv[x]<>-1 then forsum(arbv[x],y)
else if arbv[y]<>-1 then forsum(x,arbv[y])
else if x=y then Error(1)
else if x=0 then pase(y,x)
else if y=0 then pase(x,y)
else
    begin
    for p:=1 to nm do
    m[x,p]:=m[x,p]+m[y,p];
    pase(y,x)
    end

end;{forsum}

begin
     forsum(k,j)
end;{vg}




procedure SumFil(k:integer;var x: TVectFila;fac:NReal);

(* ec(k) := ec(k) + fac * x *)

var
 p:integer;

begin

  if k<>0 then
               if arbv[k]<>-1 then SumFil(arbv[k],x,fac)
                  else
                   for p:= 1 to nm do
                             m[k,p]:=m[k,p]+fac*x[p];

end; (* SumFil *)




procedure TI(k,j,kp,jp:integer;n:NReal);

(* Tranformador Ideal              *)
(*                                 *)
(* (kp-jp) = n * (k-j)             *)
(* ig(k,j, (- i de kp a jp ) * n   *)

begin

 if (arbv[kp]=-1) and (kp<>0) then
                            begin
                             SumFil(k,m[kp],(*1/*)n);
                             SumFil(j,m[kp],-(*1/*)n)
                            end
        else
         if (arbv[jp]=-1) and (jp<>0) then
                    begin
                       SumFil(k,m[jp],-(*1/*)n);
                       SumFil(j,m[jp],(*1/*)n)
                    end
          else writeln('error poniendo TI');


vv(kp,jp,k,j,n);

end; (* TranfIdeal *)




(*********************************************************)




procedure r(k,j:integer;r:NReal);
begin
if r <> 0 then y(k,j,1/r)
     else  vg(0,k,j,0)
end;



procedure vv(k,j,kp,jp:integer;a:NReal);

 var p:integer;


   procedure eq(x,y:integer);
    begin
     arbv[x]:=y;
     if k<>0 then m[x,k]:=1;
     if j<>0 then m[x,j]:=-1;
     if kp<>0 then m[x,kp]:=-a;
     if jp<>0 then m[x,jp]:=a;
    end;(* eq *)

  procedure forsum(x,y:integer);
   var p:integer;
     begin
       if arbv[x]<>-1 then forsum(arbv[x],y)
        else if arbv[y]<>-1 then forsum(x,arbv[y])
           else if x=y then writeln('este es un caso a estudiar')
              else if x=0 then eq(y,x)
                   else if y=0 then eq(x,y)
                        else
                          begin
                            for p:=1 to nm do
                                m[x,p]:=m[x,p]+m[y,p];
                            eq(y,x)
                          end;
     end; (* forsum *)

begin
forsum(k,j)
end;  (* vv *)


(**************************************************************)

procedure th(a,k:integer;g:boolean);

const
     vgama=1;
     rd=0.1;
     ri=10000;

var
	 dr:NReal;

begin
     nd:=nd+1;
     if chek then begin
                  if ( v[a]>v[k]+vgama) and g then dx[nd]:=true;
                  if v[a]<v[k]+vgama then dx[nd]:=false
                   end

else
begin
if dx[nd] then dr:=rd
          else dr:=ri;

r(a,k,dr);
ig(0,k,a,vgama/dr);
end;
end;




function pulsob(t:NReal):boolean;
begin
     if (t < 2*dtmax)and(0<t) then pulsob:=true
                    else pulsob:=false
end;


function prb(retardo,periodo,t:NReal):boolean;
var rt:NReal;
begin
rt:=t-retardo;
prb:=pulsob(rt-periodo*int(rt/periodo))
end;





procedure llave(k,j:integer;t0,ton,periodo:NReal);
var temp:NReal;
begin
nd:=nd+1;
if chek then
	begin
	temp:=(t_siguiente-t0)-trunc((t_siguiente-t0)/periodo)*periodo;
	if  (0<temp)and(temp<ton) then
		dx[nd]:= true
	else
		dx[nd]:=false
	end
else
if dx[nd] then
	vg(0,k,j,0)
else
	(*y(k,j,0) *)

end; (* llave *)

function cuadrada(t,periodo,ainf,asup:NReal):NReal;
(*flanco de subida en t=0*)
(*la salida vale ainf periodo/2 y asup en la otra mitad*)
begin
	if (t-trunc(t/periodo)*periodo)>(periodo/ 2) then cuadrada:=asup
	else cuadrada:=ainf
end; (* cuadrada *)

begin
end.(* fin de la libreria basica *)