unit libDig01;



interface

uses xMatDefs, variable, Lib_basi;

{ Flip-Flop RS por flancos. }
function FF_RS( R, S: boolean): boolean;
function rampa(t,periodo,cte:NReal):NReal;
function triangular(d:NReal):NReal;
function pulsoC(t,t0,ton,periodo,ainf,asup:NReal):NReal;


implementation

function FF_RS( R, S: boolean): boolean;
begin
	nd:=nd+1;
	if chek then
	begin
		if (not dx[nd]) and S then dx[nd]:= true
		else if dx[nd] and R then dx[nd]:= false
	end;
	FF_RS:= dx[nd];
end;

function rampa(t,periodo,cte:NReal):NReal;
var
	alfa:NReal;
begin
	alfa:= frac(t/periodo);
	rampa:= cte*alfa;
end;

function triangular(d:NReal):NReal;

begin
	d:= frac(d);
	if d < 1/4 then triangular:= d * 4
	else if d < 1/2 then triangular:= triangular(0.5-d)
	else if d < 3/4 then triangular:= -triangular(d-0.5)
	else triangular:= -triangular(1-d)
	 
end;

function pulsoC(t,t0,ton,periodo,ainf,asup:NReal):NReal;
(*flanco de subida en t=0*)
(*la salida vale ainf periodo/2 y asup en la otra mitad*)
begin
	if (t<t0) then pulsoC:=ainf
	else
		begin
	if (t-t0-trunc((t-t0)/periodo)*periodo)<(ton) then pulsoC:=asup
	else pulsoC:=ainf
		end
end; 


end.
