unit uExcelFile;

interface
uses
	Graphics, SysUtils, variants;

type
	TExcelFile= class
		v: variant; // el workbook
		ha: variant; // hoja activa;
		r: variant; // rango activo;

		fila, columna: integer; // puntero en la hoja activa
		autocierre: boolean;
		avisoCierre: boolean;

		constructor Create( nombreHoja1: string; visible: boolean; autocierre, avisocierre: boolean );

//		constructor CreateLoad( nombre: string; visible: boolean );
		procedure Guardar( nombre: string );
		procedure Abrir (nombArchivo: string );
		procedure agregoHoja( nombreHoja: string );
		function Hoja( nombreHoja: string ): Variant;
		procedure EscribirCelda(nombreHoja:string; fila:integer; columna:integer; contenido:variant);
		procedure EscribirCeldaTexto(nombreHoja:string; fila:integer; columna:integer; contenido:string);
		function ContenidoCelda(nombreHoja:string; var fila:integer; columna:integer; incrementa:boolean): variant;
		procedure Cerrar( conAviso: boolean );
		procedure Free;
		procedure VisibleOn;
		procedure VisibleOff;

// agregado por comodidad.
		procedure ActivoHoja( nombreHoja: string );
		procedure ir( fila, columna : integer );
		procedure irr( dfila, dcolumna: integer);

		function ReadV: variant;
		procedure readln;

(* estas dos son redundantes pero las agrego por comodidad *)
    procedure Write( contenido: variant );
    procedure go( NombreHoja: string; fila, columna: integer );
(*.............................................................*)

		procedure WriteV( contenido: variant );
		procedure WriteF( contenido: variant; formato: string );
		procedure WriteMAF( contenido: variant; celdas: integer; alineacion: integer; formato: string );
		procedure writeln( contenido: variant ); overload; // fila:=fila+1; columna:= 1
    procedure writeln; overload;

		function ref( fila, columna:integer ): string;
		function ref_rango( f1,c1, f2,c2: integer): string;

		procedure SelRango( fil1, col1, fil2,col2: integer);
		procedure BordeSimple(ancho: integer;
                           Arriba, Derecha, Abajo, Izquierda,
                           InteriorVertical, InteriorHorizontal: boolean);

		procedure CambiarFuente( nuevafuente: string);
		procedure CambiarTamFuente( nuevotam: integer);

// cambio de color usando ColorIndex
		procedure CambiarColorFuente_ci( nuevoci: integer );
		procedure CambiarColorFondo_ci( nuevoci: integer );

// cambio de color usuando un TColor
		procedure CambiarColorFuente_cl( nuevoCol: TColor );
		procedure CambiarColorFondo_cl( nuevoCol: TColor );

		procedure CambiarFormato( nuevoFormato: string );
		procedure CambiarAncho( nuevoAncho: integer);
		procedure CambiarAlto( nuevoAlto: integer );
		procedure CambiarFormula( nuevaFormula: string );
		procedure CombinarCeldas;

		procedure AlinearDerecha;
		procedure AlinearIzquierda;
		procedure AlinearCentro;
		procedure WrapTextON;
		procedure WrapTextOFF;
		procedure BoldON;
		procedure BoldOFF;
		procedure InsertarImagen( archi: string; x, y: integer );
      procedure Zoom( porciento: integer );

// acomada para imprimir
      procedure SetPage(  PaginaVertical: boolean );

  end;

const
	ciCanela  = 40;
//	ciAmarilloClaro =36;
	ciVerdeClaro= 35;
	ciTurquesaClaro= 34;
	ciAzulPalido= 37;
	ciLavanda= 39;
	ciAnil= 55;
	ciBlanco= 2;


const
	alDerecha= 1;
	alIzquierda=2;
	alCentro= 3;
	alNada= 0;


function rgb( r, g, b: byte ): TColor;


implementation
uses
	ComObj, XLConst;


function rgb( r, g, b: byte ): TColor;
begin
	result:= (b*256+g)*256+r;
end;

procedure TExcelFile.ir( fila, columna : integer );
begin
	self.Fila:=fila;
	self.columna:= columna;
end;

procedure TExcelFile.irr( dfila, dcolumna: integer);
begin
	fila:= fila+ dfila;
	columna:= columna+ dcolumna;
end;

function TExcelFile.ref( fila, columna:integer ): string;
begin
	result:= chr(ord('A')+columna-1)+intToStr(fila);
end;

function TExcelFile.ref_rango( f1,c1, f2,c2: integer): string;
begin
	result:= ref(f1,c1)+':'+ref(f2,c2);
end;

procedure TExcelFile.SelRango( fil1, col1, fil2,col2: integer);
begin
  r := ha.Range[ref_rango( fil1, col1, fil2, col2 )];
end;


procedure TExcelFile.CambiarFuente( nuevafuente: string);
begin
	r.Font.name:= nuevaFuente;
end;

procedure TExcelFile.BordeSimple(ancho: integer;
      Arriba, Derecha, Abajo, Izquierda,
      InteriorVertical, InteriorHorizontal: boolean);
begin

    r.Borders[xlDiagonalDown].LineStyle := xlNone;
    r.Borders[xlDiagonalUp].LineStyle := xlNone;

   if Izquierda then
   begin
    r.Borders[xlEdgeLeft].LineStyle := xlContinuous;
    r.Borders[xlEdgeLeft].Weight := ancho;
    r.Borders[xlEdgeLeft].ColorIndex := xlAutomatic;
   end;
{
   else
    r.Borders[xlEdgeLeft].LineStyle := xlNone;
 }
   if Arriba then
   begin
    r.Borders[xlEdgeTop].LineStyle := xlContinuous;
    r.Borders[xlEdgeTop].Weight := ancho;
    r.Borders[xlEdgeTop].ColorIndex := xlAutomatic;
   end;
{
   else
    r.Borders[xlEdgeTop].LineStyle := xlNone;
 }

   if Abajo then
   begin
    r.Borders[xlEdgeBottom].LineStyle := xlContinuous;
    r.Borders[xlEdgeBottom].Weight := ancho;
    r.Borders[xlEdgeBottom].ColorIndex := xlAutomatic;
   end;
{
   else
    r.Borders[xlEdgeBottom].LineStyle := xlNone;
 }

   if Derecha then
   begin
    r.Borders[xlEdgeRight].LineStyle := xlContinuous;
    r.Borders[xlEdgeRight].Weight := ancho;
    r.Borders[xlEdgeRight].ColorIndex := xlAutomatic;
   end;
{
   else
    r.Borders[xlEdgeRight].LineStyle := xlNone;
 }

   if InteriorHorizontal and (r.Rows.Count > 1 ) then
   begin
    r.Borders[xlInsideHorizontal].LineStyle := xlContinuous;
    r.Borders[xlInsideHorizontal].Weight := ancho;
    r.Borders[xlInsideHorizontal].ColorIndex := xlAutomatic;
   end;
{
   else
    r.Borders[xlInsideHorizontal].LineStyle := xlNone;

 }

   if InteriorVertical and (r.Columns.Count > 1 )then
   begin
    r.Borders[xlInsideVertical].LineStyle := xlContinuous;
    r.Borders[xlInsideVertical].Weight := ancho;
    r.Borders[xlInsideVertical].ColorIndex := xlAutomatic;
   end;
{
   else
    r.Borders[xlInsideVertical].LineStyle := xlNone;
}

end;

procedure TExcelFile.CambiarTamFuente( nuevotam: integer);
begin
	r.Font.Size:= nuevoTam;
end;

procedure TExcelFile.CambiarColorFuente_ci( nuevoci: integer );
begin
	r.Font.ColorIndex:= nuevoci;
end;


procedure TExcelFile.BoldON;
begin
	r.Font.Bold:= True;
end;

procedure TExcelFile.BoldOFF;
begin
	r.Font.Bold:= False;
end;


procedure TExcelFile.CambiarColorFondo_ci( nuevoci: integer );
begin
  r.Columns.Interior.ColorIndex := nuevoci;
end;


procedure TExcelFile.CambiarColorFuente_cl( nuevoCol: TColor );
begin
	r.Font.Color:= nuevoCol;
end;

procedure TExcelFile.CambiarColorFondo_cl( nuevoCol: TColor );
begin
  r.Columns.Interior.Color := nuevoCol;
end;

procedure TExcelFile.CambiarFormato( nuevoFormato: string );
begin
	r.NumberFormat:= nuevoFormato; // '0.00' por ejemplo, o 'd/m/yy h:mm'
end;

procedure TExcelFile.CambiarAncho( nuevoAncho: integer);
begin
	r.Columns.ColumnWidth:= nuevoAncho;
end;

procedure TExcelFile.CambiarAlto( nuevoAlto: integer );
begin
	r.Rows.RowHeight:= nuevoAlto;
end;

procedure TExcelFile.CambiarFormula( nuevaFormula: string );
begin
	r.Formula := nuevaFormula; // Por Ej.: nuevaFormula:= '=RAND()';
end;

procedure TExcelFile.CombinarCeldas;
begin
	r.Merge;
end;


procedure TExcelFile.AlinearDerecha;
begin
	r.HorizontalAlignment:= xlRight;
end;

procedure TExcelFile.AlinearIzquierda;
begin
	r.HorizontalAlignment:= xlLeft;
end;

procedure TExcelFile.AlinearCentro;
begin
	r.HorizontalAlignment:= xlCenter;
end;

procedure TExcelFile.WrapTextON;
begin
	r.WrapText:= True;
end;

procedure TExcelFile.WrapTextOFF;
begin
	r.WrapText:= False;
end;

procedure TExcelFile.Zoom( porciento: integer );
begin
  v.ActiveWindow.Zoom:= porciento;
end;


function TExcelFile.ReadV: variant;
begin
	result:= ha.cells[fila, columna];
	inc(columna );
end;

procedure TExcelFile.readln;
begin
	fila:= fila+1;
	columna:= 1;
end;

procedure TExcelFile.WriteMAF( contenido: variant; celdas: integer; alineacion: integer; formato: string );
begin
	writev( contenido );
  	selRango( fila, columna-1, fila, columna - 1 + celdas -1 );

   if celdas > 0 then
      combinarCeldas;

	case alineacion of
	alDerecha: AlinearDerecha;
	alIzquierda: AlinearIzquierda;
	alCentro: AlinearCentro;
	end;
	if formato <> '' then
		cambiarFormato( formato );
	columna:= columna + celdas -1;
end;


constructor TExcelFile.Create( nombreHoja1: string; visible, autocierre,avisocierre: boolean );
begin
	self.autocierre:= autocierre;
	self.avisocierre:= avisocierre;

	inherited Create;
	v:= CreateOleObject('Excel.Application');
	v.visible := visible;
	if nombreHoja1 <> '' then
	begin
		v.Workbooks.Add(xlWBatWorkSheet);
		v.Workbooks[1].WorkSheets[1].Name:= nombreHoja1;
		ActivoHoja( nombreHoja1 );
	end;
end;




function TExcelFile.Hoja( nombreHoja: string ): Variant;
begin
	result:=v.Workbooks[1].WorkSheets[nombreHoja];
end;


procedure TExcelFile.ActivoHoja( nombreHoja: string );
begin
	ha:=v.Workbooks[1].WorkSheets[nombreHoja];
	fila:= 1;
	columna:= 1;
end;

procedure TExcelFile.go( NombreHoja: string; fila, columna: integer );
begin
  ActivoHoja( NombreHoja );
  ir( fila, columna );
end;



procedure TExcelFile.SetPage(  PaginaVertical: boolean );
begin
   ha.PageSetup.LeftHeader := '';
   ha.PageSetup.CenterHeader := '';
   ha.PageSetup.RightHeader := '';
   ha.PageSetup.LeftFooter := '';
   ha.PageSetup.CenterFooter := '';
   ha.PageSetup.RightFooter := '';
   ha.PageSetup.LeftMargin := v.Application.InchesToPoints(0.78740157480315/2);
   ha.PageSetup.RightMargin := v.Application.InchesToPoints(0.78740157480315/2);
   ha.PageSetup.TopMargin := v.Application.InchesToPoints(0.78740157480315);
   ha.PageSetup.BottomMargin := v.Application.InchesToPoints(0.78740157480315);
   ha.PageSetup.HeaderMargin := v.Application.InchesToPoints(0);
   ha.PageSetup.FooterMargin := v.Application.InchesToPoints(0);
   ha.PageSetup.PrintHeadings := False;
   ha.PageSetup.PrintGridlines := False;
   ha.PageSetup.PrintComments := xlPrintNoComments;
//   ha.PageSetup.PrintQuality := 360;
   ha.PageSetup.CenterHorizontally := False;
   ha.PageSetup.CenterVertically := False;
   if PaginaVertical then
     ha.PageSetup.Orientation := xlPortrait
   else
     ha.PageSetup.Orientation := xlLandscape;
{
   ha.PageSetup.Draft := False;
   ha.PageSetup.PaperSize := xlPaperA4;
   ha.PageSetup.FirstPageNumber := xlAutomatic;
   ha.PageSetup.Order := xlDownThenOver;
   ha.PageSetup.BlackAndWhite := False;
}
   ha.PageSetup.Zoom := False;
   ha.PageSetup.FitToPagesWide := 1;
   ha.PageSetup.FitToPagesTall := 7;
//    ActiveWindow.SelectedSheets.PrintOut Copies:=1, Preview:=True
end;

procedure TExcelFile.WriteV( contenido: variant );
begin
	ha.cells[fila, columna]:= contenido;
	inc(columna );
end;

procedure TExcelFIle.Write( contenido: variant );
begin
  WriteV( contenido );
end;


procedure TExcelFile.WriteF( contenido: variant; formato: string );
begin
	ha.cells[fila, columna]:= contenido;
	ha.cells[fila, columna].NumberFormat:= formato;
	inc(columna );
end;

procedure TExcelFile.writeln; // fila:=fila+1; columna:= 1
begin
	inc(fila);
	columna:= 1;
end;

procedure TExcelFile.writeln( contenido: variant );
begin
  WriteV( contenido );
  writeln;
end;


procedure TExcelFile.InsertarImagen( archi: string; x, y: integer );
var
	s: variant;
   n: integer;
begin
	ha.Pictures.Insert(archi);
   n:= ha.Pictures.Count;
	s:= ha.Pictures[n];
	s.Left:= x; s.Top:= y;
end;


procedure TExcelFile.EscribirCelda(nombreHoja:string; fila:integer; columna:integer; contenido:variant);
var
	h:variant;
begin
	h:= self.Hoja(nombreHoja);
	h.cells[fila, columna]:= contenido;
end;

procedure TExcelFile.EscribirCeldaTexto(nombreHoja:string; fila:integer; columna:integer; contenido:string);
var
	h:variant;
begin
	h:= self.Hoja(nombreHoja);
	h.cells[fila, columna]:= contenido;
end;



function TExcelFile.ContenidoCelda(nombreHoja:string; var fila:integer; columna:integer; incrementa:boolean):variant;
var
	h:variant;
begin
//	h:= v.Workbooks[1].WorkSheets[1];
	h:= self.Hoja(nombreHoja);
	result:= h.cells[fila, columna];
	if incrementa then
		inc(fila);
end;


procedure TExcelFile.Guardar( nombre: string );
begin
	v.Workbooks[1].SaveAs(	nombre, xlNormal, '', '', false, false );
{
	FileName:="C:\Mis documentos\Hoja1.xls",
	FileFormat:= xlNormal,
	Password:="",
	WriteResPassword:="",
	ReadOnlyRecommended:=False,
	CreateBackup:=False );}


end;

procedure TExcelFile.Abrir( nombArchivo: string );
begin
	v.Workbooks.Open (nombArchivo);
end;



procedure TExcelFile.agregoHoja( nombreHoja: string );
begin
// v.Workbooks[1].Sheets.count
	v.Workbooks[1].Sheets.Add(,,1,xlWorksheet); // el 1 es una hoja
	v.Workbooks[1].WorkSheets[1].name:= nombreHoja;
end;

procedure TExcelFile.Free;
begin
	if autocierre and not VarIsEmpty(v) then
	begin
		v.DisplayAlerts := avisocierre;
		v.Quit;
  end;
	inherited Free;
end;


procedure TExcelFile.Cerrar( conAviso: boolean );
begin
	if not VarIsEmpty(v) then
	begin
	 v.DisplayAlerts := conAviso;
	 v.Quit;
  end;
end;


procedure TExcelFile.VisibleOn;
begin
	v.Visible:= true;
end;

procedure TExcelFile.VisibleOff;
begin
	v.Visible:= false;
end;


end.
