unit uverurl;
{$DEFINE AYUDAENWEB}
{$IFDEF FPC}
{$MODE Delphi}
{$ENDIF}

interface

uses
{$IFDEF FPC-LCL}
  LCLIntf, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, OleServer,
  {Word2000,} shellapi,
//  uconstantesSimSEE,
  StdCtrls, {OleCtrls, SHDocVw,} ExtCtrls, ToolWin, ComCtrls, ImgList,
  LResources, LazHelpHTML, IpHtml;
{$ELSE}
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleServer,
  Word2000, shellapi,
  MSHTML,
  StdCtrls, OleCtrls, SHDocVw, ExtCtrls, ToolWin, ComCtrls, ImgList;
{$ENDIF}

const
  marcadorNulo = '';

type
  TformVerURL = class(TForm)
    WebBrowser1: TWebBrowser;
    barraDeNavegacion: TToolBar;
    btAtras: TToolButton;
    btAdelante: TToolButton;
    ImageList1: TImageList;
    Button1: TButton;
    eLatitud: TEdit;
    procedure WebBrowser1NavigateComplete2(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure btAtrasClick(Sender: TObject);
    procedure btAdelanteClick(Sender: TObject);
    procedure WebBrowser1CommandStateChange(Sender: TObject;
      Command: Integer; Enable: WordBool);
    procedure Button1Click(Sender: TObject);
//    procedure Button1Click(Sender: TObject);
  private
    archi: String;
    procedure Cargar(   url: string );
  end;


procedure verGoogleMap(owner: TComponent; Latitud, Longitud: double; z: integer );

implementation

{$R *.dfm}


function URLEncode(Str: string): string;
var
  i: integer;
  res: string;
  c: char;
begin
  res:= '';

  for i:= 1 to Length(Str) do
  begin
    c:= Str[i];
    if ( c= ' ') then
      res:= res + '+'
    else
      if c in ['A'..'Z','a'..'z','0'..'9','-','_','.','+'] then
        res:= res + c
      else
        res:= res + '%' + IntToHex(Ord(c),2);
  end;
  result:= res;
end;


procedure verGoogleMap(owner: TComponent; Latitud, Longitud: double; z: integer );
var
  f: TformVerURL;
  url: string;
begin
(*
  url:= 'http://maps.google.com/maps/ms?ie=UTF8&hl=es&msa=0&t=h&ll=';
  url:= url+ FloatToStrF( -Latitud, ffFixed, 9, 5 );
  url:= url+','+FloatToStrF( -Longitud, ffFixed, 9, 5 );
  url:= url+'&z='+IntToStr( z );
  *)

  url:= 'http://energiaenuruguay.com/mapa.php?Latitud=';
  url:= url+ FloatToStrF( -Latitud, ffFixed, 9, 5 );
  url:= url+'&Longitud='+FloatToStrF( -Longitud, ffFixed, 9, 5 );
  url:= url+'&z='+IntToStr( z );


  f:= TFormVerURL.Create( owner );
  f.Cargar( url );
  f.ShowModal;
  f.Free;
end;

procedure TformVerURL.WebBrowser1NavigateComplete2(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
var
  nombreArchi, nombreURL: String;
//  posPunto: Integer;
begin

{$IFNDEF AYUDAENWEB}
  with WebBrowser1.Document AS _Document do //(WebBrowser1.Document AS _Document) do
  begin
    ActiveWindow.View.ShowAll := false;
    ActiveWindow.View.TableGridlines := False;
    ActiveWindow.DisplayRulers := False;
   ActiveWindow.View.type_ := wdWebView; // wdPageView;
  end;
{$ENDIF}

  nombreArchi:= ExtractFileName(archi);
  // borro las "/" del inicio
  (*
  while pos( '/', nombreArchi ) > 0 do
    delete( nombreArchi, 1, pos('/', nombreArchi ) );
    *)
  nombreURL:= ExtractFileName(WebBrowser1.LocationURL);
  while pos( '/', nombreURL ) > 0 do
    delete( nombreURL, 1, pos('/', nombreURL ) );

  self.Caption:= nombreURL;
end;

procedure TformVerURL.Cargar( url: string );
var
  archi_enblanco: string;
begin
  Self.Caption:= url;
  archi:= url;
  archi:= archi + #0;

  try
    WebBrowser1.Navigate(archi, 14)
  except
    showmessage('Error al intentar abrir archivo: '+archi );
  end;
end;

procedure TformVerURL.btAtrasClick(Sender: TObject);
begin
  WebBrowser1.GoBack;
end;


(*
procedure TformVerURL.Button1Click(Sender: TObject);
begin
  Cargar(Self, '', true);
end;
  *)
procedure TformVerURL.btAdelanteClick(Sender: TObject);
begin
  WebBrowser1.GoForward;
end;

procedure TformVerURL.WebBrowser1CommandStateChange(Sender: TObject;
  Command: Integer; Enable: WordBool);
begin
  case Command of
    CSC_NAVIGATEBACK: btAtras.Enabled := Enable;
    CSC_NAVIGATEFORWARD: btAdelante.Enabled := Enable;
  end;
end;




///////////////////////////////////////////////////////////////////////////////
// esto busca el objeto si lo encuentra lo retorna sino retorna nil

function FindObjByName(Web1: TWebBrowser;
  Name: string;
  intInstance: Integer ): IHTMLElement;
  ///////////////////////////////////////////////////////////////////////////////
var
  eleChild: IHTMLElement;
  eleElement: IHTMLElement;
  colGrandParents: IHTMLElementCollection;
  colParents: IHTMLElementCollection;
  selElement: IHTMLSelectElement;
  intCount: Integer;
  intG: Integer;
  intGMax: Integer;
  intP: Integer;
  intPMax: Integer;
  Document: IHTMLDocument2;
  className: string;
begin
  intCount    := -1;
  result:= nil;
  //Magic declarations
  Document := Web1.Document as IHTMLDocument2;
  if Document = nil then Exit;

  colGrandParents := Document.all;
  if colGrandParents = nil then Exit;
  intGMax := colGrandParents.Length - 1;

  for intG := 0 to intGMax do
  begin
    eleElement := colGrandParents.Item(  intG, '' ) as IHTMLElement;
    className:= eleElement.className;
    writeln( intG, ' ', className );
    if (intG mod 13)= 1 then
      readln;
(*
    if className <> '' then
    begin
      selElement := eleElement as IHTMLSelectElement;
      if selElement.Name = Name then
      begin
        Inc(intCount);
        if intCount = intInstance then
          result:= eleElement;
      end;
    end;
  *)
  end;
end;


///////////////////////////////////////////////////////////////////////////////
procedure GetListBoxOptions(Web1: TWebBrowser;
  strListBoxName: string;
  intInstance: Integer;
  tslLines: TStrings;
  out intSelected: Integer);
  ///////////////////////////////////////////////////////////////////////////////
var
  eleChild: IHTMLElement;
  eleElement: IHTMLElement;
  colGrandParents: IHTMLElementCollection;
  colParents: IHTMLElementCollection;
  selElement: IHTMLSelectElement;
  intCount: Integer;
  intG: Integer;
  intGMax: Integer;
  intP: Integer;
  intPMax: Integer;
  Document: IHTMLDocument2;
begin
  tslLines.Clear;
  intSelected := -1;
  intCount    := -1;

  selElement:= FindObjByName(Web1, strListBoxName, intInstance ) as IHTMLSelectElement;
  if selElement = nil then exit;

  intSelected := selElement.selectedIndex;
  colParents  := eleElement.children as IHTMLElementCollection;
  intPMax  := colParents.Length - 1;
  for intP := 0 to intPMax do
  begin
     eleChild := colParents.Item(intP, '') as IHTMLElement;
     tslLines.Add(eleChild.InnerText);
  end;
end;

(* Ejemplo de lectura de una combo
procedure TForm1.Button2Click(Sender: TObject);
var
  intSelected: Integer;
begin
  ComboBox1.Text := '';
  GetListBoxOptions(WebBrowser1, 'select', 0, ComboBox1.Items, intSelected);
  if intSelected > -1 then
  begin
    ComboBox1.Text := ComboBox1.Items[intSelected];
  end;
end;
*)



procedure TformVerURL.Button1Click(Sender: TObject);
var
  campo: IHTMLElement;
  valor: String;

begin
  campo:= FindObjByName( webBrowser1, 'rch_latitud', 0 );
  if campo <> nil then
    valor:= campo.toString
  else
    valor:= 'no encontrado';

  eLatitud.Text:= valor;

end;

end.


