unit uConversorGlobDiaraAHoraria;

{$MODE Delphi}

interface

uses
  LCLIntf, LCLType, LMessages, Messages, SysUtils, Variants, Classes,
  Graphics, Controls, Forms,
  Dialogs, StdCtrls, uAuxiliares, IT4;

type
  TForm1 = class(TForm)
    Button1: TButton;
    eArchi: TEdit;
    Button2: TButton;
    Label3: TLabel;
    eBeta: TEdit;
    OpenDialog1: TOpenDialog;
    Label1: TLabel;
    cbModelo: TComboBox;
    Label2: TLabel;
    Label4: TLabel;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}


var
  DiaDelAnio: integer;
  modelo: integer;
  beta: double;
  EnergiaDelDia: double;
  EnergiaDelDiaEnPlanoInclinado: double;



function ediaria(xDiaDelAnio: integer; xAngulo: double; xModelo: integer;
  xEnergiaDelDia: double): double;
var
  nombreModelo: string;

begin

  DiaDelAnio := xDiaDelAnio;
  beta := xAngulo;
  modelo := xModelo;
  EnergiaDelDia := xEnergiaDelDia;

  case modelo of
    1: nombreModelo := 'Liu-Jordan';
    2: nombreModelo := 'HDKR';
    3: nombreModelo := 'Perez';
  end;

  EnergiaDelDiaEnPlanoInclinado :=
    it4.NuevoDia_HgCalcm2(DiaDelAnio, beta,
    nombreModelo,
    EnergiaDelDia) * 3600.0;
  { Joule / m2 }
  Result := EnergiaDelDiaEnPlanoInclinado;
end;


// energia horaria [J]
function ehoraria(xDiaDelAnio: integer; xHora: integer; xAngulo: double;
  xModelo: integer; xEnergiaDelDia: double): double;
begin
  if (DiaDelAnio <> xDiaDelAnio) or (modelo <> xModelo) or
    (beta <> xAngulo) or (EnergiadelDia <> xEnergiaDelDia) then
  begin
    EnergiaDelDiaEnPlanoInclinado :=
      ediaria(xDiaDelAnio, xAngulo, xModelo,
      xEnergiaDelDia);
  end;

  Result := EnergiaHoraPtr^[xHora] * 3600;
end;



procedure TForm1.Button1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    eArchi.Text := OpenDialog1.FileName;

end;

procedure TForm1.Button2Click(Sender: TObject);
var
  f, sal: textFile;
  cnt, cnt_vacias: integer;
  r: string;

  kHora: integer;
  rDia: double;
  diastr: string;
  beta: double;
  kDia: integer;
  radgd: double;
  kModelo: integer;
  jdia, jmes, janio: integer;
  primerDiaDelAnio, dt: TDateTime;
  eDia, eHora: double;
  jHora: integer;

  ddias: double;
begin
  kModelo := cbModelo.ItemIndex + 1;
  try
    beta := StrToFloat(ebeta.Text);
    beta := beta / 180.0 * pi;
  except
    raise Exception.Create(
      'Error al convertir el ángulo de inclinación a número real.');
  end;
  IT_Init(beta);

  assignFile(f, eArchi.Text);
  {$I-}
  reset(f);
  {$I+}
  if ioresult <> 0 then
    raise Exception.Create('No puede abrir: ' + eArchi.Text);

  cnt := 0;
  cnt_vacias := 0;

  readln(f, r);
  while (not EOF(f)) and (cnt_vacias = 0) do
  begin
    readln(f, r);
    r := trim(r);
    if length(r) > 3 then
      Inc(cnt)
    else
      Inc(cnt_vacias);
  end;


  reset(f);
  readln(f, r);

  assignfile(sal, 'ehoraria.xlt');
  rewrite(sal);

  Write(sal, 'día');
  for jhora := 0 to 23 do
    Write(sal, #9, jhora);
  writeln(sal, #9, 'rDiaPH', #9, 'rDiaPI');

  for kDia := 1 to cnt do
  begin
    try
      readln(f, r);
      diastr := nextpal(r);

      jdia := StrToInt(copy(diastr, 1, 2));
      jmes := StrToInt(copy(diastr, 4, 2));
      janio := StrToInt(copy(diastr, 7, length(diastr) - 7 + 1));
      if janio < 100 then
        if janio < 25 then
          janio := 2000 + janio
        else
          janio := 1900 + janio;

      primerDiaDelAnio := EncodeDate(janio, 1, 1);
      dt := EncodeDate(janio, jmes, jdia);
      ddias := (dt - primerDiaDelAnio);

      jdia := trunc(ddias + 0.5) + 1;
      if jdia <= 0 then
        writeln(diastr, jdia);

      radgd := nextfloat(r);


      DateTimeToString(r, 'yyyy-mm-dd', dt);
      Write(sal, r);
      eDia := ediaria(jdia, beta, kmodelo, radgd);
      for jhora := 0 to 23 do
      begin
        eHora := ehoraria(jdia, jhora, beta, kmodelo, radgd);
        Write(sal, #9, eHora: 8: 1);
      end;
      writeln(sal, #9, Cal_A_KWH(radgd) * 1000 * 100 * 100 * 3600: 8: 1, #9, eDia: 8: 1);
    except
      raise Exception.Create('Error procesando la línea: ' + IntToStr(kDia + 1));
    end;
  end;

  closefile(sal);
  closefile(f);
end;

end.
