unit ufBaterias;

{$MODE Delphi}

interface

uses
  uhtmlverdoc, Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls
//  , jpeg
  ,xMatDefs;

type

  TfBaterias = class(TForm)
    Label1: TLabel;
    eCapacidad: TEdit;
    Label2: TLabel;
    eCoeficienteTermico: TEdit;
    Label3: TLabel;
    eTemperaturaNominal: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    GroupBox1: TGroupBox;
    Label9: TLabel;
    Label10: TLabel;
    eVidaUtil_profundidad1: TEdit;
    eVidaUtil_ciclos1: TEdit;
    eVidaUtil_Profundidad2: TEdit;
    eVidaUtil_Ciclos2: TEdit;
    eImaxDescarga: TEdit;
    eImaxRecarga: TEdit;
    eTension: TEdit;
    eProfundidadPermitida: TEdit;
    Label11: TLabel;
    eRendimientoCarga: TEdit;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Image1: TImage;
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
    flg_salir: boolean;
  public
    { Public declarations }

  modifiado: boolean;

  procedure SetDatos(
    CapacidadDeBateria, // Ah @ 100h
    Bat_CT, // coeficiente de variación de la capacidad con la temperatura
    Bat_TN, // temperatura nominal.
    Bat_ID, // [A] corriente máxima de descarga
    Bat_IR, // [A] corriente máxima de recarga
    Bat_VN, // [V] tensión nominal de la batería.
    PPCB, // Profundidad Permitida de uso de Capacidad de la Batería.
    Bat_rc, // rendimiento de carga
    Bat_x1, // profundidad de descarga del punto PC2
    Bat_y1, // número de ciclos del punto PC1
    Bat_x2, // profundidad de descarga del punto PC2
    Bat_y2: NReal // número de ciclos del punto PC2
  );

  procedure GetDatos(
    var CapacidadDeBateria, // Ah @ 100h
    Bat_CT, // coeficiente de variación de la capacidad con la temperatura
    Bat_TN, // temperatura nominal.
    Bat_ID, // [A] corriente máxima de descarga
    Bat_IR, // [A] corriente máxima de recarga
    Bat_VN, // [V] tensión nominal de la batería.
    PPCB, // Profundidad Permitida de uso de Capacidad de la Batería.
    Bat_rc, // rendimiento de carga
    Bat_x1, // profundidad de descarga del punto PC2
    Bat_y1, // número de ciclos del punto PC1
    Bat_x2, // profundidad de descarga del punto PC2
    Bat_y2: NReal // número de ciclos del punto PC2
  );

  end;


implementation

{$R *.lfm}






procedure TfBaterias.Button1Click(Sender: TObject);
begin
  flg_salir:= true;
  modalresult:= 1;
end;

procedure TfBaterias.Button2Click(Sender: TObject);
begin
  flg_salir:= true;
  modalresult:= 2;
end;

procedure TfBaterias.Button3Click(Sender: TObject);
begin
  htmlverdoc( 'baterias' );
end;

procedure TfBaterias.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  k: integer;

begin
  CanClose:= true;
  if flg_salir then exit;
  
  k:=  application.messagebox( '¿Desea guardar los cambios?', 'Confirmación', MB_YESNOCANCEL );
  case k of
  IDYES: modalresult:= 1; // salir y guardar
  IDNO: modalresult:= 2; // salir pero no guardar
  IDCANCEL: CanClose:= false;
  else
    Canclose:= false;
  end;
end;

procedure TfBaterias.SetDatos(
    CapacidadDeBateria, // Ah @ 100h
    Bat_CT, // coeficiente de variación de la capacidad con la temperatura
    Bat_TN, // temperatura nominal.
    Bat_ID, // [A] corriente máxima de descarga
    Bat_IR, // [A] corriente máxima de recarga
    Bat_VN, // [V] tensión nominal de la batería.
    PPCB, // Profundidad Permitida de uso de Capacidad de la Batería.
    Bat_rc, // rendimiento de carga
    Bat_x1, // profundidad de descarga del punto PC2
    Bat_y1, // número de ciclos del punto PC1
    Bat_x2, // profundidad de descarga del punto PC2
    Bat_y2: NReal // número de ciclos del punto PC2
  );

begin


  self.eCapacidad.Text:= FloatToStrF( CapacidadDeBateria, ffFixed, 6, 1 );
  self.eCoeficienteTermico.Text:= FloatToStrF( Bat_CT, ffFixed, 6, 5 );
  self.eTemperaturaNominal.Text:= FloatToStrF( Bat_TN, ffFixed, 6, 1 );
  self.eImaxDescarga.Text:= FloatToStrF(Bat_ID, ffFixed, 6, 1 );
  self.eImaxRecarga.Text:= FloatToStrF( Bat_IR, ffFixed, 6, 1 );
  self.eTension.Text:= FloatToStrF( Bat_VN, ffFixed, 6, 1 );
  self.eProfundidadPermitida.Text:= FloatToStrF( PPCB, ffFixed, 6, 3 );
  self.eRendimientoCarga.Text:= FloatToStrF( Bat_rc, ffFixed, 6,3 );
  self.eVidaUtil_profundidad1.Text:= FloatToStrF( Bat_x1, ffFixed, 6,3 );
  self.eVidaUtil_ciclos1.Text:= FloatToStrF( Bat_y1, ffFixed, 6, 0  );
  self.eVidaUtil_profundidad2.Text:= FloatToStrF( Bat_x2, ffFixed, 6, 3 );
  self.eVidaUtil_Ciclos2.Text:= FloatToStrF( Bat_y2, ffFixed, 6, 0 );
  flg_salir:= false;
end;

procedure TfBaterias.GetDatos(
    var CapacidadDeBateria, // Ah @ 100h
    Bat_CT, // coeficiente de variación de la capacidad con la temperatura
    Bat_TN, // temperatura nominal.
    Bat_ID, // [A] corriente máxima de descarga
    Bat_IR, // [A] corriente máxima de recarga
    Bat_VN, // [V] tensión nominal de la batería.
    PPCB, // Profundidad Permitida de uso de Capacidad de la Batería.
    Bat_rc, // rendimiento de carga
    Bat_x1, // profundidad de descarga del punto PC2
    Bat_y1, // número de ciclos del punto PC1
    Bat_x2, // profundidad de descarga del punto PC2
    Bat_y2: NReal // número de ciclos del punto PC2
  );
begin

  CapacidadDeBateria:= StrToFloat(self.eCapacidad.Text);
  Bat_CT:= StrToFloat(self.eCoeficienteTermico.Text );
  Bat_TN:= StrToFloat(self.eTemperaturaNominal.Text);
  Bat_ID:= StrToFloat(self.eImaxDescarga.Text);
  Bat_IR:= StrToFloat(self.eImaxRecarga.Text);
  Bat_VN:= StrToFloat(self.eTension.Text );
  PPCB:= StrToFloat(self.eProfundidadPermitida.Text);
  Bat_rc:= StrToFloat(self.eRendimientoCarga.Text );
  Bat_x1:= StrToFloat(self.eVidaUtil_profundidad1.Text);
  Bat_y1:= StrToFloat(self.eVidaUtil_ciclos1.Text);
  Bat_x2:= StrToFloat(self.eVidaUtil_profundidad2.Text);
  Bat_y2:= StrToFloat(self.eVidaUtil_Ciclos2.Text);

  if Bat_x1 > Bat_x2 then
  begin
      vswap( Bat_x1, Bat_x2 );
      vswap( Bat_y1, Bat_y2 );
  end;
  if Bat_y2 >= Bat_y1 then
    showmessage('Revise los datos. A mayor profunidad de descarga la batería debiera durar menos ciclos.' );

end;
end.
