unit ufCarga;

{$MODE Delphi}

interface

uses
  uhtmlverdoc, uExcelFile,
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, xMatDefs, NucleoT, demht,
  // jpeg,
  ExtCtrls, utilidades;

type
  TfCarga = class(TForm)
    Label1: TLabel;
    sg_CDC: TStringGrid;
    Label8: TLabel;
    eEnergiaDiaria_CDC: TEdit;
    Label2: TLabel;
    sg_Estacionalidad: TStringGrid;
    Label7: TLabel;
    sg_EnergiaMediaDiaria: TStringGrid;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Image1: TImage;
    btExcelExpImp: TButton;
    procedure FormCloseQuery(Sender: TObject; var CanClose: boolean);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btExcelExpImpClick(Sender: TObject);
  private
    { Private declarations }
    flg_salir: boolean;
    ef: TExcelFile;
  public
    { Public declarations }
    procedure SetDatos(const PerfilCDC: TPerfilCDC;
      const EstacionalCDC: TEstacionalesCDC);
    procedure GetDatos(var PerfilCDC: TPerfilCDC;
      var EstacionalCDC: TEstacionalesCDC);
  end;


implementation

{$R *.lfm}

procedure TfCarga.SetDatos(const PerfilCDC: TPerfilCDC;
  const EstacionalCDC: TEstacionalesCDC);
var
  k: integer;
  mes: T_Mes;
  energiaDiaria_CDC: NReal;
begin

  energiaDiaria_CDC := 0;

  sg_CDC.Cells[0, 1] := 'AM';
  sg_CDC.Cells[0, 2] := 'PM';
  for k := 1 to 12 do
  begin
    sg_CDC.Cells[k, 0] := IntToStr(k);
    sg_CDC.Cells[k, 1] := FloatToStrF(PerfilCDC[k - 1], ffFixed, 6, 2);
    sg_CDC.Cells[k, 2] := FloatToStrF(PerfilCDC[k - 1 + 12], ffFixed, 6, 2);
    energiaDiaria_CDC := energiaDiaria_CDC + PerfilCDC[k - 1] + PerfilCDC[k - 1 + 12];
  end;

  eEnergiaDiaria_CDC.Text := FloatToStrF(energiaDiaria_CDC, ffFixed, 6, 2);

  for mes := Enero to Diciembre do
  begin
    sg_Estacionalidad.cells[Ord(Mes), 0] := IntToStr(Ord(mes));
    sg_Estacionalidad.cells[Ord(Mes), 1] :=
      FloatToStrF(EstacionalCDC[mes], ffFixed, 6, 2);
    sg_EnergiaMediaDiaria.Cells[Ord(Mes), 0] := IntToStr(Ord(mes));
    sg_EnergiaMediaDiaria.Cells[Ord(Mes), 1] :=
      FloatToStrF(EstacionalCDC[mes] * energiaDiaria_CDC, ffFixed, 6, 2);
  end;

  flg_salir := False;
end;

procedure TfCarga.Button1Click(Sender: TObject);
begin
  flg_salir := True;
  modalresult := 1;
end;

procedure TfCarga.Button2Click(Sender: TObject);
begin
  flg_salir := True;
  modalresult := 2;
end;

procedure TfCarga.Button3Click(Sender: TObject);
begin
  htmlverdoc('carga');
end;

procedure TfCarga.btExcelExpImpClick(Sender: TObject);
var
  PerfilCDC: TPerfilCDC;
  EstacionalCDC: TEstacionalesCDC;
  kHora: integer;
  kMes: T_Mes;
  s: string;
begin
  if btExcelExpImp.Caption = 'Exportar a Excel ->' then
  begin
    ef := TExcelFile.Create('carga', True, True, False);
    btExcelExpImp.Caption := 'Importar de Excel <-';

    GetDatos(PerfilCDC, EstacionalCDC);

    ef.ir(1, 1);
    ef.Writeln('Curva de carga [W]');
    ef.Write('Hora: ');
    for kHora := 0 to 23 do
      ef.Write(kHora);
    ef.writeln;

    ef.Write('P[W]');
    for kHora := 0 to 23 do
      ef.Write(PerfilCDC[kHora]);
    ef.writeln;

    ef.writeln;
    ef.writeln('Factores estacionales.');
    ef.Write('mes:');
    for kMes := Enero to Diciembre do
      ef.Write(nombreMes(kMes));
    ef.writeln;

    ef.Write('factor:');
    for kMes := Enero to Diciembre do
      ef.Write(EstacionalCDC[kMes]);
    ef.writeln;

    ef.SelRango(1, 1, 10, 24);
    ef.CambiarAncho(5);

  end
  else
  begin

    try
      ef.ir(1, 1);
      ef.SelRango(1, 1, 10, 24);

      ef.readln;
      ef.readln; // renglón con las horas

      s := ef.ReadV_Str;
      if s <> 'P[W]' then
      begin
        ef.Free;
        ef := nil;
        btExcelExpImp.Caption := 'Exportar a Excel ->';
        raise Exception.Create(
          'Error al importar, esperaba que la línea 3 comenzara con P[W] y comienza con: '
          + s);
      end;


      for kHora := 0 to 23 do
        PerfilCDC[kHora] := ef.ReadV_Float;
      ef.readln;

      ef.readln;
      ef.readln;
      ef.readln; // renglón con los meses

      s := ef.ReadV_Str;
      for kMes := Enero to Diciembre do
        EstacionalCDC[kMes] := ef.ReadV_Float;
      ef.readln;

      ef.Free;
      ef := nil;
      SetDatos(PerfilCDC, EstacionalCDC);
      btExcelExpImp.Caption := 'Exportar a Excel ->';
    except
      on E: Exception do
        ShowMessage(E.Message + ' :::' + IntToStr(E.HelpContext) +
          '\n\nFijese si no está editando una celda de Excel. Si es así debe presionar ENTER en Excel para salir del modo edición de la celda.');

    end;

  end;

end;

procedure TfCarga.FormCloseQuery(Sender: TObject; var CanClose: boolean);
var
  k: integer;

begin
  CanClose := True;
  if flg_salir then
  begin
    if ef <> nil then
      ef.Free;
    exit;
  end;

  k := application.messagebox('¿Desea guardar los cambios?',
    'Confirmación', MB_YESNOCANCEL);
  case k of
    idYes: modalresult := 1; // salir y guardar
    idNo: modalresult := 2; // salir pero no guardar
    idCancel: CanClose := False;
    else
      Canclose := False;
  end;
  if (Canclose) then
    if ef <> nil then
      ef.Free;

end;

procedure TfCarga.FormCreate(Sender: TObject);
begin
  ef := nil;
  utilidades.AutoSizeTable(self, sg_CDC, self.ClientWidth, 200);
  utilidades.AutoSizeTable(self, sg_Estacionalidad, self.ClientWidth, 200);
  utilidades.AutoSizeTable(self, sg_EnergiaMediaDiaria, self.ClientWidth, 200);
end;

procedure TfCarga.GetDatos(var PerfilCDC: TPerfilCDC;
  var EstacionalCDC: TEstacionalesCDC);
var
  k: integer;
  mes: T_Mes;
begin
  for k := 1 to 12 do
  begin
    PerfilCDC[k - 1] := StrToFloat(sg_CDC.Cells[k, 1]);
    PerfilCDC[k - 1 + 12] := StrToFloat(sg_CDC.Cells[k, 2]);
  end;

  for mes := Enero to Diciembre do
    EstacionalCDC[mes] := StrToFloat(sg_Estacionalidad.cells[Ord(Mes), 1]);
end;

end.
