unit ufPaneles;

{$MODE Delphi}

interface

uses
  uhtmlverdoc, Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, xMatDefs,
//  jpeg,
  ExtCtrls, Grids, ActPan04, NucleoT, utilidades;


type


  TfPaneles = class(TForm)
    Label3: TLabel;
    Label6: TLabel;
    eAngulo: TEdit;
    eNPaneles: TEdit;
    Label1: TLabel;
    ePotenciaPicoPorPanel: TEdit;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Image1: TImage;
    sgAngulos: TStringGrid;
    cbUnAnguloPorMes: TCheckBox;
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure cbUnAnguloPorMesClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    flg_salir: boolean;

  public

    { Public declarations }
    procedure SetDatos(
      nPaneles: integer; PotenciaPicoPorPanel, angulo: NReal;
      usarUnAnguloPorMes: integer;
      var Angulos: TArrMensual );
    procedure GetDatos(
      var nPaneles: integer; var PotenciaPicoPorPanel, angulo: NReal;
      var usarUnAnguloPorMes: integer;
      var Angulos: TArrMensual );

    procedure ActualizarEstado;
  end;

implementation

{$R *.lfm}


procedure TfPaneles.Button1Click(Sender: TObject);
begin
  flg_salir:= true;
  modalresult:= 1;
end;

procedure TfPaneles.Button2Click(Sender: TObject);
begin
  flg_salir:= true;
 modalresult:= 2;
end;

procedure TfPaneles.Button3Click(Sender: TObject);
begin
 htmlverdoc( 'paneles' );
end;


procedure TfPaneles.ActualizarEstado;
begin
  if not self.cbUnAnguloPorMes.Checked then
  begin
    self.sgAngulos.Visible:= false;
    self.eAngulo.Visible:= true;
  end
  else
  begin
    self.sgAngulos.Visible:= true;
    self.eAngulo.Visible:= false;
  end;
end;

procedure TfPaneles.cbUnAnguloPorMesClick(Sender: TObject);
begin
  ActualizarEstado;
end;

procedure TfPaneles.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  k: integer;

begin
  CanClose:= true;
  if flg_salir then exit;
  
  k:=  application.messagebox( '¿Desea guardar los cambios?', 'Confirmación', MB_YESNOCANCEL );
  case k of
  IDYES: modalresult:= 1; // salir y guardar
  IDNO: modalresult:= 2; // salir pero no guardar
  IDCANCEL: CanClose:= false;
  else
    Canclose:= false;
  end;
end;

procedure TfPaneles.FormCreate(Sender: TObject);
begin
  utilidades.AutoSizeTable(self, sgAngulos, self.ClientWidth, 200);
end;

procedure TfPaneles.SetDatos(
  nPaneles: integer; PotenciaPicoPorPanel, angulo: NReal;
  usarUnAnguloPorMes: integer;
  var Angulos: TArrMensual );
var
  k: integer;
begin
  Self.eNPaneles.Text:= IntToStr( nPaneles );
  Self.ePotenciaPicoPorPanel.Text:= FloatToStrF( PotenciaPicoPorPanel, ffFixed, 6, 1 );
  Self.eAngulo.text:= FloatToStrF( angulo, ffFixed, 6, 1 );

  if usarUnAnguloPorMes >0  then
    self.cbUnAnguloPorMes.Checked:= true
  else
    self.cbUnAnguloPorMes.Checked:= false;

  for k:= 1 to 12 do
  begin
    sgAngulos.Cells[k, 0]:= IntToStr( k );
    sgAngulos.Cells[k, 1]:=  FloatToStrF( Angulos[ T_Mes(k-1)], ffFixed, 6, 2 );
  end;
  sgAngulos.Cells[0, 1]:='[º]';

  ActualizarEstado;
  
  flg_salir:= false;
end;

procedure TfPaneles.GetDatos(
  var nPaneles: integer; var PotenciaPicoPorPanel, angulo: NReal;
  var usarUnAnguloPorMes: integer;
  var Angulos: TArrMensual );
var
  k: integer;
begin
  nPaneles:= StrToInt( eNPaneles.text );
  PotenciaPicoPorPanel:= StrToFloat( ePotenciaPicoPorPanel.text );
  Angulo:= StrToFloat( eAngulo. text );

  if self.cbUnAnguloPorMes.Checked then
    usarUnAnguloPorMes:= 1
  else
    usarUnAnguloPorMes:= 0;
  for k:= 1 to 12 do
    Angulos[ T_Mes( k-1 ) ]:= StrToFloat( sgAngulos.Cells[k, 1]);

end;


end.
