unit ufSimulacion;

interface

uses
  uhtmlverdoc, Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, xMatDefs, StdCtrls;

type

  { TfSimulacion }

  TfSimulacion = class(TForm)
    lbl_CantidadAnios: TLabel;
    ePeriodosTotales: TEdit;
    lbl_DiasPermitidosDeDeficit: TLabel;
    eDiasDeDeficitPermitidos: TEdit;
    bt_Aceptar: TButton;
    bt_Cancelar: TButton;
    bt_Ayuda: TButton;
    CBModeloCEGH: TCheckBox;
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure bt_AceptarClick(Sender: TObject);
    procedure bt_CancelarClick(Sender: TObject);
    procedure bt_AyudaClick(Sender: TObject);
  private
    { Private declarations }
    flg_salir: boolean;
  public
    { Public declarations }
    procedure SetDatos( PeriodosTotales, DiasDeDeficitPermitidos: integer; usarModeloCEGHParaGenerarFiltracionSolar: boolean );
    procedure GetDatos( var PeriodosTotales, DiasDeDeficitPermitidos: integer; var usarModeloCEGHParaGenerarFiltracionSolar: boolean );
  end;


implementation

{$R *.lfm}

procedure TfSimulacion.bt_AceptarClick(Sender: TObject);
begin
 flg_salir:= true;
 modalresult:= 1;
end;

procedure TfSimulacion.bt_CancelarClick(Sender: TObject);
begin
 flg_salir:= true;
 modalresult:= 2;
end;

procedure TfSimulacion.bt_AyudaClick(Sender: TObject);
begin
  htmlverdoc( 'parametrosgenerales' );
end;

procedure TfSimulacion.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  k: integer;

begin
  CanClose:= true;
  if flg_salir then exit;

  k:=  application.messagebox( 'Desea guardar los cambios?', 'Confirmacin', MB_YESNOCANCEL );
  case k of
  IDYES: modalresult:= 1; // salir y guardar
  IDNO: modalresult:= 2; // salir pero no guardar
  IDCANCEL: CanClose:= false;
  else
    Canclose:= false;
  end;
end;

procedure TfSimulacion.SetDatos( PeriodosTotales, DiasDeDeficitPermitidos: integer; usarModeloCEGHParaGenerarFiltracionSolar: boolean );
begin
  Self.ePeriodosTotales.Text:= IntToStr( PeriodosTotales );
  Self.eDiasDeDeficitPermitidos.Text:= IntToStr( DiasDeDeficitPermitidos );
  CBModeloCEGH.Checked:= usarModeloCEGHParaGenerarFiltracionSolar;
  flg_salir:= false;
end;

procedure TfSimulacion.GetDatos( var PeriodosTotales, DiasDeDeficitPermitidos: integer; var usarModeloCEGHParaGenerarFiltracionSolar: boolean );
begin
  PeriodosTotales:= StrToInt( Self.ePeriodosTotales.Text );
  DiasDeDeficitPermitidos:= StrToInt( Self.eDiasDeDeficitPermitidos.Text );
  usarModeloCEGHParaGenerarFiltracionSolar:= CBModeloCEGH.Checked;
end;

end.
