unit ActPan04;
{+doc
+NOMBRE: ActPan02
+CREACION: 18.8.1992
+AUTORES:  rz,rch
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO:
	Implementacin del TActor TPanel para el progrma de simulacin de
	energas SimEnerg. PASO MINIMO HORARIO.

+PROYECTO: SOLAR.

+REVISION:
	10.09.92/21.05/rch@home. Adaptacin de la vieja Act_Pan a una unidad
	donde se utiliza el Nucleo de Tiempos Nucleo_T
+AUTOR:

+DESCRIPCION:
-doc}

interface
uses
	VGlbs02,
	Actores,
	FDSol,
	IT4,
	NucleoT,
	xMatDefs;


Type

	TPanelSolar  = class(TActor)
		CPDD:NReal;
		Area,	{ rea del TPanelSolar  en m2 }

		Energia, { acumulada desde el ltimo latido del Director }
		beta:NReal; { ngulo de inclinacin del TPanelSolar  respecto de la
			horizontal en radianes }
    beta_DelMes: TArrMensual;
    cambiarBetaTodosLosMeses: boolean;

		Rendimiento: NReal;
    EhMaxima, PotenciaMaxima: NReal;

		F:TFuenteDeSol;  { Indice Zeballos de ruido tropofrico }



		constructor Create(
      xNombre: string;
			xArea:NReal; // [m2] rea efectiva ( 0.34 para paneles de 48W, en el 2008 Zeballos dice que es 0.4) }
			xF: TFuenteDeSol; { Fuente de energa solar }
			xBeta:NReal; // [] ngulo de colocacin del TPanelSolar
      xPotenciaMaxima: NReal // [w] potencia mxima que entrega el Panel.
      ); overload;

		constructor Create(
      xNombre: string;
			xArea:NReal; // [m2] rea efectiva ( 0.34 para paneles de 48W, en el 2008 Zeballos dice que es 0.4) }
			xF: TFuenteDeSol; { Fuente de energa solar }
			xBeta_DelMes: TArrMensual; // [] ngulo de colocacin del TPanelSolar
      xPotenciaMaxima: NReal // [w] potencia mxima que entrega el Panel.
      ); overload;

		procedure Free; override;

		procedure Vivir; override;
		procedure Prepararse; override;

		function Demandar(var XD:TFicha):boolean; override;
		function Ofertar(var XO:TFicha):boolean; override;

		procedure CambioEstacion; override;{latente, cambia el rendimiento del TPanelSolar
					simulando el efecto que tiene sobre el mismo la temperatura
					de la estacion en curso}

    procedure CadaMes; override; { Latente, cambia el ngulo si est marcado cambiar}
		procedure CadaHora; override;	{latente, recibe energa de la fuente de sol}
	end;


implementation



{$IFDEF PANLOG}
var
	panlog: text;
{$ENDIF}



{ Mtodos de TPanelSolar  }
constructor TPanelSolar.Create(
  xNombre: string;
			xArea:NReal; // rea efectiva en m2 del TPanelSolar  }
			xF: TFuenteDeSol; // Fuente de energa solar
			xBeta:NReal;  // ngulo de colocacin del TPanelSolar
      xPotenciaMaxima: NReal );

{$IFDEF PANLOG}
var
  k: integer;
{$ENDIF}

begin
	{ Agregar tareas latentes al ncleo de tiempos }
	inherited Create( xNombre );

	Area:=xArea;
	F:=xF;

	F.beta:=xbeta/180*Pi;
	beta:=xbeta;

	IT4.IT_init(F.beta);

	Energia:=0;
  PotenciaMaxima:= xPotenciaMaxima;
  EhMaxima:= PotenciaMaxima * 3600;
  cambiarBetaTodosLosMeses:= false;
	CambioEstacion; { Slo a los efectos de actualizar el rendimiento }

	{$IFDEF PANLOG}
	assign( panlog, 'panlog.xlt');
	rewrite(panlog);
  writeln(panlog, 'Energia en Joules generada para cada hora de cada da.');
  write( panlog, 'Da',#9,'kDia' );
  for k := 0 to 23 do write( panlog, #9, k:2 );
	{$ENDIF}

end;

constructor TPanelSolar .Create(
      xNombre: string;
			xArea:NReal; // [m2] rea efectiva ( 0.34 para paneles de 48W, en el 2008 Zeballos dice que es 0.4) }
			xF: TFuenteDeSol; { Fuente de energa solar }
			xBeta_DelMes: TArrMensual; // [] ngulo de colocacin del TPanelSolar
      xPotenciaMaxima: NReal // [w] potencia mxima que entrega el Panel.
      );
begin
  self.Create(xNombre, xArea, xF, 35, xPotenciaMaxima );
  self.beta_DelMes:= xBeta_DelMes;
  self.cambiarBetaTodosLosMeses:= true;
  CadaMes; // solo para actualizar el angulo de colocacin.
end;


procedure TPanelSolar.Free;
begin
  {$IFDEF PANLOG}
	close(panlog);
  {$ENDIF}
	inherited Free;
end;

procedure TPanelSolar.Vivir;
begin
end;

procedure TPanelSolar.Prepararse;
begin
  cadaMes;
end;


function TPanelSolar.Demandar(var XD: TFicha):boolean;
begin
	Demandar:=false
end;



{ CambioHora, es un mtodo latente del TActor TPanelSolar  utilizado para
recibir energa de la fuente de sol. La energa es acumulada en la
variable Energia, la cual se limpia cada vez que el Director solicita
al TPanelSolar  que oferte }

procedure TPanelSolar.CadaHora;
var
  Eh: NReal;
begin
  Eh:= Rendimiento*F.EnergiaDeLaHoraEnCurso*Area;
  if Eh > EhMaxima then
    Eh:= EhMaxima;
	Energia:= Energia + Eh;
end;


{ Este mtodo es uno por los que se comunica el director con el TPanelSolar .
En este caso particular es para solicitar al TPanelSolar  que oferte la energa
que ha recibido en las horas transcurridas }

function TPanelSolar.Ofertar(var XO: TFicha):boolean;
label
	fin;

begin
  {$IFDEF PANLOG}
  if hora = 0 then
  begin
    writeln( panlog );
    write( panlog, NucleoT.Anio,'/', ord( NucleoT.Mes) +1, '/', NucleoT.DiaDelMes, ' ', NucleoT.Hora, ':', NucleoT.Minuto );
    write( panlog, #9, diadelanio );
  end;
  write(panlog, #9, Energia:12:1);
  {$ENDIF}

	{ Si es poca la energa no oferta }
	if Energia < AsumaCero then
	begin
		ofertar:=false;
	end
	else
	begin
		{ Llenado de la TFicha de oferta }
		XO.energia := Energia;
		XO.prioridad := 1;
		XO.IdAct:= Self;
		Ofertar:= true;
	end;

	{ Limpio el acumulador de energa }
	Energia:= 0;
end;


{ CambioEstacion,  es un procedimiento latente que se utiliza
para variar el rendimiento del TPanelSolar  a lo largo del ao para tener
en cuenta el efecto de la temperatura.
	Tambin cambiamos la inclinacin del TPanelSolar  al inicio de cada estacin }
procedure TPanelSolar .CambioEstacion;
begin
	Case Estacion of
		Verano:
		begin
			Rendimiento:= 0.1;
      {
			beta:=(F^.Lat-11.6)/180*Pi;
			F^.beta:=beta;
			IT_init(F^.beta);
      }
		end;

		Otonio, Primavera:
		begin
			Rendimiento:= 0.11;
      {
			beta:=(F^.Lat)/180*Pi;
			F^.beta:=beta;
			IT_init(F^.beta);
      }
		end;
		Invierno:
		begin
			Rendimiento:= 0.12;
      {
			beta:=(F^.Lat	+11.6)/180*Pi;
			F^.beta:=beta;
			IT_init(F^.beta);
      }
		end;
	end;
end;

procedure TPanelSolar.CadaMes;
begin
  if self.cambiarBetaTodosLosMeses then
  begin
  	F.beta:= Self.beta_DelMes[mes]/180.0*pi;
		IT_init(F.beta);
  end;
end;

end.
