{+doc
+NOMBRE: fdr01
+CREACION:  12.8.92
+AUTORES: rch, rz
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO:
  Definicin del objeto FDREAV. FDREAV es un descendiente de FDR y es
por lo tanto una fuente de ruido ms.
  La particularidad de FDREAV es que genera los datos eliguiendo al
azar entre los ruidos reales guardados en el archivo ruido.dat

+PROYECTO: SOLAR.

+REVISION:
+AUTOR:
+DESCRIPCION:

-doc}

(*
!!!!!!!
  OJO, no cambiar la definicin de nmero real dentro de esta unidad
pues usa datos que se calcularon como reales.
  Esto significa entre otras cosas que no se puede incluir la unidad
"xMatDefs" en la clusula "uses".
*)

unit FDR01;

interface

uses
  xmatdefs, fdrs, SysUtils;

type

  VecInfo = packed record
    Min, Fac: extended;
    NE: longint;
    r: array[1..10000] of byte;
  end;



  TFDREAV = class(TFuenteDeRuido)
    RN: ^VecInfo;

    Mem, MC: integer;
    pk, tam: integer;
    function Valor: NReal; override;
    constructor Create(xMem: integer);
    procedure Free; override;
  end;


implementation

function GetExeDir: string;
var
  s: string;
begin
  s := ParamStr(0);
  s := ExtractFileDir(s);
  Result := s;
end;


constructor TFDREAV.Create;
var
  fr: file;
  n: integer;

begin
  inherited Create;
  Mem := xMem;
  MC := 0;

  filemode := 0;
  Assign(fr, GetExeDir + '\rn01.dat');
  {$I-}
  reset(fr, 1);
  {$I+}
  if ioresult <> 0 then
    raise Exception.Create('No puedo encontrar el archivo rn01.dat');

  n := filesize(fr);
  getmem(RN, n);
  blockread(fr, rn^, n);
  Close(fr);

end;

procedure TFDREAV.Free;
begin
  freemem(RN, 2 * SizeOf(extended) + SizeOf(longint) + RN^.NE);
  inherited Free;
end;


function TFDREAV.Valor: NReal;
begin
  if MC = 0 then
  begin
    pk := random(rn^.ne) + 1;
    MC := Mem;
  end
  else
  if pk < rn^.ne then
    pk := pk + 1
  else
    pk := 1;
  Valor := rn^.r[pk] * rn^.fac + rn^.min;
  Dec(MC);
end;


end.
