unit FacPos;

{+doc
+NOMBRE: FacPos.
+CREACION: 30.07.92.
+AUTORES: RZ, RCh
+REGISTRO:
+TIPO: unit Pascal
+PROPOSITO: Calcular factor de posicin geogrfica respecto de datos
  obtenidos en otra posicin. Los datos son de radiacin solar global
  en plano horizontal.


+PROYECTO: Solar

+REVISION:
 feb.1993, rch: !!!IMPORTANTE: OJO, no cambiar en esta unidad la definicin
 de numero real de (real) a (NReal), pues se utiliza informacin guardada en
 el archivo Mat12 en forma de nmeros reales. Si en algn momento se genera
 de nuevo dicho archivo (cosa poco probable) se podra utilizar NReal

+AUTOR:
+DESCRIPCION:

-doc}

interface

uses
  SysUtils, horrores;

const
  CaminoAMat12 = 'mat12.dat';


function FactorDePosicionGeografica(Mes: integer): double;
{ Mes en un entero en el rango 1..12 }


procedure CalcularFactores(LatitudDeInstalacion, LongitudDeInstalacion,
  LatitudDeLosDatos, LongitudDeLosDatos: double );


implementation


var
  Factores: array[1..12] of real;

type
  SuperMat = packed array[1..21, 1..21] of real48;
  TNumeroMes = 1..12;


function GetExeDir: string;
var
  s: string;
begin
  s := ParamStr(0);
  s := ExtractFileDir(s);
  Result := s;
end;


procedure CargarMes(var Matriz: SuperMat; k: TNumeroMes);
var
  Arch: file of SuperMat;
begin
  Assign(arch, GetExeDir + '\' + CaminoAMat12);
  {$I-}
  reset(arch);
  {$I+}
  if ioresult <> 0 then
  begin
    Assign(arch, 'Mat12.dat');
    {$I-}
    reset(arch);
    {$I+}
    if ioresult <> 0 then
      error(' No encuentro MAT12.DAT');
  end;

  seek(arch, k - 1);
  Read(arch, matriz);
  Close(arch);
end;



function FactorDePosicionGeografica(Mes: integer): double;
begin
  FactorDePosicionGeografica := factores[mes];
end;



function Lat2k(lat: real): integer;
var
  k: integer;
begin
  k := trunc((Lat - 30) / 0.25 + 1.5);
  if k < 1 then
    k := 1;
  if k > 21 then
    k := 21;
  lat2k := k;
end;

function Lon2j(lon: real): integer;
var
  j: integer;
begin
  j := trunc((Lon - 53.5) / 0.25 + 1.5);
  if j < 1 then
    j := 1;
  if j > 21 then
    j := 21;
  lon2j := j;
end;

procedure CalcularFactores(LatitudDeInstalacion, LongitudDeInstalacion,
  LatitudDeLosDatos, LongitudDeLosDatos: double );
var
  fins, fdat: double ;
  kins, jins, kdat, jdat: integer;
  Matriz: SuperMat;
  mes: integer;

begin
  kins := Lat2k(LatitudDeInstalacion);
  jins := Lon2j(LongitudDeInstalacion);

  kdat := Lat2k(LatitudDeLosDatos);
  jdat := Lon2j(LongitudDeLosDatos);

  for mes := 1 to 12 do
  begin
    CargarMes(Matriz, mes);
    fins := Matriz[kins, jins];
    fdat := Matriz[kdat, jdat];
    factores[mes] := fins / fdat;
  end;
end;

end.
