{+doc
+NOMBRE: Act_Bat
+CREACION: 17.8.1992
+AUTORES:  gcp,rch
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO:    Implementacin del TActor Batera.
+PROYECTO: SOLAR.

+REVISION:
+AUTOR:
+DESCRIPCION:
-doc}

unit ActBat02;

interface

uses
  NucleoT,
  Horrores,
  Actores,
  VGlbs02,
  FDIAS02,
  xMatDefs,
  OcurrenX,
  Bases;

type


  TBateria01 = class(TActor)
    Ciclado: TOcurrencias;
    CicladoDelDia: NReal; // ciclado del timo da simulado
    maxCicladoDelDia: NReal; // mximo del valor anterior slo para control

    CN, { Capacidad Nominal [AH] (Ampere Hora) @TN a 100 Horas }
    TN  { Temperatura Nominal [C] }: NReal;
    TE, { [C] Temperatura del electrolito }
    CT, { [1/C] Coeficiente de variacin de la capacidad con TE }
    CargaActual, { [AH] Capacidad actual corregida a TN }
    ng, { Rendimiento de carga }
    ImaxR, { [A] Corriente mxima de carga }
    ImaxD, { [A] Corriente mxima de descarga }
    VN, { [V] Tensin Nominal de la batera @TN }
    PM, { Porcente de CN que realmente permitimos utilizar }
    Cmin, { [AH] Valor de mnimo que se permite a la
        capacidad de la batera }
    MinCapDia, MaxCapDia { Mnimo y mximo diarios de la capacidad}: NReal;

    F1, F2, F3: NReal;

    constructor Create(xNombre: string;
      xCN, xTN, xCT, xImaxR, xImaxD, xVN, xPM: NReal; xHistoriaArch: string;
      xng: NReal);

    procedure Free; override;

    procedure Vivir; override;
    procedure Prepararse; override;

    function Demandar(var XD: TFicha): boolean; override;
    function Ofertar(var XO: TFicha): boolean; override;

    procedure AceptoDemanda(var XD: TFicha); override;
    procedure AceptoOferta(var XO: TFicha); override;

    procedure CadaDia; override;

  end;



implementation

{ mtodos de TBateria01 }

constructor TBateria01.Create(xNombre: string;
  xCN, xTN, xCT, xImaxR, xImaxD, xVN, xPM: NReal; xHistoriaArch: string;
  xng: NReal);
begin
  inherited Create(xNombre);

  MinCapDia := xCN;
  MaxCapDia := xCN;

  CN := xCN;
  TN := xTN;
  CT := xCT;
  ImaxR := xImaxR;
  ImaxD := xImaxD;
  VN := xVN;
  PM := xPM;

  Cmin := (1 - PM) * CN;

{
Faltaban inicializar:
-----------------------------------------}

  CargaActual := CN;
  Ciclado := TOCurrencias.Create_Init(0, PM * CN, 100);
  ng := xng; {0.85;}

{
  VG.Init(SizeOf(NReal));
  VG.assign(xHistoriaArch+'.his');
  VG.Rewrite;
  }

  CicladoDelDia := 0;
  maxCicladoDeldia := 0;

end;

procedure TBateria01.CadaDia;
begin
  CicladoDelDia := (MaxCapDia - MinCapDia) / CN;
  if CicladoDelDia > MaxCicladoDelDia then
    MaxCicladoDelDia := CicladoDelDia;

  Ciclado.ocurrio(MaxCapDia - MinCapDia);
  MaxCapDia := CargaActual;
  MinCapDia := CargaActual;
end;


procedure TBateria01.Free;
begin
  Ciclado.Free;
  inherited Free;
end;


procedure TBateria01.Vivir;
begin
end;

procedure TBateria01.Prepararse;
begin
{
  If PasoDeTiempo > 0.5 then RunError(201);
  }

  F1 := ImaxR * VN * PasoDeTiempo * t_base / 3600;
  F2 := 3600 / e_base;
  F3 := ImaxD * VN * PasoDeTiempo * t_base / 3600;

end;

function TBateria01.Demandar(var XD: TFicha): boolean;
var
  D11, D12{,D13}: NReal;
begin

  if CargaActual < MinCapDia then
    MinCapDia := CargaActual
  else if CargaActual > MaxCapDia then
    MaxCapDia := CargaActual;


  D11 := (CN - CargaActual) * VN;
  TE := TAmb;
  D12 := D11 * (1 + CT * (TE - TN)) / ng;
  {
  D13:= ImaxR * VN * PasoDeTiempo* t_base/3600;
  }
  if D12 > {D13}F1 then
    XD.energia := F1 {D13}
  else
    XD.energia := D12;
  XD.energia := XD.energia * F2;
  XD.prioridad := 3;
  XD.IdAct := Self;
  Demandar := True;
end;

function TBateria01.Ofertar(var XO: TFicha): boolean;
var
  O11, O12: NReal;

begin
  O11 := (CargaActual - Cmin) * VN;
  TE := TAmb;
  O12 := O11 * (1 + CT * (TE - TN));
  {  O13:= ImaxD * VN * PasoDeTiempo*t_base/3600; }

  if O12 > {O13}F3 then
    XO.energia := F3{O13}
  else
    XO.energia := O12;

  if XO.energia < 0 then
    XO.Energia := 0;

  if EsCero(XO.energia) then
  begin
    XO.Energia := 0;
    Ofertar := False;
    XO.IdAct := Self;
  end
  else
  begin
    XO.energia := XO.energia * F2;
    XO.prioridad := 7;
    XO.IdAct := Self;
    Ofertar := True;
  end;
end;

procedure TBateria01.AceptoDemanda(var XD: TFicha);
begin
  inherited AceptoDemanda(XD);
  CargaActual := CargaActual + XD.Energia / F2 * ng / (1 + CT * (TE - TN)) / VN;
  {
  VG.agregar(Co);
  }
end;

procedure TBateria01.AceptoOferta(var XO: TFicha);
begin
  inherited AceptoOferta(XO);
  CargaActual := CargaActual - XO.Energia / F2 / (1 + CT * (TE - TN)) / VN;
  {
  VG.agregar(Co);
  }
end;



end.
