{+doc
+NOMBRE: DEMht
+CREACION: 3.11.92
+AUTORES:
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO: Demandante02 es una carga a la que se le puede difinir
	potencia, hora en que se prende, hora en que se apaga y prioridad
	con que demanda. Este demandante funciona bien slo si el paso de
	tiempo es <= 1 Hora
+PROYECTO: SOLAR.

+REVISION:
+AUTOR:
+DESCRIPCION:
-doc}
unit demht;
interface

uses
	VGlbs02, NucleoT, Actores,
	xMatDefs, bases;

type


	TRecHorasPA = array[0..3] of T_Hora;
	TPerfilCDC = array[0..23] of NReal;
	TEstacionalesCDC = array[Enero..Diciembre] of NReal;

	TDemHT = class(TActor)
		Prioridad:integer;
		Prendido: boolean;
		rInvierno, rPrim_Otonio, rVerano, TR: TRecHorasPA;
		Energia: TPerfilCDC;
		pEsts: TEstacionalesCDC;

		constructor Create(
      xNombre: string;
			xPerfil: TPerfilCDC; // valores en kW
			xEstacionales: TEstacionalesCDC;
      xFactor: NReal; // multiplicador
			xPrioridad:integer );

		function Demandar(var XD:TFicha):boolean; override;

		procedure AcumQ( var Q:NReal);
	end;


function promedio( v: TPerfilCDC ): NReal; overload;
function suma( v: TPerfilCDC ): NReal; overload;

implementation

function suma( v: TPerfilCDC ): NReal;
var
  k: integer;
  a: NReal;
begin
  a:= 0;
  for k:= 0 to 23 do
      a:= a+ v[k];
  result:= a;
end;

function promedio( v: TPerfilCDC ): NReal;
begin
  result:= suma( v )/ 24.0;
end;




constructor TDemHT.Create(
  xNombre: string;
			xPerfil: TPerfilCDC;
			xEstacionales: TEstacionalesCDC;
      xFactor: NReal;
			xPrioridad:integer );

var
	k:integer;

begin
	inherited Create( xNombre );

	Energia:= xPerfil;
	PEsts:= xEstacionales;
	for k:= 0 to 23 do
    Energia[k]:=xPerfil[k]*1000*PasoDeTiempo*xFactor;
				{*1000 porque el perfilCDC esta en kW}
	Prioridad:=xPrioridad;
end;

procedure TDemHT.AcumQ( var Q:NReal);
var
	th:NReal;
	h: integer;
	m: NReal;
	mes: T_Mes;

begin
	th := 0;
	for mes:= Enero to Diciembre do
	begin
		m:= pEsts[mes];
		for h:= 0 to 23 do
			th:= th+ Energia[h]*m*30;
	end;
	Q:= Q+ th/(30*12);
end;




function TDemHT.Demandar(var XD:TFicha):boolean;
begin
		XD.energia :=  Energia[hora]* pEsts[mes];
		XD.prioridad := Prioridad;
		XD.IdAct:= Self;
		Demandar:= true;
end;



end.