{+doc
+NOMBRE:
+CREACION:21.09.92
+AUTORES: rch, rz
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO:  Definicin del objeto FuenteDeSol. Cuando Se Inicializa se
  indica la latitud y la longitud donde se ubicar la fuente para
  tener en cuenta segn el mes del ao el micro-clima de las distintas
  zonas del pas.
    La fuente de sol es un objeto ANIMADO que se activa todos los
  das para generar el valor de la energa acumulada que se le
  asignar al da y una vez por mes para cambiar el factor de posicin
  geogrfico que tiene en cuenta el micro-clima.

+PROYECTO: SOLAR.

+REVISION:
+AUTOR:
+DESCRIPCION:
-doc}

unit fdsol02horaria;

interface

uses
  xMatDefs,
  FDR01, FacPos, VGlbs02, NucleoT, FDSol,
  IT4;

const
  LatitudDeLaEstanzuela = 34.25; {??? Conseguir los valores reales}
  LongitudDeLaEstanzuela = 57.75;

  HoraSalidaDelSol = 8;
  HoraPuestaDelSol = 18;
  HorasDeSol = HoraPuestaDelSol - HoraSalidaDelSol;

var
  modelo: string;
{ 'Liu-Jordan', 'Perez' y 'HDKR'}

type


  FuenteAnilloRuidoso = class(TFuenteDeSol)

    xEnergiaDelDia: NReal;
    FDPG: NReal; { Factor de posicin geogrfica para el mes en
            curso }
    fr: TFDREAV;
    w: NReal;

    constructor Create(xNombre: string; Latitud, Longitud: NReal);
    function Valor: NReal; override;
    procedure Free; override;

    function EnergiaDeLaHoraEnCurso: NReal; override;
    function EnergiaDelDia: NReal; override;
    procedure CadaDia; override;{ latente }
    procedure CadaMes; override;{ latente }

  end;



implementation

const  {???}
  A0 = 534.5; { valor constante de la envolvente (valor medio de los 8
            aos)}

  A1 = 47.3; {Idem para la primer armonico comenzando el l del 10 }
  B1 = 252.3;

  NumerDia_1del10 = 274; { Nmero del da del ao ( ao de 365 das)
    que corresponde al 1 de Octubre }


function d(k: integer): NReal;
var
  alfa: NReal;
const
  w = 2 * 3.1416 / 365;
begin
  alfa := (k - NumerDia_1del10) * w;
  d := A0 + A1 * cos(alfa) + B1 * sin(alfa);
end;


constructor FuenteAnilloRuidoso.Create(xNombre: string; Latitud, Longitud: NReal);
begin
  inherited Create(xNombre);
  CalcularFactores(
    Latitud,
    Longitud,
    LatitudDeLaEstanzuela,
    LongitudDeLaEstanzuela);

  Lat := Latitud;
  Long := Longitud;
  fr := TFDREAV.Create(3);{se considera "razonable" considerar una memoria de 3 das
          para la generacin de ruidos} {zeballos}
  CadaMes; { Actualiza el micro-clima para el mes de comienzo }
  CadaDia; { Actualiza el valor de energa para el da actual }

end;




procedure FuenteAnilloRuidoso.CadaMes;
begin
  FDPG := FactorDePosicionGeografica(Ord(Mes) + 1);
end;

procedure FuenteAnilloRuidoso.CadaDia;
//var
//  Pot6HorasP48Wp: NReal;
begin
  xEnergiaDelDia := (Fr.valor + 1) * d(DiaDelAnio) * FDPG;
  //  Pot6HorasP48Wp:= It4.Cal_A_KWH( xEnergiaDelDia )*1000/24*6*100*100 * 0.34 *0.12;

  xEnergiaDelDia := it4.NuevoDia_HgCalcm2(DiaDelAnio, beta, modelo, xEnergiaDelDia);
  { [WH/m2], energa diaria en el plano inclinado }

  xEnergiaDelDia := xEnergiaDelDia * 3600;
end;

function FuenteAnilloRuidoso.EnergiaDelDia: NReal;
begin
  EnergiaDelDia := xEnergiaDelDia;
end;


function FuenteAnilloRuidoso.EnergiaDeLaHoraEnCurso: NReal;
begin
  EnergiaDeLaHoraEnCurso := EnergiaHoraPtr^[hora] * 3600;
end;


function FuenteAnilloRuidoso.Valor;
begin
  Valor := xEnergiaDelDia;
end;

procedure FuenteAnilloRuidoso.Free;
begin
  inherited Free;
end;

begin
  modelo := 'Liu-Jordan';{, 'Perez' y 'HDKR'}
end.
