{+doc
+NOMBRE:
+CREACION:  19.09.92..20:10
+AUTORES: rch
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO:
+PROYECTO: Autonoma/SimEnerg

+REVISION:
+AUTOR:
+DESCRIPCION:

  Versin simplificada de la unidad (Tasks) para utilizarla en
el proyecto SimEnerg. La simplificacion consiste en haber quitado los chequeos
de "codigo critico" diponibles en el modulo Tasks pues los despachadores que
se implementaran con este modulo son despachadores de "eventos software".

-doc}

unit task2;


interface

uses
  SysUtils,
  Ancestor, listas, uSeresVivos;

type
  TProcedure = procedure(var varpar);

  TProcTarea = class(TCosa)
    p: TProcedure;
    pvarpar: pointer;
    constructor Create(proc: TProcedure; var varpar);
    procedure run;
  end;

  TDespachador = class
    lstSeresVivos: TLista;
    lstTareas: TLista;
    constructor Create;
    procedure run; virtual;
    procedure runTareas;
    procedure AgregarActor(actor: TSerVivo);
    procedure QuitarActor(actor: TSerVivo);
    procedure AgregarProcTarea(p: TProcedure; var varpar);
    procedure Free; virtual;
    procedure Clear; virtual;
  end;



  TDespachador_CadaSegundo = class(TDespachador)
    procedure run; override;
  end;

  TDespachador_CadaMinuto = class(TDespachador)
    procedure run; override;
  end;

  TDespachador_CadaHora = class(TDespachador)
    procedure run; override;
  end;

  TDespachador_CadaDia = class(TDespachador)
    procedure run; override;
  end;

  TDespachador_CadaSemana = class(TDespachador)
    procedure run; override;
  end;

  TDespachador_CadaMes = class(TDespachador)
    procedure run; override;
  end;

  TDespachador_CambioEstacion = class(TDespachador)
    procedure run; override;
  end;

  TDespachador_CadaAnio = class(TDespachador)
    procedure run; override;
  end;

  TDespachador_CambioHorario = class(TDespachador)
    procedure run; override;
  end;

implementation



constructor TProcTarea.Create(proc: TProcedure; var varpar);
begin
  inherited Create;
  p := proc;
  pvarpar := @varpar;
end;


procedure TProcTarea.run;
begin
  p(pvarpar^);
end;

constructor TDespachador.Create;
begin
  lstSeresVivos := TLista.Create;
  lstTareas := TLista.Create;
end;

procedure TDespachador.Clear;
begin
  lstSeresVivos.Clear;
  lstTareas.Clear;
end;

procedure TDespachador.run;
begin
  raise Exception.Create('TDespachador.run Alcanzado...!!!');
end;

procedure TDespachador.RunTareas;
var
  p: NodoPtr;
  tarea: TProcTarea;
begin
  p := lstTareas.ultimo;
  while p <> nil do
  begin
    tarea := p^.item as TProcTarea;
    p := lstSeresVivos.anterior(p);
    tarea.run;
  end;
end;




procedure TDespachador.AgregarActor(actor: TSerVivo);
begin
  lstSeresVivos.Append(Actor);
end;


procedure TDespachador.AgregarProcTarea(p: TProcedure; var varpar);
var
  Tarea: TProcTarea;
begin
  Tarea := TProcTarea.Create(p, varpar);
  lstTareas.append(Tarea);
end;

procedure TDespachador.QuitarActor(actor: TSerVivo);
var
  p: NodoPtr;
begin
  p := lstSeresVivos.Search(actor);
  if p <> nil then
    lstSeresVivos.quitar(p);
end;

procedure TDespachador.Free;
begin
  lstTareas.Free; // liberamos las Tareas. De los actores se encargan otros
  inherited Free;
end;


procedure TDespachador_cadaSegundo.run;
var
  p, tp: NodoPtr;
begin
  p := lstSeresVivos.ultimo;
  while p <> nil do
  begin
    tp := lstSeresVivos.anterior(p);
    TSerVivo(p^.item).CadaSegundo;
    p := tp;
  end;
  runTareas;
end;



procedure TDespachador_CadaMinuto.run;
var
  p, tp: NodoPtr;
begin
  p := lstSeresVivos.ultimo;
  while p <> nil do
  begin
    tp := lstSeresVivos.anterior(p);
    TSerVivo(p^.item).CadaMinuto;
    p := tp;
  end;
  runTareas;
end;


procedure TDespachador_CadaHora.run;
var
  p, tp: NodoPtr;
begin
  p := lstSeresVivos.ultimo;
  while p <> nil do
  begin
    tp := lstSeresVivos.anterior(p);
    TSerVivo(p^.item).CadaHora;
    p := tp;
  end;
  runTareas;
end;

procedure TDespachador_CadaDia.run;
var
  p, tp: NodoPtr;
begin
  p := lstSeresVivos.ultimo;
  while p <> nil do
  begin
    tp := lstSeresVivos.anterior(p);
    TSerVivo(p^.item).CadaDia;
    p := tp;
  end;
  runTareas;
end;

procedure TDespachador_CadaSemana.run;
var
  p, tp: NodoPtr;
begin
  p := lstSeresVivos.ultimo;
  while p <> nil do
  begin
    tp := lstSeresVivos.anterior(p);
    TSerVivo(p^.item).CadaSemana;
    p := tp;
  end;
  runTareas;
end;

procedure TDespachador_CadaMes.run;
var
  p, tp: NodoPtr;
begin
  p := lstSeresVivos.ultimo;
  while p <> nil do
  begin
    tp := lstSeresVivos.anterior(p);
    TSerVivo(p^.item).CadaMes;
    p := tp;
  end;
  runTareas;
end;

procedure TDespachador_CambioEstacion.run;
var
  p, tp: NodoPtr;
begin
  p := lstSeresVivos.ultimo;
  while p <> nil do
  begin
    tp := lstSeresVivos.anterior(p);
    TSerVivo(p^.item).CambioEstacion;
    p := tp;
  end;
  runTareas;
end;

procedure TDespachador_CadaAnio.run;
var
  p, tp: NodoPtr;
begin
  p := lstSeresVivos.ultimo;
  while p <> nil do
  begin
    tp := lstSeresVivos.anterior(p);
    TSerVivo(p^.item).CadaAnio;
    p := tp;
  end;
  runTareas;
end;

procedure TDespachador_CambioHorario.run;
var
  p, tp: NodoPtr;
begin
  p := lstSeresVivos.ultimo;
  while p <> nil do
  begin
    tp := lstSeresVivos.anterior(p);
    TSerVivo(p^.item).CambioHorario;
    p := tp;
  end;
  runTareas;
end;



end.
