unit uSeresVivos;

interface

uses
	Ancestor;

type
	TSerVivo = class ( TCosaConNombre )

		{ Procedimientos latentes
		sobreescribir aquellos que tengan sentido.
		 }
		procedure CadaSegundo; virtual;
		procedure CadaMinuto;  virtual;
		procedure CadaHora;virtual;
		procedure CadaDia;virtual;
		procedure CadaSemana; virtual;
		procedure CadaMes;virtual;
		procedure CambioEstacion; virtual;
		procedure CadaAnio; virtual;
		procedure CambioHorario; virtual;

		constructor Create( xNombre: string );
    procedure Free; override;
	end;
	

implementation
uses
	NucleoT;



(***** Por defecto  el Actor se elimina de la lista de despacho de los
diferentes eventos. Con esto logramos que solamente quede anotado para
recibir los eventos que realmente maneje el actor aumentando as la
velocidad de la simulacin *****)
procedure TSerVivo.CadaSegundo;
begin
	NucleoT.CadaSegundo.quitarActor( self );
end;

procedure TSerVivo.CadaMinuto;
begin
	NucleoT.CadaMinuto.quitarActor(self);
end;

procedure TSerVivo.CadaHora;
begin
	NucleoT.CadaHora.quitarActor(self);
end;

procedure TSerVivo.CadaDia;
begin
	NucleoT.CadaDia.quitarActor(self);
end;


procedure TSerVivo.CadaSemana;
begin
	NucleoT.CadaSemana.quitarActor(self);
end;

procedure TSerVivo.CadaMes;
begin
	NucleoT.CadaMes.quitarActor( Self );
end;


procedure TSerVivo.CambioEstacion;
begin
	NucleoT.CambioEstacion.quitarActor( Self );
end;

procedure TSerVivo.CadaAnio;
begin
	NucleoT.CadaAnio.quitarActor( Self );
end;


procedure TSerVivo.CambioHorario;
begin
	NucleoT.CambioHorario.quitarActor( Self );
end;


constructor TSerVivo.Create( xNombre: string );
begin
	inherited Create( xNombre );
	// lo agregamoa a todos los despachadores de eventos
	// automticamente ser eliminado de aquellos eventos que
	// el no maneje.
	NucleoT.CadaSegundo.agregarActor( self );
	NucleoT.CadaMinuto.agregarActor(self);
	NucleoT.CadaHora.agregarActor(self);
	NucleoT.CadaDia.agregarActor(self);
	NucleoT.CadaSemana.agregarActor(self);
	NucleoT.CadaMes.agregarActor( Self );
	NucleoT.CambioEstacion.agregarActor( Self );
	NucleoT.CadaAnio.agregarActor( Self );
	NucleoT.CambioHorario.agregarActor( Self );

end;

procedure TSerVivo.Free;
begin
 	NucleoT.CadaSegundo.quitarActor( self );
	NucleoT.CadaMinuto.quitarActor(self);
	NucleoT.CadaHora.quitarActor(self);
	NucleoT.CadaDia.quitarActor(self);
	NucleoT.CadaSemana.quitarActor(self);
	NucleoT.CadaMes.quitarActor( Self );
	NucleoT.CambioEstacion.quitarActor( Self );
	NucleoT.CadaAnio.quitarActor( Self );
	NucleoT.CambioHorario.quitarActor( Self );
  inherited Free;
end;

end.
