{+doc
+NOMBRE: Act_Bat
+CREACION: 17.8.1992
+AUTORES:  gcp,rch
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO:    Implementacin del TActor Batera.
+PROYECTO: SOLAR.

+REVISION:
+AUTOR:
+DESCRIPCION:
-doc}

unit ActBat02;
interface
uses
	NucleoT,
	Horrores,
//	uescenario,
	Actores,
	FDIAS02,
//	GigaVect,
	xMatDefs,
	OcurrenX,
	Bases;


type


	TBateria01 = class(TActor)
		Ciclado: TOcurrencias;
{		VG: VectorGigante;}

		CN, { Capacidad Nominal [AH] (Ampere Hora) @TN a 100 Horas }
		TN  { Temperatura Nominal [C] }
		:NReal;
		TE, { [C] Temperatura del electrolito }
		CT, { [1/C] Coeficiente de variacin de la capacidad con TE }
		Co, { [AH] Capacidad actual corregida a TN }
		ng, { Rendimiento de carga }
		ImaxR, { [A] Corriente mxima de carga }
		ImaxD, { [A] Corriente mxima de descarga }
		VN, { [V] Tensin Nominal de la batera @TN }
		PM, { Porcente de CN que realmente permitimos utilizar }
		Cmin, { [AH] Valor de mnimo que se permite a la
				capacidad de la batera }
		MinCapDia, MaxCapDia { Mnimo y mximo diarios de la capacidad}
		:NReal;

		F1, F2, F3: NReal;

		constructor Nacer(
			escenario: TEscenario;
			xCN, xTN, xCT, xImaxR, xImaxD, xVN, xPM: NReal;
			xHistoriaArch:string;
			xng: NReal );

		destructor Morir;virtual;
		procedure Vivir;virtual;
		procedure Prepararse;virtual;

		function Demandar(var XD:TFicha):boolean;virtual;
		function Ofertar(var XO:TFicha):boolean;virtual;

		procedure AceptoDemanda(var XD:TFicha);virtual;
		procedure AceptoOferta(var XO:TFicha);virtual;

		procedure CadaDia; override;

	end;



implementation

{ mtodos de TBateria01 }

constructor TBateria01.Nacer(
			escenario: TEscenario;
			xCN, xTN, xCT, xImaxR, xImaxD, xVN, xPM: NReal;
			xHistoriaArch:string;
			xng: NReal );
begin
	inherited Create( escenario );

	MinCapDia:= xCN;
	MaxCapDia:=xCN;

	CN:= xCN;
	TN:= xTN;
	CT:= xCT;
	ImaxR:= xImaxR;
	ImaxD:= xImaxD;
	VN:= xVN;
	PM:= xPM;

	Cmin:= (1 - PM) * CN;

{
Faltaban inicializar:
-----------------------------------------}

	Co:= CN;
	Ciclado:= TOCurrencias.Create(0, PM*CN, 100);
	ng := xng; {0.85;}

{
	VG.Init(SizeOf(NReal));
	VG.assign(xHistoriaArch+'.his');
	VG.Rewrite;
	}



end;

procedure TBateria01.CadaDia;
begin
	Ciclado.ocurrio(MaxCapDia-MinCapDia);
	MaxCapDia:=Co;
	MinCapDia:=Co;
end;


destructor TBateria01.Morir;
begin
	Ciclado.Free;
	inherited Free;
end;


procedure TBateria01.Vivir;
begin
end;

procedure TBateria01.Prepararse;
begin
{
	If PasoDeTiempo > 0.5 then RunError(201);
	}

	F1:= ImaxR * VN * escenario.PasoDeTiempo* t_base/3600;
	F2:= 3600/e_base;
	F3:= ImaxD * VN * escenario.PasoDeTiempo* t_base/3600;

end;

function TBateria01.Demandar(var XD:TFicha):boolean;
var
	D11,D12{,D13}:NReal;
begin

	if Co < MinCapDia then MinCapDia:= Co
	else if Co > MaxCapDia then MaxCapDia:= Co;


	D11:= ( CN - Co) * VN;
	TE:= TAmb;
	D12:= D11*(1+ CT * (TE - TN))/ng;
	{
	D13:= ImaxR * VN * PasoDeTiempo* t_base/3600;
	}
	if D12 > {D13}F1 then	XD.energia := F1 {D13}
	else XD.energia := D12;
	XD.energia:= XD.energia * F2;
	XD.prioridad := 3;
	XD.IdAct:= Self;
	Demandar:= true;
end;

function TBateria01.Ofertar(var XO:TFicha):boolean;
var
	O11,O12,O13:NReal;

begin
	O11:= ( Co - Cmin ) * VN;
	TE:= TAmb;
	O12:= O11 * (1 + CT * (TE - TN));
{	O13:= ImaxD * VN * PasoDeTiempo*t_base/3600; }

	if O12 > {O13}F3 then	XO.energia := F3{O13}
	else XO.energia := O12;
	if XO.energia < - AsumaCero then
			Error(' En TBateria01. oferta negativa');
	if EsCero(XO.energia) then
	begin
		XO.Energia:=0;
		Ofertar:= false;
		XO.IdAct:= Self;
	end
	else
	begin
		XO.energia:= XO.energia * F2;
		XO.prioridad := 7;
		XO.IdAct:= Self;
		Ofertar:= true;
	end;
end;

procedure TBateria01.AceptoDemanda(var XD:TFicha);
begin
	inherited AceptoDemanda(XD);
	Co:= Co +  XD.Energia/F2 * ng / ( 1+ CT * (TE - TN))/VN;
	{
	VG.agregar(Co);
	}
end;

procedure TBateria01.AceptoOferta(var XO:TFicha);
begin
	inherited AceptoOferta(XO);
	Co:= Co - XO.Energia/F2 / ( 1+ CT * (TE - TN))/VN;
	{
	VG.agregar(Co);
	}
end;



end.
