{+doc
+NOMBRE: Act_Bat
+CREACION: 23.02.1994
+AUTORES:  gcp,rch
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO:    Implementacin del TActor Batera.
+PROYECTO: SOLAR.

+REVISION:
+AUTOR:
+DESCRIPCION:
	Definicin del Actor TBateriaHD
	En este actor se agrega la definicion de los parmetros que definen
la forma en que se degrada la batera.-
	Al igual que TBateriaHD (definido en ActBat02) TBateriaHD construye
internamente un histograma de ciclado diario. El agregado es la definicion
en el actor de los parmetros de degradacin.-
-doc}
unit ActBat04;
interface
uses
	uescenario, ActBat02, xMatDefs, autoesca;


type

	TBateriaHD = class(TBateria01)
		x1, { [pu] profundidad de descarga x1 }
		x2, { [pu] profundidad de descarga x2 }
		y1, { [u] ciclos de vida a x1 }
		y2: { [u] ciclos de vida a x2 }
		NReal;
		constructor Create(
			escenario: TEscenario;
			xCN, xTN, xCT, xImaxR, xImaxD, xVN, xPM: NReal;
			xng: NReal;
			xx1, xx2, xy1, xy2: NReal);
		function DegradacionAnual: NReal; virtual;
	end;



implementation

{ mtodos de TBateriaHD }

constructor TBateriaHD.Create(
			escenario: TEscenario;
			xCN, xTN, xCT, xImaxR, xImaxD, xVN, xPM: NReal;
			xng: NReal;
			xx1, xx2, xy1, xy2: NReal);
begin
	inherited Nacer(escenario, xCN, xTN, xCT, xImaxR, xImaxD, xVN, xPM, 'xx', xng);
	x1:= xx1;
	x2:= xx2;
	y1:= xy1;
	y2:= xy2;
end;

function TBateriaHD.DegradacionAnual: NReal;
var
	k: integer;
	x: NReal;
	PDD, Deg, ciclos: NReal;
begin
	Deg:= 0;
	x:= Ciclado.x1-Ciclado.ddx/2;
	for k:=	1 to Ciclado.NPDiv do
	begin
		x:=x+Ciclado.ddx;
		PDD:= x/CN;
		ciclos:= exp10(
						log(y2)+ (log(y2)-log(y1))/(x2-x1)*(PDD-x2)
						);
		Deg:= Deg+ Ciclado.res_peso(k)*0.2/ciclos*365;
	end;
	DegradacionAnual:= Deg;
end;


end.