unit ActPan04;
{+doc
+NOMBRE: ActPan02
+CREACION: 18.8.1992
+AUTORES:  rz,rch
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO:
	Implementacin del TActor TPanel para el progrma de simulacin de
	energas SimEnerg. PASO MINIMO HORARIO.

+PROYECTO: SOLAR.

+REVISION:
	10.09.92/21.05/rch@home. Adaptacin de la vieja Act_Pan a una unidad
	donde se utiliza el Nucleo de Tiempos Nucleo_T
+AUTOR:

+DESCRIPCION:
-doc}

interface
uses
	Actores,
	uescenario,
	FDSol,
	IT4,
	NucleoT,
	xMatDefs;


Type

	TPanel = class(TActor)
		CPDD:NReal;
		Area,	{ rea del TPanel en m2 }

		Energia, { acumulada desde el ltimo latido del Director }
		beta:NReal; { ngulo de inclinacin del TPanel respecto de la
			horizontal en radianes }

		Rendimiento: NReal;

		F:TFuenteDeSol;  { Indice Zeballos de ruido tropofrico }



		constructor Create(
			escenario: TEscenario;
			xArea:NReal; { rea en m2 del TPanel }
			xF: TFuenteDeSol; { Fuente de energa solar }
			xBeta:NReal);  { ngulo de colocacin del TPanel }

		procedure Free; virtual;

		procedure Vivir; override;
		procedure Prepararse; override;

		function Demandar(var XD:TFicha):boolean; override;
		function Ofertar(var XO:TFicha):boolean; override;

		procedure CambioEstacion; override;{latente, cambia el rendimiento del TPanel
					simulando el efecto que tiene sobre el mismo la temperatura
					de la estacion en curso}

		procedure CadaHora; override;	{latente, recibe energa de la fuente de sol}
	end;


implementation



{$IFDEF PANLOG}
var
	panlog: text;
{$ENDIF}



{ Mtodos de TPanel }
constructor TPanel.Create(
			escenario: TEscenario;
			xArea:NReal; { rea en m2 del TPanel }
			xF: TFuenteDeSol; { Fuente de energa solar }
			xBeta:NReal);  { ngulo de colocacin del TPanel }

begin
	{ Agregar tareas latentes al ncleo de tiempos }
	inherited Create( escenario );

	Area:=xArea;
	F:=xF;

	F.beta:=xbeta/180*Pi;
	beta:=xbeta;

	IT4.IT_init(F.beta);

	Energia:=0;

	CambioEstacion; { Slo a los efectos de actualizar el rendimiento }

end;

procedure TPanel.Free;
begin
	inherited Free;
end;

procedure TPanel.Vivir;
begin
end;

procedure TPanel.Prepararse;
begin
end;

function TPanel.Demandar(var XD: TFicha):boolean;
begin
	Demandar:=false
end;



{ CambioHora, es un mtodo latente del TActor TPanel utilizado para
recibir energa de la fuente de sol. La energa es acumulada en la
variable Energia, la cual se limpia cada vez que el Director solicita
al TPanel que oferte }

procedure TPanel.CadaHora;
begin
	Energia:= Energia+ F.EnergiaDeLaHoraEnCurso;
end;


{ Este mtodo es uno por los que se comunica el director con el TPanel.
En este caso particular es para solicitar al TPanel que oferte la energa
que ha recibido en las horas transcurridas }

function TPanel.Ofertar(var XO: TFicha):boolean;
label
	fin;


begin
	{ Si es poca la energa no oferta }
	if Energia < AsumaCero then
	begin
		ofertar:=false;
		{$IFDEF PANLOG}
		writeln(panlog, energia, #9, diadelanio, #9, hora);
		{$ENDIF}
	end
	else
	begin

		{ Llenado de la TFicha de oferta }
		XO.energia := Rendimiento*Energia*Area;
		XO.prioridad := 1;
		XO.IdAct:= Self;
		{$IFDEF PANLOG}
		writeln(panlog, energia, #9, diadelanio, #9, hora);
		{$ENDIF}
		Ofertar:= true;

	end;

	{ Limpio el acumulador de energa }
	Energia:= 0;
end;


{ CambioEstacion,  es un procedimiento latente que se utiliza
para variar el rendimiento del TPanel a lo largo del ao para tener
en cuenta el efecto de la temperatura.
	Tambin cambiamos la inclinacin del TPanel al inicio de cada estacin }
procedure TPanel.CambioEstacion;
begin
	Case Escenario.tictac.Estacion of
		Verano:
		begin
			Rendimiento:= 0.1;
      {
			beta:=(F^.Lat-11.6)/180*Pi;
			F^.beta:=beta;
			IT_init(F^.beta);
      }
		end;

		Otonio, Primavera:
		begin
			Rendimiento:= 0.11;
      {
			beta:=(F^.Lat)/180*Pi;
			F^.beta:=beta;
			IT_init(F^.beta);
      }
		end;
		Invierno:
		begin
			Rendimiento:= 0.12;
      {
			beta:=(F^.Lat	+11.6)/180*Pi;
			F^.beta:=beta;
			IT_init(F^.beta);
      }
		end;
	end;
end;

{$IFDEF PANLOG}
var
	OldExitProc: pointer;
procedure CerrarPanLog; far;
begin
	ExitProc:= OldExitProc;
	close(panlog);
end;
{$ENDIF}


begin
writeln('actpan04-begin');
		{$IFDEF PANLOG}
		assign( panlog, 'panlog.log');
		rewrite(panlog);
		OldExitProc:=ExitProc;
		ExitProc:=@CerrarPanlog;
		{$ENDIF}

writeln('actpan04-end');
end.
