{+doc
+NOMBRE:   aeros.pas
+CREACION: 30.01.93
+AUTORES:  rch
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO:   Definicin del actor TAeroGenerador
+PROYECTO: autonoma/SimEnerg

+REVISION:
+AUTOR:
+DESCRIPCION:
	TAeroGenerador define el comportamiento genrico de los aerogeneradores
se define de manera tal que cuando se crea el actor se le indica de qu
archivo debe leer la curva de potencia.
-doc}

unit aeros;
interface
uses
	Horrores, Actores,
	uescenario,
	FntVnts, TabP2D,
	xMatDefs,
	Bases;

type
	TAeroGenerador = class(TActor)
		FYCB, { Factores Y Cambio de Base }
		FCP, { Factor de cambio de potencia }
		BaseVelocidad,
		BasePotencia: NReal;
		UltimaOferta: NReal;
		CostoEnDolares: NReal;
		AlturaEnMetros: NReal;
		Prioridad: TPrioridad;
		CPot : TTablaP2D;
		FDV : TFuenteDeViento;
		constructor Create(
			escenario: TEscenario;
			NombArchiDef:string;
			var FDV: TFuenteDeViento;
			xprioridad: TPrioridad);
		procedure Free; virtual;
		procedure Vivir;virtual;
		procedure Prepararse;virtual;
		function Ofertar(var XO:Tficha):boolean;virtual;
		function PotenciaActual: NReal;
		{ responde la potencia a la velocidad pasada como parmetro}
		function PotenciaVelocidad( Velocidad: NReal): NReal;
	end;


implementation




constructor TAeroGenerador.Create(
			escenario: TEscenario;
			NombArchiDef:string;
			var FDV: TFuenteDeViento;
			xPrioridad: TPrioridad);
var
	f:text;
	reng: string;
begin
	inherited Create( escenario );
	Prioridad:=xPrioridad;

	{ Cargamos la caracterstica Potencia-Velocidad para el aro-generador
	correspondiente }
	assign(f, NombArchiDef);
	{$I-}
	reset(f);
	{$I+}
	if ioresult<> 0 then Error(' No encuentro archivo: '+NombArchiDef );
	CPot:= TTablaP2d.LoadFromTextFile(f);
	readln(f, BaseVelocidad);
	readln(f, BasePotencia);

{???   OJO los por defectos deben dar, dentro de casa, un warning}
	{$I-}
	readln(f, CostoEnDolares );
	{$I+}
	if ioresult <> 0 then CostoEnDolares:=1;

	{$I-}
	readln(f, AlturaEnMetros );
	{$I+}
	if ioresult <> 0 then AlturaEnMetros:=10;
	close(f);

	{ Apuntamos la fuente de viento. La FDV, existe exterior al AeroGenerador
	y puede ser compartida por varios de ellos llegado el caso. En caso de
	una granga de AeroGeneradores, ser necesario crear ms de una FDV, para
	simular la interferencia entre molinos }

	Self.FDV:= FDV;

	ULtimaOferta:=0;
	FCP:= BasePotencia*(e_base/t_base);
end;







procedure TAeroGenerador.Free;
begin
	Cpot.Free;
	inherited Free;
end;

procedure TAeroGenerador.Vivir;
begin
end;

procedure TAeroGenerador.Prepararse;
begin
	FYCB:= BasePotencia/e_base*Escenario.PasoDetiempo*t_base;
end;


function TAeroGenerador.Ofertar(var XO:Tficha):boolean;
var
	PotPPT:NReal; { Potencia Promedio en el Paso de Tiempo }
begin
	XO.IdAct:= Self;
	PotPPT:= Cpot.yfval(FDV.Valor/BaseVelocidad);
	if PotPPT > AsumaCero then
	begin
		XO.Energia:=PotPPT*FYCB;
		XO.Prioridad:= Prioridad;
		Ofertar:= true;
	end
	else
	begin
		Ofertar:= false;
		XO.Energia:= 0;
	end;
	UltimaOferta:= XO.Energia;
end;

function TAeroGenerador.PotenciaActual: NReal;
begin
	PotenciaActual:= FCP*Cpot.yfval(FDV.Valor/BaseVelocidad);
end;

function TAeroGenerador.PotenciaVelocidad( Velocidad: NReal): NReal;
begin
	PotenciaVelocidad:= FCP*Cpot.yfval(Velocidad/BaseVelocidad);
end;


end.
