{+doc
+NOMBRE:
+CREACION:
+AUTORES:
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO: Definicin de los objetos (Histograma) y (Evaluador)
+PROYECTO: SOLAR.

+REVISION:
+AUTOR:
+DESCRIPCION:
-doc}

unit Evals02;
interface

uses
	Ancestor, ulistas, Actores, VGlbs02,
	xMatDefs;

type

	TCuenta = LongInt;

	LACuenta = array[0..10000] of TCuenta;
	p_LACuenta = ^LACuenta;

	THistograma = class( TBase )
		x0,x1,dx:NReal;
		NDiv:integer;
		Totales:TCuenta;
		pv: p_LACuenta;
		PotErr,PotHisto:NReal;

		constructor Create( xx0, xx1:NReal; xNDiv:integer);
		procedure Anotar( x:NReal);
		procedure Borrar;
		function PotenciaDeVariacionRelativa:NReal;

		function Peso( k:integer ):NReal;

		function AreaHastaBarra( k: integer ):NReal;
		function ValorMedio:NReal;
		function xArea( area: NReal): NReal;
		function jArea( area: NReal): NReal;

		procedure Maximo(
				var PesoMaximo:NReal;
				var PosicionDelMaximo: integer);
		procedure WriteTxt( var f: text );
		procedure Free; virtual;
	end;


	t_Evaluacion = (Exceso, Deficit);

	TEvaluador = class(TBase)
		histo:THistograma;
		P0,P1:integer;
		Tipo: T_Evaluacion;

		constructor Create(
			xP0, xP1:integer;
			xTipo:T_Evaluacion;
			xEmax:NReal;
			xEDiv:integer);

		procedure Evaluar;
		function GetValor:NReal;
		procedure Free; virtual;
	end;

implementation


{ - Metodos de Histograma - }

constructor THistograma.Create( xx0, xx1:NReal; xNDiv:integer);
begin
	inherited Create;
	x0:= xx0;
	x1:= xx1;
	NDiv:= xNdiv;
	dx:=(x1-x0)/NDiv;

	GetMem(pv,(NDiv + 2) * SizeOf(TCuenta));

	Totales:=0;
	PotErr:=0;
	Borrar;
end;

procedure THistograma.WriteTxt( var f: text );
var
	j: integer;
begin
	writeln(f, 'x0: ',x0, ' x1: ', x1,' NDiv: ',NDiv, ' dx: ', dx );
	writeln(f, 'Totales: ',totales:8, ' Menores: ', pv^[0]:8 ,' Mayores: ', pv^[NDiv+1]:8);
	for j:= 1 to NDiv do
		write(f, pv^[j]:8 );
	writeln(f);
end;


procedure THistograma.Anotar( x:NReal);
var
	jk:Longint;
	k:Tcuenta;

begin

	k:=Totales;

	jk := trunc(( x - x0 ) /dx ) +1;

	if jk < 1 then jk:=0;
	if jk > NDiv then jk:=Ndiv+1;

 {
	PotErr:=((2*k+1)*PotHisto+1)/sqr(k+1);
	PotHisto:= (sqr(k) * PotHisto + 2 * pv^[jk] + 1) / sqr(k+1);
	}

	pv^[jk]:=pv^[jk]+1;
	Totales:=Totales+1;
end;

procedure THistograma.Borrar;
var
	k:integer;
begin
	for k:= 0 to Ndiv+1 do
		pv^[k]:=0;
end;


function THistograma.Peso( k:integer ):NReal;
begin
	if totales=0 then Peso:=1/NDiv
	else	Peso:=pv^[k]/totales;
end;

function THistograma.AreaHastaBarra( k: integer ):NReal;
var
	a: NReal;
	h: integer;
begin
	a:= Peso(0);
	for h:= 1 to k do a:= a+ Peso(h);
	AreaHastaBarra:= a;
end;


function THistograma.xArea( area: NReal): NReal;
begin
	xArea:= x0+dx*jArea(area);
end;

function THistograma.jArea( area: NReal): NReal;
var
	k:integer;
	x:Nreal;
begin
	k:=0;
	while (AreaHastaBarra(k) < area) do inc(k);
	if k=0 then x:=area/AreaHastaBarra(0)-1
	else
		x:= (Area-AreaHastaBarra(k-1))/(AreaHastaBarra(k)-AreaHastaBarra(k-1))+k-1;
	jArea:=x;
end;


function THistograma.ValorMedio:NReal;
var
	k:integer;
	m:NReal;
begin
	m:=0;
	for k:= 0 to Ndiv+1 do
		m:=m+peso(k)*((x0-dx/2)+k*dx);
	valorMedio:= m;
end;


procedure THistograma.Maximo(
		var PesoMaximo:NReal;
		var PosicionDelMaximo: integer);
var
	k, j:integer;
	m:NReal;
begin
	m:=pv^[0]; j:= 0;
	for k:= 1 to Ndiv+1 do
		if pv^[k]>m then
		begin
			m:= pv^[k];
			j:=k;
		end;
	PesoMaximo:= Peso(j);
	PosicionDelMaximo:= j;
end;

function THistograma.PotenciaDeVariacionRelativa:NReal;
begin
	PotenciaDeVariacionRelativa:=PotErr/PotHisto;
end;



procedure THistograma.Free;
begin
	FreeMem(pv,(NDiv + 2) * SizeOf(TCuenta));
	inherited Free;
end;



{ - Metodos de Evaluador - }


constructor TEvaluador.Create(
			xP0, xP1:integer;
			xTipo:T_Evaluacion;
			xEmax:NReal;
			xEDiv:integer);
begin
	inherited Create;
	Histo:= THistograma.Create(0,xEmax,xEDiv);
	Tipo:=xTipo;
	P0:=xP0;
	P1:=xP1
end;


procedure TEvaluador.Evaluar;
begin
	histo.anotar(GetValor);
end;


function TEvaluador.GetValor:NReal;
var
	p:nodoPtr;
	acum:NReal;
	k:integer;
begin
	if Tipo = Exceso then
	begin
		p:=Escenario.seres.ultimo;
		acum:=0;
		while p<> nil do
		begin
			for k:= p0 to p1 do
				acum:= acum + TActor(p^.item).ExcesoPrioridad(k);
			p:=Escenario.seres.anterior(p);
		end;
		GetValor:=acum;
	end
	else
	begin
		p:=Escenario.seres.ultimo;
		acum:=0;
		while p<> nil do
		begin
			for k:= p0 to p1 do
				acum:= acum + TActor(p^.item).DeficitPrioridad(k);
			p:=Escenario.seres.anterior(p);
		end;
		GetValor:=acum;
	end
end;


procedure TEvaluador.Free;
begin
	histo.Free;
	inherited Free;
end;

end.

