{+doc
+NOMBRE:
+CREACION:21.09.92
+AUTORES: rch, rz
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO:  Definicin del objeto FuenteDeSol. Cuando Se Inicializa se
	indica el nombre de archivo con datos de radicacin global diaria en
	plano horizontal. El formato del archivo es en cada renglon
	dia mes anio dato
	donde
		dia : T_DiaDelAnio
		mes : T_Mes
		Anio: T_Anio
    Dato: real [WH/m2]


	En el metodo (CadaDia(o debiera decir NuevoDia??gcp)) se lee un nuevo renglon y se verifica que corres-
	ponde al dia de la simulacion en curso.

+PROYECTO: SOLAR.

+REVISION:
+AUTOR:
+DESCRIPCION:
-doc}

unit FDSol03;
interface
uses
	uEscenario,
	NucleoT, horrores,  FDsol,
	IT4;

var
	modelo: string;
	 { 'Liu-Jordan', 'Perez' y 'HDKR'}

type


	TFDeSolDat = class( TFuenteDeSol)

		xEnergiaDelDia: real; { Cantidad de energa que se irradiar
						durante el da en curso }
		f: text;
		PrimerDia, UltimoDia: T_DiaDelAnio;
		PrimerMes, UltimoMes: integer;
		PrimerAnio, UltimoAnio: T_Anio;


		constructor Create(
			Escenario: TEscenario;
			ArchDat: string);

		function Valor:real; override;
		procedure Free; virtual;
		function EnergiaDeLaHoraEnCurso:real; override;
		function EnergiaDelDia: real; override;
		procedure CadaDia; override; { latente }
	end;



implementation



constructor TFDeSolDat.Create(
			Escenario: TEscenario;
			ArchDat: string);
var
	Dato: real;

begin
	inherited Create( escenario);

	assign( f, ArchDat);
	{$I-}
	reset(f);
	{$I+}
	if ioresult <> 0 then error(' No encuentro archivo: '+ArchDat);

	readln(f,  PrimerDia, PrimerMes, PrimerAnio, Dato);

	while not eof(f) do
		readln(f, UltimoDia, UltimoMes, UltimoAnio, Dato);
	reset(f);

	{NuevoDia;} { Actualiza el valor de energa para el da actual }

	{ Notificacin al ncleo de tiempo de los procedimientos latentes }

end;





procedure  TFDeSolDat.CadaDia;
var
	NDia, NMes: integer;
	NAnio: LongInt;
	ferr: text;

begin
	readln(f,  NDia, NMes, NAnio, xEnergiaDelDia );
	if
		(NDia<> Escenario.TicTac.DiaDelMes) or
		(T_Mes(NMes-1) <> Escenario.TicTac.Mes) or
		(NAnio <> Escenario.TicTac.Anio) then
		begin
			assign(ferr, 'errores.sal');
			rewrite(ferr);
			writeln( ferr, NDia, Escenario.TicTac.DiaDelAnio );
			writeln( ferr, NMes-1, Ord(Escenario.TicTac.Mes));
			writeln( ferr, NAnio, Escenario.TicTac.Anio);
			close(ferr);
			error(' fecha no conincidente en datos de sol');
		end;

		xEnergiaDelDia:= it4.NuevoDia(
			Escenario.TicTac.DiaDelAnio,
			beta,
			modelo,
			xEnergiaDelDia
	 )*3600 { [WH/m2], energa diaria en el plano inclinado }
end;

function TFDeSolDat.EnergiaDelDia: real;
begin
	EnergiaDelDia:= xEnergiaDelDia;
end;


function TFDeSolDat.EnergiaDeLaHoraEnCurso:real;
begin
		EnergiaDeLaHoraEnCurso:= EnergiaHoraPtr^[Escenario.TicTac.hora]*3600;
end;

function TFDeSolDat.Valor;
begin
	Valor:=EnergiaDelDia;
end;

procedure TFDeSolDat.Free;
begin
	closeFile( f );
	inherited Free;
end;

begin
	modelo:=	'Liu-Jordan';{, 'Perez' y 'HDKR'}
end.