{+doc
+NOMBRE: fntvnts
+CREACION: 30.1.93
+AUTORES: rch
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO:  Definicin de las fuentes de viento
+PROYECTO: autonoma/SimEnerg

+REVISION:
+AUTOR:
+DESCRIPCION: Los archivos de datos se consideran en [km/h] y empezando
el da 1 de enero.
-doc}

unit FntVnts;
interface
uses
	Horrores;

type
	TFuenteDeViento = class
		factor: extended;
		f: file of extended;
		UltimoValor: extended;
		constructor create(xSpeedUP: extended; ArchivoDeDatos: string);
		function Valor: extended;virtual;
		procedure Free; virtual;
	end;

implementation

function TFuenteDeViento.Valor:extended;
begin
	if eof(f) then reset(f);(*	error(' lleg a fin de archivo'); *)
	read(f,UltimoValor);
	if UltimoValor<0.5 then UltimoValor:= 0
	else UltimoValor:= UltimoValor*factor;
	Valor:= UltimoValor;
end;

constructor TFuenteDeViento.create(xSpeedUP: extended; ArchivoDeDatos: string);
begin
	factor:= xSpeedUP/3.6;
	assign(f, ArchivoDeDatos);
	{$I-}
	reset(f);
	{$I+}
	if ioresult <> 0 then
					 error('abriendo archivo de datos de vientos. '+ArchivoDeDatos);
end;

procedure TFuenteDeViento.Free;
begin
	closefile(f);
end;

end.
