{+doc
+NOMBRE: PlotHist
+CREACION:
+AUTORES:
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO:
+PROYECTO:

+REVISION:
+AUTOR:
+DESCRIPCION:
-doc}

unit PlotHist;
interface
uses
	{$I xTraxp},
	Autoesca, Evals02, xMatDefs, OcurrenX;

procedure PlotHistograma(
	kanal: integer;
	var H: THistograma;
	stitulo, sxlabel: string );

procedure PlotTOcurrencias(
	kanal: integer;
	var H: TOcurrencias;
	stitulo, sxlabel: string );


implementation


procedure PlotHistograma(
	kanal: integer;
	var H: THistograma;
	stitulo, sxlabel: string );

var
	PesoMaximo:NReal;
	PosicionDelMaximo:integer;
	pbase:NReal;
	OldGridX, OldGridY: integer;
	dx:NReal;
	k:integer;
	xt, yt: NReal;
	sty: string;
	acum: NReal;

begin
	BorreCanal(kanal, Negro);
	OldGridX:= GridX;
	OldGridY:= GridY;
	h.Maximo( PesoMaximo, PosicionDelMaximo );
	pbase:=0;
	GridY:= 10;
	Escala125N(pbase, PesoMaximo,dx,GridY,1);
	str(dx*100:3:1, sty);
	sty:= '['+sty+'%/DIV]';
	GridX:=h.Ndiv+2;
	{ Consideramos que el (kanal) ya fue inicializado }
	definaX(kanal,-1,1);
	definaY(kanal,pbase, dx);
	borde;
	linea0;
	grid;
	titulo(stitulo);
	xlabel(sxlabel);
	ylabel(sty);
	desligue(kanal);
	trazoXY(kanal, -1,pbase);
	for k:= 0 to h.Ndiv+1 do
		barraXY(kanal,k,h.peso(k));

	acum:=0;
	desligue(kanal);
	trazoXY(kanal, -1,pbase);

	for k:= 0 to h.Ndiv+1 do
	begin
		acum:=acum+h.peso(k)*GridY*dx;
		trazoXY(kanal,k,acum);
	end;


	desligue(kanal);
	xt:= 0;
	{$IFNDEF WINDOWS}
	trazoXYColorEstilo(kanal, xt, pbase, Verde, ce_Solido);
	trazoXYColorEstilo(kanal, xt, pbase+GridY*dx, Verde, ce_Solido);
  {$ENDIF}


	desligue(kanal);
	xt:= h.jArea(0.1);
	{$IFNDEF WINDOWS}
	trazoXYColorEstilo(kanal, xt, pbase, Rojo, ce_Solido);
	trazoXYColorEstilo(kanal, xt, pbase+GridY*dx, Rojo, ce_Solido);
  {$ENDIF}

	desligue(kanal);
	xt:= h.jArea(0.5);
	{$IFNDEF WINDOWS}
	trazoXYColorEstilo(kanal, xt, pbase, Rojo, ce_Solido);
	trazoXYColorEstilo(kanal, xt, pbase+GridY*dx, Rojo, ce_Solido);
	{$ENDIF}

	desligue(kanal);
	xt:= h.jArea(0.9);

	{$IFNDEF WINDOWS}
	trazoXYColorEstilo(kanal, xt, pbase, Rojo, ce_Solido);
	trazoXYColorEstilo(kanal, xt, pbase+GridY*dx, Rojo, ce_Solido);
  {$ENDIF}

	desligue(kanal);
	xt:= h.NDIV;

	{$IFNDEF WINDOWS}
	trazoXYColorEstilo(kanal, xt, pbase, Verde, ce_Solido);
	trazoXYColorEstilo(kanal, xt, pbase+GridY*dx, Verde, ce_Solido);
	{$ENDIF}

	GridY:= OldGridY;
	GridX:= OldGridX;
end;


procedure PlotTOcurrencias(
	kanal: integer;
	var H: TOcurrencias;
	stitulo, sxlabel: string );

var
	hist: THistograma;
	k: integer;

begin
	hist:= THistograma.Create( h.x1, h.x1+h.dx, h.NPDiv );

	hist.pv^[0]:= h.menores;
	for k:= 1 to h.NPDiv do
		hist.pv^[k]:= h.v^[k];
	hist.pv^[h.NPDIV+1]:= h.mayores;
	hist.Totales:= h.Total;

	PlotHistograma( kanal, hist,	stitulo, sxlabel );
	hist.Free;

end;

end.