unit Actores;
{+doc
+NOMBRE: Actores
+CREACION: 31.3.1992
+AUTORES:  rch,rz
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO:  Definicin del Objeto (TActor) para el programa SimEnerg
+PROYECTO: AUTONOMA.

+REVISION:
+AUTOR:
+DESCRIPCION:
-doc}

interface
uses

	VGlbs02,
	Ancestor,
	uSeresVivos,
	xMatDefs,
	uescenario;

Type



	CuentaEnergias = array[1..MaxNumPrior] of NReal;

  TPrioridad = 1..MaxNumPrior;

	TFicha = class( TBase )
		Energia: NReal;
		Prioridad: TPrioridad;
		IdAct: TBase; { Identificador del TActor }
		constructor Create( fichaCopiar: TFicha );
	end;

	TActor = class( TSerVivo )
{		TransaccionEnCurso: TipoTransaccion; ???}

		AcumDeficit, AcumExceso,
		AcumOferta, AcumDemanda: CuentaEnergias;
		UltimoDeficit, UltimoExceso,
		UltimaOfertaAceptada, UltimaDemandaCumplida: NReal;

		constructor Create( escenario: TBase );
		procedure Free;virtual;

		procedure Vivir;virtual;
		procedure Prepararse;virtual;

		function Demandar(var XD:TFicha ):boolean;virtual;
		function Ofertar(var XO:TFicha ):boolean;virtual;

		procedure RechazoOferta(var XO:TFicha);virtual;
		procedure RechazoDemanda(var XD:TFicha);virtual;
		procedure AceptoDemanda(var XD:TFicha);virtual;
		procedure AceptoOferta(var XO:TFicha);virtual;

		function ExcesoPrioridad( np:integer ):NReal;virtual;
		function DeficitPrioridad(np: integer):NReal;virtual;

		function OfertaPrioridad(np: integer):NReal;virtual;
		function DemandaPrioridad(np: integer):NReal;virtual;

		procedure ComienzaNuevoPeriodo; virtual;
		procedure LimpiarUltimos;

		function Escenario: TEscenario; // retorna referencia al escenario

	end;




implementation

constructor TFicha.Create( fichaCopiar: TFicha );
begin
	if fichaCopiar <> nil then
	begin
		Energia:= fichaCopiar.Energia;
		Prioridad:= fichaCopiar.Prioridad;
		IdAct:= fichaCopiar.IdAct;
	end
	else
	begin
		Energia:= 0;
		Prioridad:= 1;
		IdAct:= nil;
	end;
end;



{ Mtodos de TActor }




constructor TActor.Create( escenario: TBase );
begin
	inherited Create( escenario );
	TEscenario(Escenario).seres.append(Self);
	LimpiarUltimos;
end;


procedure TActor.Free;
begin
	inherited Free;
end;

procedure TActor.Vivir;
begin
end;

procedure TActor.Prepararse;
begin

end;

procedure TActor.LimpiarUltimos;
begin
	UltimoDeficit:= 0;
	UltimoExceso:= 0;
	UltimaOfertaAceptada:= 0;
	UltimaDemandaCumplida:=0;
end;

function TActor.Demandar(var XD:TFicha):boolean;
begin
	XD.IdAct:=Self;
	Demandar:=false;
end;

function TActor.Ofertar(var XO:TFicha):boolean;
begin
	XO.IdAct:=Self;
	Ofertar:=false;
end;

procedure TActor.RechazoOferta(var XO:TFicha);
begin
	AcumExceso[XO.prioridad]:=AcumExceso[XO.prioridad]+XO.energia;
	UltimoExceso:= XO.energia;
end;

procedure TActor.RechazoDemanda(var XD:TFicha);
begin
	AcumDeficit[XD.prioridad]:=AcumDeficit[XD.prioridad]+XD.energia;
	UltimoDeficit:= XD.Energia;
end;

procedure TActor.AceptoDemanda(var XD:TFicha);
begin
	AcumDemanda[XD.prioridad]:=AcumDemanda[XD.prioridad]+XD.energia;
	UltimaDemandaCumplida:= XD.energia;
end;

procedure TActor.AceptoOferta(var XO:TFicha);
begin
	AcumOferta[XO.prioridad]:=AcumOferta[XO.prioridad]+XO.energia;
	UltimaOfertaAceptada:= XO.Energia;
end;

function TActor.ExcesoPrioridad( np:integer ):NReal;
begin
	ExcesoPrioridad:=AcumExceso[np];
end;

function TActor.DeficitPrioridad(np: integer):NReal;
begin
	DeficitPrioridad:=AcumDeficit[np];
end;

function TActor.OfertaPrioridad(np: integer):NReal;
begin
	OfertaPrioridad:=AcumOferta[np];
end;

function TActor.DemandaPrioridad(np: integer):NReal;
begin
	DemandaPrioridad:=AcumDemanda[np];
end;


procedure TActor.ComienzaNuevoPeriodo;
var
	k:Integer;
begin
	for k:= 1 to MaxNumPrior do
	begin
		AcumDeficit[k]:=0;
		AcumExceso[k]:=0;
		AcumOferta[k]:=0;
		AcumDemanda[k]:=0;
	end
end;

function TActor.Escenario: TEscenario; // retorna referencia al escenario
begin
	result:= TEscenario( escn );
end;

end.
