{+doc
+NOMBRE: autoesca
+CREACION: 1.1.1990
+AUTORES: rch
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO:Sevicios de calculo de escalas automaticas
+PROYECTO:rchlib

+REVISION:
+AUTOR:
+DESCRIPCION:
-doc}

unit AutoEsca;

interface
uses
	xMatDefs;

type



	Escala = object
		grid, n, a:integer;
		xm1,xm2:NReal;
		constructor Init(x1,x2:NReal);
	end;


procedure Escala125N(var x1,x2,dx:NReal;var N:integer;MODO:integer);
{
	Entradas:
		x1,x2 = rango  de valores que se desea cubrir.
		N = nmero de divisiones aprox. que se desea.
		MODO = modo en que se aproximar el intervalo.
		 MODO = 0, aproximar por adentro.
		 MODO = 1, aproximar por afuera.
	Salidas:
		x1,x2 = rango que se cubrir. Calculado en al grilla de salida.
		Si Modo:=1 se el rango de salida aproxima al de entrada
		incluyendolo, por el contrario si Modo=0 lo aproxima sin
		incluir los extremos originales.(Lo aproxima por adentro).
		dx = ancho de una divisin. Se cumple que:
			dx = an * exp10(a), donde an =(1,2,5) y a:integer.
		N = nmero de divisiones que se tendrn.
}

function IntInf(x:NReal):integer;
	{ IntInf <= x < IntInf + 1 }

function IntSup(x:NReal):integer;
	{ IntSup - 1 < x <= IntSup }

function Log(x:NReal):NReal;
	{ Logaritmo en base 10 }

function Exp10(x:NReal):NReal;
	{ 10 elevado al la x }



implementation
var
	ln10:NReal;

function IntInf(x:NReal):integer;
var
	temp:integer;
begin
	temp:=trunc(x);
	if temp = x then IntInf:=temp
	else
		if x > 0 then IntInf:=temp
		else IntInf:=temp-1
end;

function IntSup(x:NReal):integer;
var
	temp:integer;
begin
	temp:=trunc(x);
	if temp = x then IntSup:=temp
	else
		if x > 0 then IntSup:=temp+1
		else IntSup:=temp
end;


function Log(x:NReal):NReal;
begin
	Log:=ln(x)/ln10;
end;

function Exp10(x:NReal):NReal;
begin
	exp10:=exp(x*ln10);
end;

constructor Escala.Init(x1,x2:NReal);
var
	dx:NReal;
	temp:integer;

procedure v(gridx,nx:integer);
begin
	n:=nx;
	grid:=gridx;
end;

begin
	dx:=x2-x1;
	a:=IntSup(log(dx/50));
	temp:=IntSup(dx * exp10(-a));
	case temp of
		5	 		:v(5,1);
		6..8 		:v(8,1);
		9..10		:v(10,1);
		11..16	:v(8,2);
		17..20	:v(10,2);
		21..25	:v(5,5);
		26..40	:v(8,5);
		41..50	:v(10,5);
	end;
	temp:=IntInf(x1/exp10(a)/n);
	xm1:=temp*exp10(a)*n;
	xm2:=(temp+grid)*exp10(a)*n;
end;

procedure Escala125N(var x1,x2,dx:NReal;var N:integer;MODO:integer);
var
	m,aux:NReal;
	n1,n2,k,j:integer;
	temp:array[1..3] of NReal;
	a:array[1..3] of integer;
	expo:NReal;
begin
	aux:=log(x2-x1);
	temp[1]:=log(N);
	temp[2]:=log(2*N);
	temp[3]:=log(5*N);
	if MODO = 1 then
	begin
		m:=1e30; j:=0;
		for k:=1 to 3 do
		begin
			a[k]:=IntSup(aux-temp[k]);
			if temp[k]+a[k]<m then
				begin
					m:=temp[k]+a[k];
					j:=k;
				end
		end
	end
	else
	begin
		m:=-1e30; j:=0;
		for k:=1 to 3 do
		begin
			a[k]:=IntInf(aux-temp[k]);
			if temp[k]+a[k]>m then
				begin
					m:=temp[k]+a[k];
					j:=k;
				end
		end
	end;

	if j = 3 then dx := 5
	else dx:=j;

	expo:=a[j];
	aux:=exp10(expo)*dx;
	if MODO = 1 then
	begin
		n1:=IntInf{Sup}(x1/aux);
		n2:=IntSup{Inf}(x2/aux);
	end
	else
	begin
		n1:=IntSup(x1/aux);
		n2:=IntInf(x2/aux);
	end;
	n:=n2-n1;
	x1:=n1*aux;
	x2:=n2*aux;

	dx:=aux;
end;

begin
	ln10:=ln(10);
end.