{+doc
+NOMBRE: DEMht
+CREACION: 3.11.92
+AUTORES:
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO: Demandante02 es una carga a la que se le puede difinir
	potencia, hora en que se prende, hora en que se apaga y prioridad
	con que demanda. Este demandante funciona bien slo si el paso de
	tiempo es <= 1 Hora
+PROYECTO: SOLAR.

+REVISION:
+AUTOR:
+DESCRIPCION:
-doc}
unit demht;
interface

uses
	uescenario, NucleoT, Actores,
	xMatDefs, bases;

type


	TRecHorasPA = array[0..3] of T_Hora;
	PPerfilCDC = ^TPerfilCDC;
	TPerfilCDC = array[0..23] of NReal;
	PEstacionalesCDC = ^TEstacionalesCDC;
	TEstacionalesCDC = array[Enero..Diciembre] of NReal;

	TDemHT = class(TActor)
		Prioridad:integer;
		Prendido: boolean;
		rInvierno, rPrim_Otonio, rVerano, TR: TRecHorasPA;
		Energia: PPerfilCDC;
		pEsts: PEstacionalesCDC;

		constructor Create(
			escenario: TEscenario;
			xPerfil: PPerfilCDC;
			xEstacionales: PEstacionalesCDC;
			xPrioridad:integer );

		function Demandar(var XD:TFicha):boolean;virtual;
		procedure AcumQ( var Q:NReal);
	end;



implementation




constructor TDemHT.Create(
			escenario: TEscenario;
			xPerfil: PPerfilCDC;
			xEstacionales: PEstacionalesCDC;
			xPrioridad:integer );

var
	k:integer;

begin
	inherited Create( escenario );
	Energia:= xPerfil;
	PEsts:= xEstacionales;
	for k:= 0 to 23 do Energia^[k]:=xPerfil^[k]*Escenario.PasoDeTiempo*1000;
				{*1000 porque el perfilCDC esta en kW}
	Prioridad:=xPrioridad;

end;

procedure TDemHT.AcumQ( var Q:NReal);
var
	th:NReal;
	h: integer;
	m: NReal;
	mes: T_Mes;

begin
	th := 0;
	for mes:= Enero to Diciembre do
	begin
		m:= pEsts^[mes];
		for h:= 0 to 23 do
			th:= th+ Energia^[h]*m*30;
	end;
	Q:= Q+ th/(30*12);
end;




function TDemHT.Demandar(var XD:TFicha):boolean;
begin
		XD.energia :=  Energia^[Escenario.tictac.hora]* pEsts^[Escenario.tictac.mes];
		XD.prioridad := Prioridad;
		XD.IdAct:= Self;
		Demandar:= true;
end;



end.