{+doc
+NOMBRE: Dire02
+CREACION: 24.09.92
+AUTORES:  rch,rz
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO:  Definicin del (Director) de escena para el programa SimEnerg
+PROYECTO: AUTONOMA.

+REVISION:
+AUTOR: rch
+DESCRIPCION: Variacin de la verisin Dire01 a la utilizacin del
Ncleo de Tiempos.
-doc}
unit Dire02;

interface

uses
{$IFDEF WIN32DELPHI}
	Forms,
{$ENDIF}
	OfeDem02, VGlbs02, NucleoT, ulistas, Actores, uescenario;


{ Lleva a cabo la simulacin }
procedure Simular;

{ Procedimiento Latente, se encarga de resolver las ofertas y las
demandas de los actores y de resolver las transacciones. El despachador
al que se agrege este procedimiento es quien fija el "paso de simulacin" }
procedure Gestion( var Alp);

{ Procedimiento Latente, Llama al plroceimiento Pescar del Usuario y
prepara a los actores para comenzar un nuevo periodo. Debe agregarse
este procedimiento a alguno de los despachadores de NucleoT }
procedure CadaPeriodoDeEvaluacion( var alp );


{procedure ComienzaNuevoPeriodo;}





implementation


procedure Nacer;
begin
	Escenario:= TEscenario.Create;
end;

procedure Morir;
begin
	Escenario.Free;
end;



procedure Prepararse;
var
	p: nodoPtr;
begin
	p:=Escenario.seres.ultimo;
	while p<> nil do
	begin
		TActor(p^.item).prepararse;
		p:=Escenario.seres.anterior(p);
	end;
end;


procedure VivirActores;
var
	p: nodoPtr;
begin
	p:=Escenario.seres.ultimo;
	while p<> nil do
	begin
		TActor(p^.item).vivir;
		p:=Escenario.seres.anterior(p);
	end;
end;


procedure ComienzaNuevoPeriodo;
var
	p: nodoPtr;
begin
	p:=Escenario.seres.ultimo;
	while p<> nil do
	begin
		TActor(p^.item).ComienzaNuevoPeriodo;
		p:=Escenario.seres.anterior(p);
	end;
end;



procedure Simular;
begin

	{ Inicializar el Escenario }
	Nacer;

	{ Correr procedimiento de arranque del usuario }
	Proc_Arrancar;

	ChequearInicializaciones;


	{ Indica a los actores que se preparen para comenzar la simulacin.
		Esta es la oportunidad que tienen los actores para chequear el
		(pasoDeTiempo) con que se pretende correr. }
	Prepararse;

	{ Indicamos el comienzo de un nuevo periodo de evaluacin. Se
	borran los acumulados llevados para cada prioridad por los actores }
	ComienzaNuevoPeriodo;

	NumeroDePeriodo := 1;

	while NumeroDePeriodo < Escenario.PeriodosTotales do
	begin
                {$IFDEF WIN32DELPHI}
		application.ProcessMessages;
                {$ENDIF}
		Escenario.tictac.tic;
	end;


	Proc_Finalizar;

end;

{ Procedimiento Latente, se encarga de resolver las ofertas y las
demandas de los actores y de resolver las transacciones }


procedure Gestion( var Alp);
begin
	LimpiarVariablesDeUltimos;
	RecogerOfertasYDemandas;
	ResolverTransacciones;
end;

{ Procedimiento Latente, Llama al plroceimiento Pescar del Usuario y
prepara a los actores para comenzar un nuevo periodo }
procedure CadaPeriodoDeEvaluacion( var alp );
begin
	Proc_Pescar;
	NumeroDePeriodo:=NumeroDePeriodo+1;
	ComienzaNuevoPeriodo;
end;



end.
